/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.animation.easing;

import com.alee.managers.animation.easing.AbstractEasing;
import com.thoughtworks.xstream.annotations.XStreamAlias;

public abstract class Exponential
extends AbstractEasing {
    @Override
    public String getTitle() {
        return "Exponential";
    }

    @XStreamAlias(value="Exponential$InOut")
    public static final class InOut
    extends Exponential {
        @Override
        public String getTitle() {
            return super.getTitle() + " InOut";
        }

        @Override
        protected double calculateImpl(double start2, double distance, double current, double total) {
            if ((current /= total / 2.0) < 1.0) {
                return distance / 2.0 * Math.pow(2.0, 10.0 * (current - 1.0)) + start2;
            }
            return distance / 2.0 * (-Math.pow(2.0, -10.0 * (current -= 1.0)) + 2.0) + start2;
        }
    }

    @XStreamAlias(value="Exponential$Out")
    public static final class Out
    extends Exponential {
        @Override
        public String getTitle() {
            return super.getTitle() + " Out";
        }

        @Override
        protected double calculateImpl(double start2, double distance, double current, double total) {
            return distance * (-Math.pow(2.0, -10.0 * current / total) + 1.0) + start2;
        }
    }

    @XStreamAlias(value="Exponential$In")
    public static final class In
    extends Exponential {
        @Override
        public String getTitle() {
            return super.getTitle() + " In";
        }

        @Override
        protected double calculateImpl(double start2, double distance, double current, double total) {
            if (current == 0.0) {
                return start2;
            }
            if (current == total) {
                return start2 + distance;
            }
            return distance * Math.pow(2.0, 10.0 * (current / total - 1.0)) + start2;
        }
    }
}

