/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.animation.easing;

import com.alee.managers.animation.easing.AbstractEasing;
import com.thoughtworks.xstream.annotations.XStreamAlias;

public abstract class Quadratic
extends AbstractEasing {
    @Override
    public String getTitle() {
        return "Quadratic";
    }

    @XStreamAlias(value="Quadratic$InOut")
    public static final class InOut
    extends Quadratic {
        @Override
        public String getTitle() {
            return super.getTitle() + " InOut";
        }

        @Override
        protected double calculateImpl(double start2, double distance, double current, double total) {
            if ((current /= total / 2.0) < 1.0) {
                return distance / 2.0 * current * current + start2;
            }
            return -distance / 2.0 * ((current -= 1.0) * (current - 2.0) - 1.0) + start2;
        }
    }

    @XStreamAlias(value="Quadratic$Out")
    public static final class Out
    extends Quadratic {
        @Override
        public String getTitle() {
            return super.getTitle() + " Out";
        }

        @Override
        protected double calculateImpl(double start2, double distance, double current, double total) {
            return -distance * (current /= total) * (current - 2.0) + start2;
        }
    }

    @XStreamAlias(value="Quadratic$In")
    public static final class In
    extends Quadratic {
        @Override
        public String getTitle() {
            return super.getTitle() + " In";
        }

        @Override
        protected double calculateImpl(double start2, double distance, double current, double total) {
            return distance * (current /= total) * current + start2;
        }
    }
}

