/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.drag.view;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.managers.drag.view.DragViewHandler;
import com.alee.managers.language.LM;
import com.alee.painter.decoration.content.TextRasterization;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.LafUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public abstract class SimpleDragViewHandler<T>
implements DragViewHandler<T> {
    protected static final Insets margin = new Insets(6, 6, 6, 6);
    protected static final int textSideSpacing = 3;

    @NotNull
    protected FontMetrics getFontMetrics(@NotNull T object) {
        return SwingUtils.getDefaultLabelFontMetrics();
    }

    @Nullable
    protected abstract Icon getIcon(@NotNull T var1);

    @Nullable
    protected abstract Color getForeground(@NotNull T var1);

    @NotNull
    protected abstract String getText(@NotNull T var1);

    @Override
    @NotNull
    public BufferedImage getView(@NotNull T object, @NotNull DragSourceDragEvent event) {
        Icon icon = this.getIcon(object);
        Color foreground = this.getForeground(object);
        String title = LM.get(this.getText(object), new Object[0]);
        FontMetrics fm = this.getFontMetrics(object);
        int tm = SimpleDragViewHandler.margin.left + (icon != null ? icon.getIconWidth() + 4 : 3);
        int em = SimpleDragViewHandler.margin.right + 3;
        int w = tm + fm.stringWidth(title) + em;
        int h = SimpleDragViewHandler.margin.top + Math.max(icon != null ? icon.getIconHeight() : 0, fm.getHeight()) + SimpleDragViewHandler.margin.bottom;
        BufferedImage image = ImageUtils.createCompatibleImage(w, h, 3);
        Graphics2D g2d = image.createGraphics();
        GraphicsUtils.setupAlphaComposite(g2d, Float.valueOf(0.8f));
        GraphicsUtils.setupFont(g2d, fm.getFont());
        SwingUtils.setupTextAntialias(g2d, TextRasterization.subpixel);
        g2d.setPaint(Color.WHITE);
        g2d.fillRect(0, 0, w, h);
        g2d.setPaint(Color.LIGHT_GRAY);
        g2d.drawRect(0, 0, w - 1, h - 1);
        if (icon != null) {
            icon.paintIcon(null, g2d, SimpleDragViewHandler.margin.left, SimpleDragViewHandler.margin.top);
        }
        g2d.setPaint(foreground != null ? foreground : Color.BLACK);
        g2d.drawString(title, tm, SimpleDragViewHandler.margin.top + (h - SimpleDragViewHandler.margin.top - SimpleDragViewHandler.margin.bottom) / 2 + LafUtils.getTextCenterShiftY(fm));
        g2d.dispose();
        return image;
    }

    @Override
    @NotNull
    public Point getViewRelativeLocation(@NotNull T document, DragSourceDragEvent event, @NotNull BufferedImage view) {
        return new Point(25, 5);
    }

    @Override
    public void dragEnded(@NotNull T object, @NotNull DragSourceDropEvent event) {
    }
}

