/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.glasspane;

import com.alee.api.annotations.NotNull;
import com.alee.extended.layout.MultiLayout;
import com.alee.laf.panel.WebPanel;
import com.alee.managers.style.StyleId;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.TextUtils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;

public class WebGlassPane
extends WebPanel {
    protected static final String ID_PREFIX = "WGP";
    protected String id = null;
    protected Shape hitShape = null;
    protected BufferedImage paintedImage = null;
    protected Point imageLocation = null;
    protected int imageOpacity = 0;
    protected List<Component> highlightedComponents = new ArrayList<Component>();
    protected Component highlightBase = this;
    protected int highlightSpacing = 3;

    public WebGlassPane() {
        super(StyleId.panelTransparent, new MultiLayout(), new Component[0]);
    }

    public MultiLayout getMultiLayout() {
        return (MultiLayout)this.getLayout();
    }

    public void addLayoutManager(LayoutManager layoutManager) {
        this.getMultiLayout().addLayoutManager(layoutManager);
    }

    public void removeLayoutManager(LayoutManager layoutManager) {
        this.getMultiLayout().removeLayoutManager(layoutManager);
    }

    public String getId() {
        if (this.id == null) {
            this.id = TextUtils.generateId(ID_PREFIX);
        }
        return this.id;
    }

    public void showComponent(@NotNull JComponent component2) {
        SwingUtils.copyOrientation(this, component2);
        this.add((Component)component2, 0);
        this.revalidate();
        this.repaint(component2.getBounds());
    }

    public void hideComponent(@NotNull JComponent component2) {
        Rectangle bounds = component2.getBounds();
        this.remove((Component)component2);
        this.revalidate();
        this.repaint(bounds);
    }

    @Override
    public boolean contains(int x, int y) {
        return this.hitShape != null && this.hitShape.contains(x, y);
    }

    public Shape getHitShape() {
        return this.hitShape;
    }

    public void setHitShape(Shape hitShape) {
        this.hitShape = hitShape;
    }

    public int getImageOpacity() {
        return this.imageOpacity;
    }

    public Point getImageLocation() {
        return this.imageLocation;
    }

    public BufferedImage getPaintedImage() {
        return this.paintedImage;
    }

    public void setPaintedImage(BufferedImage image, Point location) {
        this.setPaintedImage(image, location, 100);
    }

    public void setPaintedImage(BufferedImage image, Point location, int opacity) {
        Rectangle oldRect = this.getPaintedImageBounds();
        this.paintedImage = image;
        this.imageLocation = location;
        this.imageOpacity = opacity;
        Rectangle repaintRect = null;
        if (this.imageOpacity != 0 && this.paintedImage != null && this.imageLocation != null) {
            repaintRect = this.getPaintedImageBounds();
            if (oldRect != null) {
                repaintRect = new Rectangle(Math.max(0, Math.min(oldRect.x, repaintRect.x)), Math.max(0, Math.min(oldRect.y, repaintRect.y)), Math.max(oldRect.x + oldRect.width, repaintRect.x + repaintRect.width), Math.max(oldRect.y + oldRect.height, repaintRect.y + repaintRect.height));
            }
        }
        final Rectangle finalRepaintRect = repaintRect != null ? repaintRect : oldRect;
        CoreSwingUtils.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (finalRepaintRect != null) {
                    WebGlassPane.this.repaint(finalRepaintRect);
                } else {
                    WebGlassPane.this.repaint();
                }
            }
        });
    }

    public void clearPaintedImage() {
        final Rectangle oldRect = this.getPaintedImageBounds();
        this.imageOpacity = 0;
        this.paintedImage = null;
        this.imageLocation = null;
        if (oldRect != null) {
            CoreSwingUtils.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WebGlassPane.this.repaint(oldRect);
                }
            });
        }
    }

    public Rectangle getPaintedImageBounds() {
        Rectangle oldRect = null;
        if (this.imageOpacity != 0 && this.paintedImage != null && this.imageLocation != null) {
            oldRect = new Rectangle(this.imageLocation.x, this.imageLocation.y, this.paintedImage.getWidth(), this.paintedImage.getHeight());
        }
        return oldRect;
    }

    public void addHighlightedComponents(Component ... components) {
        for (Component component2 : components) {
            if (this.highlightedComponents.contains(component2)) continue;
            this.highlightedComponents.add(component2);
        }
        this.repaint();
    }

    public void addHighlightedComponents(List<Component> components) {
        for (Component component2 : components) {
            if (this.highlightedComponents.contains(component2)) continue;
            this.highlightedComponents.add(component2);
        }
        this.repaint();
    }

    public void removeHighlightedComponents(Component ... components) {
        this.highlightedComponents.removeAll(Arrays.asList(components));
        this.repaint();
    }

    public void removeHighlightedComponents(List<Component> components) {
        this.highlightedComponents.removeAll(components);
        this.repaint();
    }

    public void clearHighlights() {
        this.highlightedComponents.clear();
        this.repaint();
    }

    public Component getHighlightBase() {
        return this.highlightBase;
    }

    public void setHighlightBase(Component highlightBase) {
        this.highlightBase = highlightBase;
    }

    public int getHighlightSpacing() {
        return this.highlightSpacing;
    }

    public void setHighlightSpacing(int spacing) {
        this.highlightSpacing = spacing;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        Object aa = GraphicsUtils.setupAntialias(g2d);
        if (this.highlightedComponents.size() > 0) {
            Rectangle baseBounds = CoreSwingUtils.getRelativeBounds(this.highlightBase, this);
            Area area = new Area(new Rectangle(baseBounds.x - 1, baseBounds.y - 1, baseBounds.width + 1, baseBounds.height + 1));
            for (Component component2 : this.highlightedComponents) {
                if (!component2.isShowing()) continue;
                Rectangle bounds = CoreSwingUtils.getRelativeBounds(component2, this);
                RoundRectangle2D.Double shape = new RoundRectangle2D.Double(bounds.x - this.highlightSpacing, bounds.y - this.highlightSpacing, bounds.width + this.highlightSpacing * 2 - 1, bounds.height + this.highlightSpacing * 2 - 1, 8.0, 8.0);
                area.subtract(new Area(shape));
            }
            g2d.setPaint(new Color(128, 128, 128, 128));
            g2d.fill(area);
            g2d.setStroke(new BasicStroke(1.5f));
            g2d.setPaint(Color.GRAY);
            g2d.draw(area);
        }
        if (this.imageOpacity != 0 && this.paintedImage != null && this.imageLocation != null) {
            Composite c = g2d.getComposite();
            if (this.imageOpacity != 100) {
                g2d.setComposite(AlphaComposite.getInstance(3, (float)this.imageOpacity / 100.0f));
            }
            g2d.drawImage((Image)this.paintedImage, this.imageLocation.x, this.imageLocation.y, null);
            if (this.imageOpacity != 100) {
                g2d.setComposite(c);
            }
        }
        GraphicsUtils.restoreAntialias(g2d, aa);
    }
}

