/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.language;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.BiConsumer;
import com.alee.api.jdk.Objects;
import com.alee.api.resource.ClassResource;
import com.alee.managers.language.DictionaryListener;
import com.alee.managers.language.Language;
import com.alee.managers.language.LanguageException;
import com.alee.managers.language.LanguageListener;
import com.alee.managers.language.LanguageUtils;
import com.alee.managers.language.data.Dictionary;
import com.alee.managers.language.data.Record;
import com.alee.managers.language.data.Text;
import com.alee.managers.language.data.TranslationInformation;
import com.alee.managers.language.data.Value;
import com.alee.utils.CollectionUtils;
import com.alee.utils.XmlUtils;
import com.alee.utils.compare.Filter;
import com.alee.utils.swing.WeakComponentDataList;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;

public final class LanguageManager {
    @NotNull
    private static final Filter<Locale> SUPPORTED_LOCALES_FILTER = new Filter<Locale>(){

        @Override
        public boolean accept(Locale locale) {
            return LanguageManager.isSuportedLocale(locale);
        }
    };
    @Nullable
    private static Language language;
    @Nullable
    private static Dictionary dictionaries;
    @NotNull
    private static final List<LanguageListener> languageListeners;
    @NotNull
    private static final WeakComponentDataList<JComponent, LanguageListener> componentLanguageListeners;
    @NotNull
    private static final List<DictionaryListener> dictionaryListeners;
    @NotNull
    private static final WeakComponentDataList<JComponent, DictionaryListener> componentDictionaryListeners;
    private static boolean initialized;

    public static synchronized void initialize() {
        if (!initialized) {
            XmlUtils.processAnnotations(Dictionary.class);
            XmlUtils.processAnnotations(TranslationInformation.class);
            XmlUtils.processAnnotations(Record.class);
            XmlUtils.processAnnotations(Value.class);
            XmlUtils.processAnnotations(Text.class);
            dictionaries = new Dictionary("", "Global dictionary");
            initialized = true;
            LanguageManager.addDictionary(new Dictionary(new ClassResource(LanguageManager.class, "resources/core-language.xml")));
        }
    }

    private static void mustBeInitialized() throws LanguageException {
        if (!initialized) {
            throw new LanguageException("LanguageManager must be initialized first");
        }
    }

    @NotNull
    public static Dictionary getDictionaries() {
        LanguageManager.mustBeInitialized();
        if (dictionaries == null) {
            throw new LanguageException("LanguageManager failed to initialized correctly");
        }
        return dictionaries;
    }

    @NotNull
    public static String getLanguageTitle(@NotNull Language language2) {
        return LanguageManager.getLocaleTitle(language2.getLocale());
    }

    @NotNull
    public static String getLocaleTitle(@NotNull Locale locale) {
        LanguageManager.mustBeInitialized();
        TranslationInformation info = LanguageManager.getDictionaries().getTranslation(locale);
        return info != null ? info.getTitle() : LanguageUtils.toString(locale);
    }

    @NotNull
    public synchronized List<Locale> getAllLocales() {
        LanguageManager.mustBeInitialized();
        return LanguageManager.getDictionaries().getAllLocales();
    }

    @NotNull
    public static List<Locale> getSupportedLocales() {
        LanguageManager.mustBeInitialized();
        return LanguageManager.getDictionaries().getSupportedLocales();
    }

    @NotNull
    public static List<Locale> getSupportedLocales(@NotNull List<Locale> locales) {
        LanguageManager.mustBeInitialized();
        return CollectionUtils.filter(locales, SUPPORTED_LOCALES_FILTER);
    }

    public static boolean isSuportedLanguage(@NotNull Language language2) {
        LanguageManager.mustBeInitialized();
        return LanguageManager.isSuportedLocale(language2.getLocale());
    }

    public static boolean isSuportedLocale(@NotNull Locale locale) {
        LanguageManager.mustBeInitialized();
        boolean supported = false;
        for (Locale slocale : LanguageManager.getSupportedLocales()) {
            if (!Objects.equals((Object)locale.getLanguage(), (Object)slocale.getLanguage())) continue;
            supported = true;
            break;
        }
        return supported;
    }

    public static void addDictionary(@NotNull Dictionary dictionary) {
        LanguageManager.mustBeInitialized();
        LanguageManager.getDictionaries().addDictionary(dictionary);
        LanguageManager.fireDictionaryAdded(dictionary);
    }

    public static void removeDictionary(@NotNull Dictionary dictionary) {
        LanguageManager.mustBeInitialized();
        LanguageManager.getDictionaries().removeDictionary(dictionary);
        LanguageManager.fireDictionaryRemoved(dictionary);
    }

    public static void clearDictionaries() {
        LanguageManager.mustBeInitialized();
        LanguageManager.getDictionaries().clearRecords();
        LanguageManager.getDictionaries().clearDictionaries();
        LanguageManager.fireDictionariesCleared();
    }

    @NotNull
    public static Locale getLocale() {
        LanguageManager.mustBeInitialized();
        return LanguageManager.getLanguage().getLocale();
    }

    public static boolean isCurrentLocale(@NotNull Locale locale) {
        LanguageManager.mustBeInitialized();
        return LanguageManager.getLanguage().getLocale().equals(locale);
    }

    public static void setLocale(@NotNull Locale locale) {
        LanguageManager.mustBeInitialized();
        LanguageManager.setLanguage(new Language(locale));
    }

    @NotNull
    public static Language getLanguage() {
        LanguageManager.mustBeInitialized();
        if (language == null) {
            List<Locale> locales;
            Locale locale = Locale.getDefault();
            language = LanguageManager.isSuportedLocale(locale) ? new Language(locale) : (!(locales = LanguageManager.getSupportedLocales()).isEmpty() ? new Language(locales.get(0)) : new Language(new Locale("en", "GB")));
        }
        return language;
    }

    public static boolean isCurrentLanguage(@NotNull Language language2) {
        LanguageManager.mustBeInitialized();
        return Objects.equals((Object)language2, (Object)LanguageManager.getLanguage());
    }

    public static void setLanguage(@NotNull Language language2) {
        LanguageManager.mustBeInitialized();
        if (!LanguageManager.isCurrentLanguage(language2)) {
            Language oldLanguage = LanguageManager.getLanguage();
            language = language2;
            LanguageManager.fireLanguageChanged(oldLanguage, language2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLanguageListener(@NotNull LanguageListener listener) {
        List<LanguageListener> list = languageListeners;
        synchronized (list) {
            languageListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeLanguageListener(@NotNull LanguageListener listener) {
        List<LanguageListener> list = languageListeners;
        synchronized (list) {
            languageListeners.remove(listener);
        }
    }

    public static void addLanguageListener(@NotNull JComponent component2, @NotNull LanguageListener listener) {
        componentLanguageListeners.add(component2, listener);
    }

    public static void removeLanguageListener(@NotNull JComponent component2, @NotNull LanguageListener listener) {
        componentLanguageListeners.remove(component2, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireLanguageChanged(final @NotNull Language oldLanguage, final @NotNull Language newLanguage) {
        componentLanguageListeners.forEachData(new BiConsumer<JComponent, LanguageListener>(){

            @Override
            public void accept(JComponent component2, LanguageListener listener) {
                listener.languageChanged(oldLanguage, newLanguage);
            }
        });
        List<LanguageListener> list = languageListeners;
        synchronized (list) {
            for (LanguageListener listener : CollectionUtils.copy(languageListeners)) {
                listener.languageChanged(oldLanguage, newLanguage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDictionaryListener(@NotNull DictionaryListener listener) {
        List<DictionaryListener> list = dictionaryListeners;
        synchronized (list) {
            dictionaryListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDictionaryListener(@NotNull DictionaryListener listener) {
        List<DictionaryListener> list = dictionaryListeners;
        synchronized (list) {
            dictionaryListeners.remove(listener);
        }
    }

    public static void addDictionaryListener(@NotNull JComponent component2, @NotNull DictionaryListener listener) {
        componentDictionaryListeners.add(component2, listener);
    }

    public static void removeDictionaryListener(@NotNull JComponent component2, @NotNull DictionaryListener listener) {
        componentDictionaryListeners.remove(component2, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireDictionaryAdded(final @NotNull Dictionary dictionary) {
        componentDictionaryListeners.forEachData(new BiConsumer<JComponent, DictionaryListener>(){

            @Override
            public void accept(JComponent component2, DictionaryListener listener) {
                listener.dictionaryAdded(dictionary);
            }
        });
        List<DictionaryListener> list = dictionaryListeners;
        synchronized (list) {
            for (DictionaryListener listener : CollectionUtils.copy(dictionaryListeners)) {
                listener.dictionaryAdded(dictionary);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireDictionaryRemoved(final @NotNull Dictionary dictionary) {
        componentDictionaryListeners.forEachData(new BiConsumer<JComponent, DictionaryListener>(){

            @Override
            public void accept(JComponent component2, DictionaryListener listener) {
                listener.dictionaryRemoved(dictionary);
            }
        });
        List<DictionaryListener> list = dictionaryListeners;
        synchronized (list) {
            for (DictionaryListener listener : CollectionUtils.copy(dictionaryListeners)) {
                listener.dictionaryRemoved(dictionary);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fireDictionariesCleared() {
        componentDictionaryListeners.forEachData(new BiConsumer<JComponent, DictionaryListener>(){

            @Override
            public void accept(JComponent component2, DictionaryListener listener) {
                listener.dictionariesCleared();
            }
        });
        List<DictionaryListener> list = dictionaryListeners;
        synchronized (list) {
            for (DictionaryListener listener : CollectionUtils.copy(dictionaryListeners)) {
                listener.dictionariesCleared();
            }
        }
    }

    static {
        languageListeners = new ArrayList<LanguageListener>();
        componentLanguageListeners = new WeakComponentDataList("LanguageManager.LanguageListener", 5);
        dictionaryListeners = new ArrayList<DictionaryListener>();
        componentDictionaryListeners = new WeakComponentDataList("LanguageManager.DictionaryListener", 5);
        initialized = false;
    }
}

