/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.popup;

import com.alee.api.annotations.NotNull;
import com.alee.extended.layout.MultiLayout;
import com.alee.laf.panel.WebPanel;
import com.alee.managers.popup.WebInnerPopup;
import com.alee.managers.style.StyleId;
import com.alee.painter.PainterSupport;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JComponent;

public class PopupLayer
extends WebPanel {
    public PopupLayer() {
        this(new MultiLayout());
    }

    public PopupLayer(@NotNull LayoutManager layoutManager) {
        super(StyleId.panelTransparent, layoutManager, new Component[0]);
        this.setOpaque(false);
    }

    @NotNull
    public MultiLayout getMultiLayout() {
        LayoutManager layout = this.getLayout();
        if (!(layout instanceof MultiLayout)) {
            throw new RuntimeException("Installed layout is not MultiLayout");
        }
        return (MultiLayout)layout;
    }

    public void addLayoutManager(@NotNull LayoutManager layoutManager) {
        this.getMultiLayout().addLayoutManager(layoutManager);
    }

    public void removeLayoutManager(@NotNull LayoutManager layoutManager) {
        this.getMultiLayout().removeLayoutManager(layoutManager);
    }

    public void hideAllPopups() {
        this.removeAll();
        this.setVisible(false);
    }

    public void showPopup(@NotNull WebInnerPopup popup) {
        popup.firePopupWillBeOpened();
        this.setBounds(new Rectangle(0, 0, this.getParent().getWidth(), this.getParent().getHeight()));
        this.add((Component)popup, 0);
        this.setVisible(true);
        popup.revalidate();
        popup.repaint();
    }

    public void hidePopup(@NotNull WebInnerPopup popup) {
        if (popup.isShowing() && popup.getParent() == this) {
            popup.firePopupWillBeClosed();
            Rectangle bounds = popup.getBounds();
            this.remove((Component)popup);
            this.revalidate();
            this.repaint(bounds);
        }
    }

    @Override
    public boolean contains(int x, int y) {
        boolean contains = false;
        for (Component child : this.getComponents()) {
            Point l2 = child.getLocation();
            if (child instanceof JComponent) {
                Shape shape = PainterSupport.getShape((JComponent)child);
                if (!shape.contains(x - l2.x, y - l2.y)) continue;
                contains = true;
                break;
            }
            if (!child.getBounds().contains(x, y)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    public boolean normalContains(int x, int y) {
        return super.contains(x, y);
    }
}

