/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.settings;

import com.alee.api.jdk.SerializableSupplier;
import com.alee.managers.settings.SettingsManager;
import java.io.Serializable;

public class Configuration<V extends Serializable>
implements Serializable {
    protected final String group;
    protected final String key;
    protected final SerializableSupplier<V> defaultValue;
    protected final boolean loadInitialSettings;
    protected final boolean applySettingsChanges;

    public Configuration(String key) {
        this(SettingsManager.getDefaultSettingsGroup(), key, (SerializableSupplier)null, true, false);
    }

    public Configuration(String key, boolean loadInitialSettings, boolean applySettingsChanges) {
        this(SettingsManager.getDefaultSettingsGroup(), key, (SerializableSupplier)null, true, false);
    }

    public Configuration(String key, V defaultValue2) {
        this(SettingsManager.getDefaultSettingsGroup(), key, new StaticDefaultValue<V>(defaultValue2), true, false);
    }

    public Configuration(String key, SerializableSupplier<V> defaultValue2) {
        this(SettingsManager.getDefaultSettingsGroup(), key, defaultValue2, true, false);
    }

    public Configuration(String key, V defaultValue2, boolean loadInitialSettings, boolean applySettingsChanges) {
        this(SettingsManager.getDefaultSettingsGroup(), key, new StaticDefaultValue<V>(defaultValue2), loadInitialSettings, applySettingsChanges);
    }

    public Configuration(String key, SerializableSupplier<V> defaultValue2, boolean loadInitialSettings, boolean applySettingsChanges) {
        this(SettingsManager.getDefaultSettingsGroup(), key, defaultValue2, loadInitialSettings, applySettingsChanges);
    }

    public Configuration(String group, String key) {
        this(group, key, (SerializableSupplier)null, true, false);
    }

    public Configuration(String group, String key, boolean loadInitialSettings, boolean applySettingsChanges) {
        this(group, key, (SerializableSupplier)null, loadInitialSettings, applySettingsChanges);
    }

    public Configuration(String group, String key, V defaultValue2) {
        this(group, key, new StaticDefaultValue<V>(defaultValue2), true, false);
    }

    public Configuration(String group, String key, SerializableSupplier<V> defaultValue2) {
        this(group, key, defaultValue2, true, false);
    }

    public Configuration(String group, String key, V defaultValue2, boolean loadInitialSettings, boolean applySettingsChanges) {
        this(group, key, defaultValue2 != null ? new StaticDefaultValue<V>(defaultValue2) : null, loadInitialSettings, applySettingsChanges);
    }

    public Configuration(String group, String key, SerializableSupplier<V> defaultValue2, boolean loadInitialSettings, boolean applySettingsChanges) {
        this.group = group;
        this.key = key;
        this.defaultValue = defaultValue2;
        this.loadInitialSettings = loadInitialSettings;
        this.applySettingsChanges = applySettingsChanges;
    }

    public String group() {
        return this.group;
    }

    public String key() {
        return this.key;
    }

    public V defaultValue() {
        return (V)(this.defaultValue != null ? (Serializable)this.defaultValue.get() : null);
    }

    public boolean isLoadInitialSettings() {
        return this.loadInitialSettings;
    }

    public boolean isApplySettingsChanges() {
        return this.applySettingsChanges;
    }

    public String toString() {
        String name = this.getClass().getSimpleName();
        String settings2 = "[ " + this.group + " -> " + this.key + " ]";
        return name + settings2;
    }

    protected static class StaticDefaultValue<V extends Serializable>
    implements SerializableSupplier<V> {
        private final V value;

        public StaticDefaultValue(V value) {
            this.value = value;
        }

        @Override
        public V get() {
            return this.value;
        }
    }
}

