/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style;

import com.alee.api.annotations.NotNull;
import com.alee.managers.style.ComponentDescriptor;
import com.alee.managers.style.StyleException;
import com.alee.managers.style.StyleId;
import com.alee.managers.style.Styleable;
import com.alee.painter.SpecificPainter;
import com.alee.utils.LafUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.TextUtils;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.plaf.ComponentUI;

public abstract class AbstractComponentDescriptor<C extends JComponent, U extends ComponentUI, P extends SpecificPainter>
implements ComponentDescriptor<C, U, P> {
    protected static final Map<Class, Icon> componentIcons = new HashMap<Class, Icon>();
    @NotNull
    protected final String id;
    @NotNull
    protected final Class<C> componentClass;
    @NotNull
    protected final String uiClassId;
    @NotNull
    protected final Class<U> baseUIClass;
    @NotNull
    protected final Class<? extends U> uiClass;
    @NotNull
    protected final Class<P> painterInterface;
    @NotNull
    protected final Class<? extends P> painterClass;
    @NotNull
    protected final Class<? extends P> painterAdapterClass;
    @NotNull
    protected final StyleId defaultStyleId;

    public AbstractComponentDescriptor(@NotNull String id, @NotNull Class<C> componentClass, @NotNull String uiClassId, @NotNull Class<U> baseUIClass, @NotNull Class<? extends U> uiClass, @NotNull Class<P> painterInterface, @NotNull Class<? extends P> painterClass, @NotNull Class<? extends P> painterAdapterClass, @NotNull StyleId defaultStyleId) {
        this.id = id;
        this.componentClass = componentClass;
        this.uiClassId = uiClassId;
        this.baseUIClass = baseUIClass;
        this.uiClass = uiClass;
        this.painterInterface = painterInterface;
        this.painterClass = painterClass;
        this.painterAdapterClass = painterAdapterClass;
        this.defaultStyleId = defaultStyleId;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public Class<C> getComponentClass() {
        return this.componentClass;
    }

    @Override
    @NotNull
    public String getUIClassId() {
        return this.uiClassId;
    }

    @Override
    @NotNull
    public Class<U> getBaseUIClass() {
        return this.baseUIClass;
    }

    @Override
    @NotNull
    public Class<? extends U> getUIClass() {
        return this.uiClass;
    }

    @Override
    @NotNull
    public Class<P> getPainterInterface() {
        return this.painterInterface;
    }

    @Override
    @NotNull
    public Class<? extends P> getPainterClass() {
        return this.painterClass;
    }

    @Override
    @NotNull
    public Class<? extends P> getPainterAdapterClass() {
        return this.painterAdapterClass;
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId() {
        return this.defaultStyleId;
    }

    @Override
    @NotNull
    public StyleId getDefaultStyleId(@NotNull JComponent component2) {
        StyleId styleId;
        if (component2 instanceof Styleable) {
            Styleable styleable = (Styleable)((Object)component2);
            styleId = styleable.getDefaultStyleId();
        } else {
            styleId = this.getDefaultStyleId();
        }
        return styleId;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon;
        Class<C> key = this.getComponentClass();
        if (componentIcons.containsKey(key)) {
            icon = componentIcons.get(key);
        } else {
            try {
                icon = new ImageIcon(this.getIconResource());
                componentIcons.put(key, icon);
            }
            catch (Exception e) {
                throw new StyleException("Unable to find component icon: " + key, e);
            }
        }
        return icon;
    }

    @NotNull
    protected URL getIconResource() {
        String path = "icons/styleable/" + this.getId() + ".png";
        URL resource = AbstractComponentDescriptor.class.getResource(path);
        if (resource == null) {
            throw new StyleException("Unable to find component type icon: " + this.getId());
        }
        return resource;
    }

    @Override
    @NotNull
    public String getTitle() {
        return ReflectUtils.getClassName(this.getComponentClass());
    }

    @Override
    public void updateDefaults(@NotNull UIDefaults table2) {
        table2.put(this.getUIClassId(), this.getUIClass().getName());
    }

    @Override
    public void updateUI(@NotNull C component2) {
        Object existingUI = LafUtils.getUI(component2);
        if (existingUI == null || !this.getBaseUIClass().isAssignableFrom(existingUI.getClass())) {
            try {
                Class<U> uiClass = this.getUIClass();
                ComponentUI uiInstance = this.createUI(component2, uiClass);
                LafUtils.setUI(component2, uiInstance);
            }
            catch (Exception e) {
                throw new StyleException("Unable to setup component UI: " + component2, e);
            }
        } else {
            LafUtils.setUI(component2, existingUI);
        }
    }

    @NotNull
    protected ComponentUI createUI(@NotNull C component2, @NotNull Class<? extends U> uiClass) {
        ComponentUI ui;
        try {
            ui = (ComponentUI)ReflectUtils.callStaticMethod(uiClass, "createUI", component2);
        }
        catch (Exception e) {
            throw new StyleException("Unable to instantiate UI instance: " + uiClass, e);
        }
        return ui;
    }

    @NotNull
    public String toString() {
        Object[] data = new Object[]{this.componentClass, this.uiClassId, this.baseUIClass, this.uiClass, this.defaultStyleId};
        String parameters = TextUtils.arrayToString(", ", data);
        return this.getId() + "[" + parameters + "]";
    }
}

