/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.resource.Resource;
import com.alee.managers.icon.set.IconSet;
import com.alee.managers.style.SkinExtension;
import com.alee.managers.style.data.SkinInfo;
import com.alee.utils.XmlUtils;
import com.alee.utils.xml.XStreamContext;
import java.util.List;
import javax.swing.Icon;

public class XmlSkinExtension
implements SkinExtension {
    @NotNull
    private final Resource resource;
    @NotNull
    private final SkinInfo extensionInfo;

    public XmlSkinExtension(@NotNull Resource resource) {
        this.resource = resource;
        this.extensionInfo = this.getMetaData();
    }

    @Override
    @NotNull
    public String getId() {
        return this.extensionInfo.getId();
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return this.extensionInfo.getIcon();
    }

    @Override
    @Nullable
    public String getTitle() {
        return this.extensionInfo.getTitle();
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.extensionInfo.getDescription();
    }

    @Override
    @Nullable
    public String getAuthor() {
        return this.extensionInfo.getAuthor();
    }

    @Override
    public boolean isSupported(@NotNull String skinId) {
        return this.extensionInfo.isSupported(skinId);
    }

    @Override
    @NotNull
    public List<IconSet> getIconSets() {
        return this.extensionInfo.getIconSets();
    }

    @NotNull
    public SkinInfo getMetaData() {
        return (SkinInfo)XmlUtils.fromXML(this.resource, new XStreamContext("meta.data.only", true));
    }

    @NotNull
    public SkinInfo getData(@NotNull String skinClass) {
        return (SkinInfo)XmlUtils.fromXML(this.resource, new XStreamContext("skin.class", skinClass));
    }

    @NotNull
    public String toString() {
        return this.extensionInfo.toString();
    }
}

