/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.style.data;

import com.alee.api.annotations.NotNull;
import com.alee.managers.style.StyleException;
import com.alee.managers.style.data.PainterStyle;
import com.alee.managers.style.data.StyleConverterUtils;
import com.alee.painter.DefaultPainter;
import com.alee.painter.Painter;
import com.alee.utils.ReflectUtils;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import com.thoughtworks.xstream.mapper.Mapper;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;

public final class PainterStyleConverter
extends ReflectionConverter {
    public PainterStyleConverter(@NotNull Mapper mapper, @NotNull ReflectionProvider reflectionProvider) {
        super(mapper, reflectionProvider);
    }

    @Override
    public boolean canConvert(@NotNull Class type) {
        return Painter.class.isAssignableFrom(type);
    }

    @Override
    @NotNull
    public Object unmarshal(@NotNull HierarchicalStreamReader reader, @NotNull UnmarshallingContext context) {
        String styleId = (String)context.get("style.id");
        if (styleId == null) {
            throw new StyleException("Context style identifier must be specified");
        }
        String ow = reader.getAttribute("overwrite");
        Boolean overwrite = ow != null ? Boolean.valueOf(Boolean.parseBoolean(ow)) : null;
        Class parent = (Class)context.get("painter.class");
        Class<? extends Painter> defaultPainter = this.getDefaultPainter(parent, reader.getNodeName());
        Class<? extends Painter> painterClass = PainterStyleConverter.unmarshalPainterClass(reader, context, this.mapper, defaultPainter, styleId);
        context.put("painter.class", painterClass);
        LinkedHashMap<String, Object> painterProperties = new LinkedHashMap<String, Object>();
        StyleConverterUtils.readProperties(reader, context, this.mapper, painterProperties, painterClass, styleId);
        PainterStyle painterStyle = new PainterStyle();
        painterStyle.setOverwrite(overwrite);
        painterStyle.setPainterClass(painterClass.getCanonicalName());
        painterStyle.setProperties(painterProperties);
        context.put("painter.class", parent);
        return painterStyle;
    }

    @NotNull
    private Class<? extends Painter> getDefaultPainter(@NotNull Class<?> inClass, @NotNull String field2) {
        try {
            Field painterField = ReflectUtils.getField(inClass, field2);
            DefaultPainter defaultPainter = painterField.getAnnotation(DefaultPainter.class);
            if (defaultPainter != null) {
                return defaultPainter.value();
            }
            String msg = "Painter field '%s' in class '%s' doesn't have DefaultPainter annotation";
            throw new StyleException(String.format("Painter field '%s' in class '%s' doesn't have DefaultPainter annotation", field2, inClass));
        }
        catch (Exception e) {
            String msg = "Unable to find Painter field '%s' in class '%s' for class retrieval from DefaultPainter annotation";
            throw new StyleException(String.format("Unable to find Painter field '%s' in class '%s' for class retrieval from DefaultPainter annotation", field2, inClass));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static Class<? extends Painter> unmarshalPainterClass(@NotNull HierarchicalStreamReader reader, @NotNull UnmarshallingContext context, @NotNull Mapper mapper, @NotNull Class<? extends Painter> defaultPainterClass, @NotNull String styleId) {
        String painterClassName = reader.getAttribute("class");
        if (painterClassName == null) return defaultPainterClass;
        try {
            return mapper.realClass(painterClassName);
        }
        catch (CannotResolveClassException e) {
            String skinClassName = (String)context.get("skin.class");
            Class skinClass = ReflectUtils.getClassSafely(skinClassName);
            if (skinClass == null) {
                String msg = "Class '%s' for style '%s' cannot be found";
                throw new StyleException(String.format("Class '%s' for style '%s' cannot be found", painterClassName, styleId), e);
            }
            String skinPackage = skinClass.getPackage().getName();
            painterClassName = skinPackage + "." + painterClassName;
            Class painterClass = ReflectUtils.getClassSafely(painterClassName);
            if (painterClass != null) return painterClass;
            String msg = "Class '%s' for style '%s' cannot be found";
            throw new StyleException(String.format("Class '%s' for style '%s' cannot be found", painterClassName, styleId), e);
        }
    }
}

