/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.tooltip;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.managers.tooltip.ComponentArea;
import com.alee.managers.tooltip.ToolTipProvider;
import com.alee.managers.tooltip.TooltipManager;
import com.alee.managers.tooltip.TooltipWay;
import com.alee.managers.tooltip.WebCustomTooltip;
import com.alee.utils.swing.WebTimer;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;

public abstract class AbstractToolTipProvider<V, C extends JComponent, A extends ComponentArea<V, C>>
implements ToolTipProvider<V, C, A> {
    @Nullable
    private WebCustomTooltip tooltip;
    @Nullable
    private WebTimer delayTimer;

    @Override
    public long getDelay() {
        return TooltipManager.getDefaultDelay();
    }

    @Override
    @Nullable
    public Rectangle getSourceBounds(@NotNull C component2, @NotNull A area) {
        Rectangle bounds = area.getBounds(component2);
        return bounds != null ? bounds.intersection(((JComponent)component2).getVisibleRect()) : null;
    }

    @Override
    @Nullable
    public WebCustomTooltip getToolTip(@NotNull C component2, @NotNull A area) {
        WebCustomTooltip tooltip;
        String text = this.getToolTipText(component2, area);
        if (text != null) {
            TooltipWay direction = this.getDirection(component2, area);
            tooltip = new WebCustomTooltip((Component)component2, text, direction);
        } else {
            tooltip = null;
        }
        return tooltip;
    }

    @Override
    public void hoverAreaChanged(@NotNull C component2, @Nullable A oldArea, @Nullable A newArea) {
        if (this.delayTimer != null) {
            this.delayTimer.stop();
        }
        if (this.tooltip != null) {
            this.tooltip.closeTooltip();
        }
        if (newArea != null) {
            long delay = this.getDelay();
            if (delay <= 0L) {
                this.showTooltip(component2, newArea);
            } else {
                this.delayTimer = WebTimer.delay(delay, new ActionListener((JComponent)component2, (ComponentArea)newArea){
                    final /* synthetic */ JComponent val$component;
                    final /* synthetic */ ComponentArea val$newArea;
                    {
                        this.val$component = jComponent;
                        this.val$newArea = componentArea;
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AbstractToolTipProvider.this.showTooltip(this.val$component, this.val$newArea);
                    }
                });
            }
        }
    }

    protected void showTooltip(@NotNull C component2, @NotNull A area) {
        WebCustomTooltip toolTip;
        Rectangle sourceBounds;
        if (this.isAvailable(component2, area) && (sourceBounds = this.getSourceBounds(component2, area)) != null && (toolTip = this.getToolTip(component2, area)) != null) {
            this.tooltip = toolTip;
            this.tooltip.setRelativeToBounds(sourceBounds);
            TooltipManager.showOneTimeTooltip(this.tooltip);
        }
    }

    protected boolean isAvailable(@NotNull C component2, @NotNull A area) {
        return area.isAvailable(component2);
    }

    @Nullable
    protected V getValue(@NotNull C component2, @NotNull A area) {
        return area.getValue(component2);
    }

    @NotNull
    protected TooltipWay getDirection(@NotNull C component2, @NotNull A area) {
        return TooltipWay.trailing;
    }

    @Nullable
    protected abstract String getToolTipText(@NotNull C var1, @NotNull A var2);
}

