/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.tooltip;

import com.alee.api.jdk.Objects;
import com.alee.managers.language.AbstractToolTipLanguage;
import com.alee.managers.language.Language;
import com.alee.managers.language.data.Text;
import com.alee.managers.tooltip.TooltipManager;
import com.alee.managers.tooltip.WebCustomTooltip;
import javax.swing.JComponent;

public class CustomToolTipLanguage<C extends JComponent>
extends AbstractToolTipLanguage<C> {
    public static final String TYPE = "CUSTOM";
    protected static final String CUSTOM_TOOLTIP_MARKER = "custom.tooltip.marker";

    @Override
    public Class getComponentClass() {
        return WebCustomTooltip.class;
    }

    @Override
    public void update(C component2, Language language2, String key, Object ... data) {
        WebCustomTooltip oldToolTip = (WebCustomTooltip)((JComponent)component2).getClientProperty(CUSTOM_TOOLTIP_MARKER);
        Text toolTipText = this.getToolTipText(language2, key);
        if (toolTipText != null) {
            if (oldToolTip == null) {
                WebCustomTooltip customToolTip = TooltipManager.setTooltip(component2, toolTipText.getText(new Object[0]));
                ((JComponent)component2).putClientProperty(CUSTOM_TOOLTIP_MARKER, customToolTip);
            } else {
                oldToolTip.setTooltip(toolTipText.getText(new Object[0]));
            }
        } else if (oldToolTip != null) {
            TooltipManager.removeTooltips(component2, new WebCustomTooltip[]{oldToolTip});
            ((JComponent)component2).putClientProperty(CUSTOM_TOOLTIP_MARKER, null);
        }
    }

    protected Text getToolTipText(Language language2, String key) {
        Text tooltip = language2.getText(key, "custom-tooltip");
        if (tooltip == null && Objects.equals((Object)CustomToolTipLanguage.getDefaultToolTipType(), (Object)TYPE)) {
            tooltip = language2.getText(key, "tooltip");
        }
        return tooltip;
    }
}

