/*
 * Decompiled with CFR 0.152.
 */
package com.alee.managers.tooltip;

import com.alee.extended.label.WebStyledLabel;
import com.alee.laf.WebLookAndFeel;
import com.alee.laf.label.WebLabel;
import com.alee.managers.hotkey.HotkeyManager;
import com.alee.managers.style.StyleId;
import com.alee.managers.tooltip.TooltipListener;
import com.alee.managers.tooltip.TooltipWay;
import com.alee.utils.CollectionUtils;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.laf.ShadeType;
import com.alee.utils.laf.WebBorder;
import com.alee.utils.swing.AncestorAdapter;
import com.alee.utils.swing.FadeStateType;
import com.alee.utils.swing.WebTimer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.RoundRectangle2D;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class WebCustomTooltip
extends JComponent {
    private static final String ID_PREFIX = "WCT";
    private static final int fadeFps = 24;
    private static final long fadeTime = 200L;
    private static final int cornerLength = 8;
    private static final int cornerSideX = 7;
    private TooltipWay displayWay = null;
    private boolean showHotkey = true;
    private int hotkeyLocation = 11;
    private boolean defaultCloseBehavior = true;
    private int contentSpacing = 4;
    private int leftRightSpacing = 0;
    private int windowSideSpacing = 5;
    private int round = 4;
    private ShadeType shadeType = ShadeType.gradient;
    private int shadeWidth = 0;
    private Color shadeColor = Color.GRAY;
    private Color borderColor = null;
    private Color topBgColor = Color.BLACK;
    private Color bottomBgColor = Color.BLACK;
    private Color textColor = Color.WHITE;
    private float opacity = 0.85f;
    private final List<TooltipListener> listeners = new ArrayList<TooltipListener>(2);
    private AncestorListener ancestorListener;
    private final WebLabel hotkey;
    private int cornerPeak = 0;
    private final WebTimer fadeTimer;
    private FadeStateType fadeStateType;
    private float fade = 0.0f;
    private final String id;
    private final WeakReference<Component> component;
    private JComponent tooltip;
    private Point displayLocation;
    private Rectangle relativeToBounds;
    private WeakReference<Component> relativeToComponent;

    public WebCustomTooltip(Component component2, String tooltip) {
        this(component2, null, tooltip);
    }

    public WebCustomTooltip(Component component2, Icon icon, String tooltip) {
        this(component2, WebCustomTooltip.createDefaultComponent(icon, tooltip));
    }

    public WebCustomTooltip(Component component2, String tooltip, TooltipWay tooltipWay) {
        this(component2, null, tooltip, tooltipWay);
    }

    public WebCustomTooltip(Component component2, Icon icon, String tooltip, TooltipWay tooltipWay) {
        this(component2, (JComponent)WebCustomTooltip.createDefaultComponent(icon, tooltip), tooltipWay);
    }

    public WebCustomTooltip(Component component2, String tooltip, boolean showHotkey) {
        this(component2, null, tooltip, showHotkey);
    }

    public WebCustomTooltip(Component component2, Icon icon, String tooltip, boolean showHotkey) {
        this(component2, (JComponent)WebCustomTooltip.createDefaultComponent(icon, tooltip), showHotkey);
    }

    public WebCustomTooltip(Component component2, String tooltip, TooltipWay tooltipWay, boolean showHotkey) {
        this(component2, null, tooltip, tooltipWay, showHotkey);
    }

    public WebCustomTooltip(Component component2, Icon icon, String tooltip, TooltipWay tooltipWay, boolean showHotkey) {
        this(component2, WebCustomTooltip.createDefaultComponent(icon, tooltip), tooltipWay, showHotkey);
    }

    public WebCustomTooltip(Component component2, JComponent tooltip) {
        this(component2, tooltip, null);
    }

    public WebCustomTooltip(Component component2, JComponent tooltip, TooltipWay tooltipWay) {
        this(component2, tooltip, tooltipWay, true);
    }

    public WebCustomTooltip(Component component2, JComponent tooltip, boolean showHotkey) {
        this(component2, tooltip, null, showHotkey);
    }

    public WebCustomTooltip(Component component2, JComponent tooltip, TooltipWay tooltipWay, boolean showHotkey) {
        WebLookAndFeel.setOrientation(this);
        this.setOpaque(false);
        this.id = TextUtils.generateId(ID_PREFIX);
        this.component = new WeakReference<Component>(component2);
        this.tooltip = tooltip;
        this.showHotkey = showHotkey;
        this.displayWay = tooltipWay;
        this.hotkey = new WebLabel(StyleId.customtooltipHotkeyLabel);
        this.hotkey.setFont(WebLookAndFeel.globalMenuSmallFont);
        this.setLayout(new BorderLayout(6, 6));
        this.add((Component)tooltip, "Center");
        this.fadeTimer = new WebTimer("WebCustomTooltip.fade", 41L);
        this.fadeTimer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                float roundsCount = 4.7999997f;
                float fadeSpeed = 0.20833334f;
                if (WebCustomTooltip.this.fadeStateType.equals((Object)FadeStateType.fadeIn)) {
                    if (WebCustomTooltip.this.fade < 1.0f) {
                        WebCustomTooltip.this.fade = Math.min(WebCustomTooltip.this.fade + 0.20833334f, 1.0f);
                        WebCustomTooltip.this.repaint();
                    } else {
                        WebCustomTooltip.this.fireTooltipFullyShown();
                        WebCustomTooltip.this.fadeTimer.stop();
                    }
                } else if (WebCustomTooltip.this.fadeStateType.equals((Object)FadeStateType.fadeOut)) {
                    if (WebCustomTooltip.this.fade > 0.0f) {
                        WebCustomTooltip.this.fade = Math.max(WebCustomTooltip.this.fade - 0.20833334f, 0.0f);
                        WebCustomTooltip.this.repaint();
                    } else {
                        JComponent parent = (JComponent)WebCustomTooltip.this.getParent();
                        if (parent != null) {
                            Rectangle b = WebCustomTooltip.this.getBounds();
                            parent.remove(WebCustomTooltip.this);
                            parent.repaint(b);
                        }
                        WebCustomTooltip.this.fadeTimer.stop();
                    }
                }
            }
        });
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                WebCustomTooltip.this.updateHotkey();
                WebCustomTooltip.this.updateBorder();
                WebCustomTooltip.this.updateLocation();
                WebCustomTooltip.this.fade = 0.0f;
                WebCustomTooltip.this.fadeStateType = FadeStateType.fadeIn;
                WebCustomTooltip.this.fadeTimer.start();
                WebCustomTooltip.this.fireTooltipShown();
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                if (WebCustomTooltip.this.getParent() == null) {
                    WebCustomTooltip.this.fireTooltipHidden();
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                WebCustomTooltip.this.updateBorder();
                WebCustomTooltip.this.updateLocation();
            }
        });
        if (component2 instanceof JComponent) {
            this.ancestorListener = new AncestorAdapter(){

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                    WebCustomTooltip.this.closeTooltip();
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                    WebCustomTooltip.this.closeTooltip();
                }
            };
            ((JComponent)component2).addAncestorListener(this.ancestorListener);
        }
    }

    private void updateHotkey() {
        String hotkeyText;
        Component component2;
        if (this.showHotkey && (component2 = this.getComponent()) != null && component2 instanceof JComponent && TextUtils.notEmpty(hotkeyText = HotkeyManager.getComponentHotkeysString((JComponent)component2))) {
            this.hotkey.setText(hotkeyText);
            if (this.getComponentZOrder(this.hotkey) != -1) {
                this.remove(this.hotkey);
            }
            this.add((Component)this.hotkey, this.getActualHotkeyLocation());
            return;
        }
        this.remove(this.hotkey);
    }

    private String getActualHotkeyLocation() {
        switch (this.hotkeyLocation) {
            case 10: {
                return "Before";
            }
            case 11: {
                return "After";
            }
            case 2: {
                return "West";
            }
            case 4: {
                return "East";
            }
        }
        return "After";
    }

    public void closeTooltip() {
        if (this.getParent() == null) {
            return;
        }
        this.fadeStateType = FadeStateType.fadeOut;
        if (!this.fadeTimer.isRunning()) {
            this.fadeTimer.start();
        }
    }

    public void destroyTooltip() {
        Component component2 = this.getComponent();
        if (component2 != null && component2 instanceof JComponent) {
            ((JComponent)component2).removeAncestorListener(this.ancestorListener);
        }
        this.fireTooltipDestroyed();
    }

    public TooltipWay getActualDisplayWay() {
        Component component2 = this.getComponent();
        if (this.displayWay != null) {
            if (this.displayWay == TooltipWay.leading || this.displayWay == TooltipWay.trailing) {
                if (component2 != null) {
                    boolean ltr = component2.getComponentOrientation().isLeftToRight();
                    if (ltr ? this.displayWay == TooltipWay.leading : this.displayWay == TooltipWay.trailing) {
                        return TooltipWay.left;
                    }
                    return TooltipWay.right;
                }
                return this.displayWay == TooltipWay.leading ? TooltipWay.left : TooltipWay.right;
            }
            return this.displayWay;
        }
        if (component2 == null || !component2.isShowing()) {
            return TooltipWay.down;
        }
        Component glassPane = SwingUtilities.getRootPane(component2).getGlassPane();
        if (!glassPane.isShowing()) {
            return TooltipWay.down;
        }
        Dimension rootSize = glassPane.getSize();
        Rectangle componentBounds = CoreSwingUtils.getRelativeBounds(component2, glassPane);
        Dimension ps = this.getPreferredSize();
        if (componentBounds.y + this.getTooltipPoint((Component)component2, (TooltipWay)TooltipWay.down).y + ps.height < rootSize.height - this.windowSideSpacing) {
            return TooltipWay.down;
        }
        if (componentBounds.y + this.getTooltipPoint((Component)component2, (TooltipWay)TooltipWay.up).y - ps.height > this.windowSideSpacing) {
            return TooltipWay.up;
        }
        if (componentBounds.x + this.getTooltipPoint((Component)component2, (TooltipWay)TooltipWay.right).x + ps.width < rootSize.width - this.windowSideSpacing) {
            return TooltipWay.right;
        }
        if (componentBounds.x + this.getTooltipPoint((Component)component2, (TooltipWay)TooltipWay.left).x - ps.width > this.windowSideSpacing) {
            return TooltipWay.left;
        }
        return TooltipWay.down;
    }

    private Point getTooltipPoint(Component component2, TooltipWay tooltipWay) {
        if (this.displayLocation == null) {
            if (tooltipWay == TooltipWay.down) {
                return new Point(component2.getWidth() / 2, component2.getHeight() - 4 + this.shadeWidth);
            }
            if (tooltipWay == TooltipWay.up) {
                return new Point(component2.getWidth() / 2, 4 - this.shadeWidth);
            }
            if (tooltipWay == TooltipWay.left) {
                return new Point(4 - this.shadeWidth, this.getHeight() / 2);
            }
            return new Point(component2.getWidth() - 4 + this.shadeWidth, this.getHeight() / 2);
        }
        return this.displayLocation;
    }

    public void updateBorder() {
        TooltipWay displayWay = this.getActualDisplayWay();
        int leftSpacing = this.shadeWidth + this.contentSpacing + this.leftRightSpacing + (displayWay == TooltipWay.right ? 8 : 0);
        int rightSpacing = this.shadeWidth + this.contentSpacing + this.leftRightSpacing + (displayWay == TooltipWay.left ? 8 : 0);
        int topSpacing = this.shadeWidth + this.contentSpacing + (displayWay == TooltipWay.down ? 8 : 0);
        int bottomSpacing = this.shadeWidth + this.contentSpacing + (displayWay == TooltipWay.up ? 8 : 0);
        Insets hm = this.getHotkeyMargins();
        this.setBorder(new WebBorder(topSpacing + hm.top, leftSpacing + hm.left, bottomSpacing + hm.bottom, rightSpacing + hm.right));
        this.revalidate();
    }

    private Insets getHotkeyMargins() {
        boolean ltr = this.getComponentOrientation().isLeftToRight();
        boolean leftHotkey = this.hotkeyLocation == 2 || this.hotkeyLocation == 10 && ltr || this.hotkeyLocation == 11 && !ltr;
        int left = this.showHotkey && leftHotkey ? 0 : 2;
        int right = this.showHotkey && !leftHotkey ? 0 : 2;
        return new Insets(0, left, 0, right);
    }

    @Override
    public void applyComponentOrientation(ComponentOrientation o) {
        super.applyComponentOrientation(o);
        this.closeTooltip();
    }

    public int getContentSpacing() {
        return this.contentSpacing;
    }

    public void setContentSpacing(int contentSpacing) {
        this.contentSpacing = contentSpacing;
        this.updateBorder();
    }

    public int getLeftRightSpacing() {
        return this.leftRightSpacing;
    }

    public void setLeftRightSpacing(int leftRightSpacing) {
        this.leftRightSpacing = leftRightSpacing;
        this.updateBorder();
        this.updateLocation();
    }

    public void updateLocation() {
        Component component2 = this.getComponent();
        Container parent = this.getParent();
        if (component2 != null && component2.isShowing() && parent != null && parent.isShowing()) {
            TooltipWay displayWay = this.getActualDisplayWay();
            Point p = CoreSwingUtils.locationOnScreen(parent);
            Point c = CoreSwingUtils.locationOnScreen(component2);
            Dimension ps = this.getPreferredSize();
            int x0 = c.x - p.x;
            int y0 = c.y - p.y;
            if (displayWay == TooltipWay.up || displayWay == TooltipWay.down) {
                int compTipY;
                int compMiddle;
                if (this.displayLocation == null) {
                    if (this.relativeToBounds == null) {
                        Component rtc = this.getRelativeToComponent();
                        if (rtc == null) {
                            compMiddle = x0 + component2.getWidth() / 2;
                            compTipY = y0 + (displayWay == TooltipWay.up ? 4 - this.shadeWidth - ps.height : component2.getHeight() - 4 + this.shadeWidth);
                        } else {
                            Rectangle b = CoreSwingUtils.getRelativeBounds(rtc, component2);
                            compMiddle = x0 + b.x + b.width / 2;
                            compTipY = y0 + b.y + (displayWay == TooltipWay.up ? 4 - this.shadeWidth - ps.height : b.height - 4 + this.shadeWidth);
                        }
                    } else {
                        Rectangle b = this.relativeToBounds;
                        compMiddle = x0 + b.x + b.width / 2;
                        compTipY = y0 + b.y + (displayWay.equals((Object)TooltipWay.up) ? 4 - this.shadeWidth - ps.height : b.height - 4 + this.shadeWidth);
                    }
                } else {
                    compMiddle = x0 + this.displayLocation.x;
                    compTipY = y0 + this.displayLocation.y - (displayWay == TooltipWay.up ? ps.height : 0);
                }
                if (compMiddle - ps.width / 2 < this.windowSideSpacing) {
                    int cw = this.windowSideSpacing - (compMiddle - ps.width / 2);
                    this.cornerPeak = Math.max(this.shadeWidth + this.round + 7 + 1, this.getWidth() / 2 - cw);
                    this.setLocation(this.windowSideSpacing, compTipY);
                } else if (compMiddle + ps.width / 2 > parent.getWidth() - this.windowSideSpacing) {
                    int cw = compMiddle + ps.width / 2 - (parent.getWidth() - this.windowSideSpacing);
                    this.cornerPeak = Math.min(ps.width - this.shadeWidth - this.round - 7 - 1, this.getWidth() / 2 + cw);
                    this.setLocation(parent.getWidth() - this.windowSideSpacing - ps.width, compTipY);
                } else {
                    this.cornerPeak = this.getWidth() / 2;
                    this.setLocation(compMiddle - ps.width / 2, compTipY);
                }
            } else if (displayWay == TooltipWay.left || displayWay == TooltipWay.right) {
                int compTipX;
                int compMiddle;
                if (this.displayLocation == null) {
                    if (this.relativeToBounds == null) {
                        Component rtc = this.getRelativeToComponent();
                        if (rtc == null) {
                            compMiddle = y0 + component2.getHeight() / 2;
                            compTipX = x0 + (displayWay == TooltipWay.left ? 4 - this.shadeWidth - ps.width : component2.getWidth() - 4 + this.shadeWidth);
                        } else {
                            Rectangle b = CoreSwingUtils.getRelativeBounds(rtc, component2);
                            compMiddle = y0 + b.y + b.height / 2;
                            compTipX = x0 + b.x + (displayWay == TooltipWay.left ? 4 - this.shadeWidth - ps.width : b.width - 4 + this.shadeWidth);
                        }
                    } else {
                        Rectangle b = this.relativeToBounds;
                        compMiddle = y0 + b.y + b.height / 2;
                        compTipX = x0 + b.x + (displayWay == TooltipWay.left ? 4 - this.shadeWidth - ps.width : b.width - 4 + this.shadeWidth);
                    }
                } else {
                    compMiddle = y0 + this.displayLocation.y;
                    compTipX = x0 + this.displayLocation.x - (displayWay == TooltipWay.left ? ps.width : 0);
                }
                if (compMiddle - ps.height / 2 < this.windowSideSpacing) {
                    int cw = this.windowSideSpacing - (compMiddle - ps.height / 2);
                    this.cornerPeak = Math.max(this.shadeWidth + this.round + 7 + 1, this.getHeight() / 2 - cw);
                    this.setLocation(compTipX, this.windowSideSpacing);
                } else if (compMiddle + ps.height / 2 > parent.getHeight() - this.windowSideSpacing) {
                    int cw = compMiddle + ps.height / 2 - (parent.getHeight() - this.windowSideSpacing);
                    this.cornerPeak = Math.min(ps.height - this.shadeWidth - this.round - 7 - 1, this.getHeight() / 2 + cw);
                    this.setLocation(compTipX, parent.getHeight() - this.windowSideSpacing - ps.height);
                } else {
                    this.cornerPeak = this.getHeight() / 2;
                    this.setLocation(compTipX, compMiddle - ps.height / 2);
                }
            }
            this.setSize(this.getPreferredSize());
        }
    }

    public Point getDisplayLocation() {
        return this.displayLocation;
    }

    public void setDisplayLocation(int x, int y) {
        this.setDisplayLocation(new Point(x, y));
    }

    public void setDisplayLocation(Point displayLocation) {
        this.displayLocation = displayLocation;
        this.updateLocation();
    }

    public Rectangle getRelativeToBounds() {
        return this.relativeToBounds;
    }

    public void setRelativeToBounds(Rectangle relativeToBounds) {
        this.relativeToBounds = relativeToBounds;
        this.updateLocation();
    }

    public Component getRelativeToComponent() {
        return this.relativeToComponent != null ? (Component)this.relativeToComponent.get() : null;
    }

    public void setRelativeToComponent(Component component2) {
        this.relativeToComponent = new WeakReference<Component>(component2);
        this.updateLocation();
    }

    public int getWindowSideSpacing() {
        return this.windowSideSpacing;
    }

    public void setWindowSideSpacing(int windowSideSpacing) {
        this.windowSideSpacing = windowSideSpacing;
        this.updateLocation();
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int round) {
        this.round = round;
        this.updateLocation();
    }

    public ShadeType getShadeType() {
        return this.shadeType;
    }

    public void setShadeType(ShadeType shadeType) {
        this.shadeType = shadeType;
    }

    public int getShadeWidth() {
        return this.shadeWidth;
    }

    public void setShadeWidth(int shadeWidth) {
        this.shadeWidth = shadeWidth;
        this.updateBorder();
        this.updateLocation();
    }

    public Color getShadeColor() {
        return this.shadeColor;
    }

    public void setShadeColor(Color shadeColor) {
        this.shadeColor = shadeColor;
        this.repaint();
    }

    public Component getComponent() {
        return (Component)this.component.get();
    }

    public String getId() {
        return this.id;
    }

    public JComponent getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        if (this.tooltip != null && this.tooltip instanceof JLabel) {
            ((JLabel)this.tooltip).setText(tooltip);
            this.updateBorder();
            this.updateLocation();
        }
    }

    public void setTooltip(JComponent tooltip) {
        if (this.tooltip != null) {
            this.remove(this.tooltip);
        }
        this.tooltip = tooltip;
        this.add((Component)tooltip, "Center");
        this.updateBorder();
        this.updateLocation();
    }

    public TooltipWay getDisplayWay() {
        return this.displayWay;
    }

    public void setDisplayWay(TooltipWay displayWay) {
        this.displayWay = displayWay;
        this.updateBorder();
        this.updateLocation();
    }

    public boolean isShowHotkey() {
        return this.showHotkey;
    }

    public void setShowHotkey(boolean showHotkey) {
        this.showHotkey = showHotkey;
        this.updateHotkey();
        this.updateBorder();
        this.updateLocation();
    }

    public int getHotkeyLocation() {
        return this.hotkeyLocation;
    }

    public void setHotkeyLocation(int hotkeyLocation) {
        this.hotkeyLocation = hotkeyLocation;
        this.updateHotkey();
        this.updateBorder();
        this.updateLocation();
    }

    public boolean isDefaultCloseBehavior() {
        return this.defaultCloseBehavior;
    }

    public void setDefaultCloseBehavior(boolean defaultCloseBehavior) {
        this.defaultCloseBehavior = defaultCloseBehavior;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public Color getHotkeyColor() {
        return this.hotkey.getForeground();
    }

    public void setHotkeyColor(Color hotkeyColor) {
        this.hotkey.setForeground(hotkeyColor);
    }

    public Color getTopBgColor() {
        return this.topBgColor;
    }

    public void setTopBgColor(Color topBgColor) {
        this.topBgColor = topBgColor;
    }

    public Color getBottomBgColor() {
        return this.bottomBgColor;
    }

    public void setBottomBgColor(Color bottomBgColor) {
        this.bottomBgColor = bottomBgColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setOpacity(float opacity) {
        this.opacity = opacity;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        Object aa = GraphicsUtils.setupAntialias(g2d);
        if (this.fade < 1.0f) {
            GraphicsUtils.setupAlphaComposite(g2d, Float.valueOf(this.fade));
        }
        Composite oc = null;
        if (this.opacity < 1.0f) {
            oc = GraphicsUtils.setupAlphaComposite(g2d, Float.valueOf(this.opacity));
        }
        TooltipWay displayWay = this.getActualDisplayWay();
        Shape bs = null;
        if (this.shadeWidth > 0 && this.shadeColor != null) {
            bs = this.getTooltipShape(displayWay, false);
        }
        GraphicsUtils.drawShade(g2d, bs, this.shadeType, this.shadeColor, this.shadeWidth);
        if (this.topBgColor != null) {
            if (this.bottomBgColor != null) {
                if (displayWay == TooltipWay.down) {
                    g2d.setPaint(new GradientPaint(0.0f, this.getHeight() * 2 / 3, this.topBgColor, 0.0f, this.getHeight(), this.bottomBgColor));
                } else {
                    g2d.setPaint(new GradientPaint(0.0f, this.getHeight() / 3, this.topBgColor, 0.0f, this.getHeight(), this.bottomBgColor));
                }
            } else {
                g2d.setPaint(this.topBgColor);
            }
            g2d.fill(this.getTooltipShape(displayWay, true));
        }
        if (this.borderColor != null) {
            g2d.setPaint(this.borderColor);
            g2d.draw(bs);
        }
        if (oc != null) {
            GraphicsUtils.restoreComposite(g2d, oc);
        }
        GraphicsUtils.restoreAntialias(g2d, aa);
    }

    private Shape getTooltipShape(TooltipWay displayWay, boolean fill) {
        float fillExtend = fill ? 1.0f : 0.0f;
        float widthMinus = (float)(displayWay == TooltipWay.left || displayWay == TooltipWay.right ? 9 : 1) - fillExtend + (float)(this.shadeWidth * 2);
        float heightMinus = (float)(displayWay == TooltipWay.up || displayWay == TooltipWay.down ? 9 : 1) - fillExtend + (float)(this.shadeWidth * 2);
        Area borderShape = new Area(new RoundRectangle2D.Double(this.shadeWidth + (displayWay == TooltipWay.right ? 8 : 0), this.shadeWidth + (displayWay == TooltipWay.down ? 8 : 0), (float)this.getWidth() - widthMinus, (float)this.getHeight() - heightMinus, this.round * 2, this.round * 2));
        fillExtend = fill ? 0.5f : 0.0f;
        GeneralPath gp = new GeneralPath(0);
        if (displayWay == TooltipWay.up) {
            gp.moveTo((float)this.cornerPeak + fillExtend, this.getHeight() - this.shadeWidth - 1);
            gp.lineTo((float)(this.cornerPeak - 7) + fillExtend, this.getHeight() - this.shadeWidth - 1 - 8);
            gp.lineTo((float)(this.cornerPeak + 7) + fillExtend, this.getHeight() - this.shadeWidth - 1 - 8);
        } else if (displayWay == TooltipWay.down) {
            gp.moveTo(this.cornerPeak, this.shadeWidth);
            gp.lineTo(this.cornerPeak - 7, this.shadeWidth + 8);
            gp.lineTo(this.cornerPeak + 7, this.shadeWidth + 8);
        } else if (displayWay == TooltipWay.left) {
            gp.moveTo(this.getWidth() - this.shadeWidth - 1, (float)this.cornerPeak + fillExtend);
            gp.lineTo(this.getWidth() - this.shadeWidth - 1 - 8, (float)this.cornerPeak + fillExtend - 7.0f);
            gp.lineTo(this.getWidth() - this.shadeWidth - 1 - 8, (float)this.cornerPeak + fillExtend + 7.0f);
        } else if (displayWay == TooltipWay.right) {
            gp.moveTo(this.shadeWidth, this.cornerPeak);
            gp.lineTo(this.shadeWidth + 8, this.cornerPeak - 7);
            gp.lineTo(this.shadeWidth + 8, this.cornerPeak + 7);
        }
        gp.closePath();
        borderShape.add(new Area(gp));
        return borderShape;
    }

    public void addTooltipListener(TooltipListener listener) {
        this.listeners.add(listener);
    }

    public void removeTooltipListener(TooltipListener listener) {
        this.listeners.remove(listener);
    }

    public void removeAllTooltipListeners() {
        this.listeners.clear();
    }

    private void fireTooltipShown() {
        for (TooltipListener listener : CollectionUtils.copy(this.listeners)) {
            listener.tooltipShowing();
        }
    }

    private void fireTooltipFullyShown() {
        for (TooltipListener listener : CollectionUtils.copy(this.listeners)) {
            listener.tooltipShown();
        }
    }

    private void fireTooltipHidden() {
        for (TooltipListener listener : CollectionUtils.copy(this.listeners)) {
            listener.tooltipHidden();
        }
    }

    private void fireTooltipDestroyed() {
        for (TooltipListener listener : CollectionUtils.copy(this.listeners)) {
            listener.tooltipDestroyed();
        }
    }

    public static WebStyledLabel createDefaultComponent(Icon icon, String tooltip) {
        WebStyledLabel label = new WebStyledLabel(StyleId.customtooltipLabel, tooltip, icon);
        label.setFont(WebLookAndFeel.toolTipFont != null ? WebLookAndFeel.toolTipFont : WebLookAndFeel.globalTooltipFont);
        return label;
    }
}

