/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.laf.WebLookAndFeel;
import com.alee.managers.style.Bounds;
import com.alee.managers.style.BoundsType;
import com.alee.managers.style.ComponentDescriptor;
import com.alee.managers.style.PainterShapeProvider;
import com.alee.managers.style.StyleManager;
import com.alee.painter.PaintParameters;
import com.alee.painter.Painter;
import com.alee.painter.PainterException;
import com.alee.painter.ParameterizedPaint;
import com.alee.painter.SpecificPainter;
import com.alee.painter.decoration.AbstractDecorationPainter;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.WeakComponentData;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Shape;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public final class PainterSupport {
    @NotNull
    private static final WeakComponentData<JComponent, Painter> installedPainters = new WeakComponentData("PainterSupport.painter", 200);
    @NotNull
    private static final WeakComponentData<JComponent, Insets> margins = new WeakComponentData("PainterSupport.margin", 200);
    @NotNull
    private static final WeakComponentData<JComponent, Insets> paddings = new WeakComponentData("PainterSupport.padding", 200);
    @NotNull
    private static final WeakComponentData<JComponent, Boolean> shapeDetectionEnabled = new WeakComponentData("PainterSupport.shapeDetectionEnabled", 200);

    @Nullable
    public static Painter getPainter(@Nullable Component component2) {
        return component2 instanceof JComponent ? installedPainters.get((JComponent)component2) : null;
    }

    public static void setPainter(@NotNull JComponent component2, @NotNull ComponentUI componentUI, @Nullable Painter painter) {
        ComponentDescriptor descriptor = StyleManager.getDescriptor(component2);
        Object newPainter = PainterSupport.getApplicablePainter(painter, descriptor.getPainterInterface(), descriptor.getPainterAdapterClass());
        Painter oldPainter = installedPainters.get(component2);
        if (oldPainter != null) {
            oldPainter.uninstall(component2, componentUI);
            installedPainters.clear(component2);
        }
        if (newPainter != null) {
            newPainter.install((JComponent)component2, (ComponentUI)componentUI);
            installedPainters.set(component2, (Painter)newPainter);
            Boolean opaque = newPainter.isOpaque();
            if (opaque != null) {
                LookAndFeel.installProperty(component2, "opaque", opaque != false ? Boolean.TRUE : Boolean.FALSE);
            }
        }
        SwingUtils.firePropertyChanged(component2, "painter", oldPainter, newPainter);
    }

    private static <P extends SpecificPainter> P getApplicablePainter(@Nullable Painter painter, @NotNull Class<P> requested, @NotNull Class<? extends P> adaptiveClass) {
        SpecificPainter result2 = painter != null ? (ReflectUtils.isAssignable(requested, painter.getClass()) ? (SpecificPainter)painter : (SpecificPainter)ReflectUtils.createInstanceSafely(adaptiveClass, painter)) : null;
        return (P)result2;
    }

    @Nullable
    public static Insets getInsets(@Nullable Component component2) {
        Insets insets = component2 instanceof JComponent ? ((JComponent)component2).getInsets() : null;
        return insets;
    }

    @Nullable
    public static Insets getMargin(@NotNull JComponent component2) {
        return PainterSupport.getMargin(component2, false);
    }

    @Nullable
    public static Insets getMargin(@NotNull JComponent component2, boolean applyOrientation) {
        Insets result2;
        Insets margin = margins.get(component2);
        if (margin != null) {
            if (applyOrientation) {
                boolean ltr = component2.getComponentOrientation().isLeftToRight();
                result2 = new Insets(margin.top, ltr ? margin.left : margin.right, margin.bottom, ltr ? margin.right : margin.left);
            } else {
                result2 = new Insets(margin.top, margin.left, margin.bottom, margin.right);
            }
        } else {
            result2 = null;
        }
        return result2;
    }

    public static void setMargin(@NotNull JComponent component2, int margin) {
        PainterSupport.setMargin(component2, margin, margin, margin, margin);
    }

    public static void setMargin(@NotNull JComponent component2, int top, int left, int bottom, int right) {
        PainterSupport.setMargin(component2, new Insets(top, left, bottom, right));
    }

    public static void setMargin(@NotNull JComponent component2, @Nullable Insets margin) {
        Insets oldMargin = margins.get(component2);
        if (oldMargin == null || oldMargin instanceof UIResource || !(margin instanceof UIResource)) {
            margins.set(component2, margin);
            SwingUtils.firePropertyChanged(component2, "lafMargin", oldMargin, margin);
        }
    }

    @Nullable
    public static Insets getPadding(@NotNull JComponent component2) {
        return PainterSupport.getPadding(component2, false);
    }

    @Nullable
    public static Insets getPadding(@NotNull JComponent component2, boolean applyOrientation) {
        Insets result2;
        Insets padding = paddings.get(component2);
        if (padding != null) {
            if (applyOrientation) {
                boolean ltr = component2.getComponentOrientation().isLeftToRight();
                result2 = new Insets(padding.top, ltr ? padding.left : padding.right, padding.bottom, ltr ? padding.right : padding.left);
            } else {
                result2 = new Insets(padding.top, padding.left, padding.bottom, padding.right);
            }
        } else {
            result2 = null;
        }
        return result2;
    }

    public static void setPadding(@NotNull JComponent component2, int padding) {
        PainterSupport.setPadding(component2, padding, padding, padding, padding);
    }

    public static void setPadding(@NotNull JComponent component2, int top, int left, int bottom, int right) {
        PainterSupport.setPadding(component2, new Insets(top, left, bottom, right));
    }

    public static void setPadding(@NotNull JComponent component2, @Nullable Insets padding) {
        Insets oldPadding = paddings.get(component2);
        if (oldPadding == null || oldPadding instanceof UIResource || !(padding instanceof UIResource)) {
            paddings.set(component2, padding);
            SwingUtils.firePropertyChanged(component2, "lafPadding", oldPadding, padding);
        }
    }

    @NotNull
    public static Shape getShape(@NotNull JComponent component2) {
        Painter painter = PainterSupport.getPainter(component2);
        Shape shape = painter instanceof PainterShapeProvider ? ((PainterShapeProvider)((Object)painter)).provideShape(component2, BoundsType.margin.bounds(component2)) : BoundsType.margin.bounds(component2);
        return shape;
    }

    public static boolean isShapeDetectionEnabled(@NotNull JComponent component2) {
        Boolean enabled = shapeDetectionEnabled.get(component2);
        return enabled != null ? enabled : WebLookAndFeel.isShapeDetectionEnabled();
    }

    public static void setShapeDetectionEnabled(@NotNull JComponent component2, boolean enabled) {
        shapeDetectionEnabled.set(component2, enabled);
    }

    public static boolean contains(@NotNull JComponent component2, @NotNull ComponentUI componentUI, int x, int y) {
        Painter painter = PainterSupport.getPainter(component2);
        boolean contains = painter != null && PainterSupport.isShapeDetectionEnabled(component2) ? painter.contains(component2, componentUI, new Bounds(component2), x, y) : 0 <= x && x < component2.getWidth() && 0 <= y && y < component2.getHeight();
        return contains;
    }

    public static int getBaseline(@NotNull JComponent component2, @NotNull ComponentUI componentUI, int width, int height) {
        Border border;
        int baseline = -1;
        Painter painter = PainterSupport.getPainter(component2);
        if (painter != null) {
            Bounds componentBounds = new Bounds(new Dimension(width, height));
            baseline = painter.getBaseline(component2, componentUI, componentBounds);
        }
        if (baseline == -1 && (border = component2.getBorder()) instanceof AbstractBorder) {
            baseline = ((AbstractBorder)border).getBaseline(component2, width, height);
        }
        return baseline;
    }

    @NotNull
    public static Component.BaselineResizeBehavior getBaselineResizeBehavior(@NotNull JComponent component2, @NotNull ComponentUI componentUI) {
        Component.BaselineResizeBehavior behavior;
        Painter painter = PainterSupport.getPainter(component2);
        if (painter != null) {
            behavior = painter.getBaselineResizeBehavior(component2, componentUI);
        } else {
            Border border = component2.getBorder();
            if (border instanceof AbstractBorder) {
                AbstractBorder abstractBorder = (AbstractBorder)border;
                behavior = abstractBorder.getBaselineResizeBehavior(component2);
            } else {
                behavior = Component.BaselineResizeBehavior.OTHER;
            }
        }
        return behavior;
    }

    public static void paint(@NotNull Graphics g, @NotNull JComponent component2, @NotNull ComponentUI ui) {
        Painter painter = PainterSupport.getPainter(component2);
        if (painter != null) {
            painter.paint((Graphics2D)g, component2, ui, new Bounds(component2));
        }
    }

    public static void paint(@NotNull Graphics g, @NotNull JComponent component2, @NotNull ComponentUI ui, @NotNull PaintParameters parameters) {
        Painter painter = PainterSupport.getPainter(component2);
        if (painter != null) {
            if (painter instanceof ParameterizedPaint) {
                ParameterizedPaint parameterizedPaint = (ParameterizedPaint)((Object)painter);
                parameterizedPaint.prepareToPaint(parameters);
                painter.paint((Graphics2D)g, component2, ui, new Bounds(component2));
            } else {
                throw new PainterException("Painter doesn't support parameters: " + painter);
            }
        }
    }

    @Nullable
    public static Dimension getPreferredSize(@NotNull JComponent component2) {
        return PainterSupport.getPreferredSize(component2, null, false);
    }

    @Nullable
    public static Dimension getPreferredSize(@NotNull JComponent component2, @Nullable Dimension preferred) {
        return PainterSupport.getPreferredSize(component2, preferred, false);
    }

    @Nullable
    public static Dimension getPreferredSize(@NotNull JComponent component2, @Nullable Dimension preferred, boolean ignoreLayoutSize) {
        LayoutManager layout;
        WebLookAndFeel.checkEventDispatchThread();
        Painter painter = PainterSupport.getPainter(component2);
        Dimension ps = SwingUtils.max(preferred, painter != null ? painter.getPreferredSize() : null);
        if (!ignoreLayoutSize && (layout = component2.getLayout()) != null) {
            ps = SwingUtils.max(ps, layout.preferredLayoutSize(component2));
        }
        return ps;
    }

    public static boolean isDecoratable(@Nullable Component component2) {
        return PainterSupport.getPainter(component2) instanceof AbstractDecorationPainter;
    }
}

