/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.common;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.managers.style.Bounds;
import com.alee.painter.AbstractPainter;
import com.alee.utils.ninepatch.NinePatchIcon;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class NinePatchIconPainter<C extends JComponent, U extends ComponentUI>
extends AbstractPainter<C, U> {
    @Nullable
    protected NinePatchIcon icon;

    public NinePatchIconPainter() {
        this(null);
    }

    public NinePatchIconPainter(@Nullable NinePatchIcon icon) {
        this.setNinePatchIcon(icon);
    }

    @Nullable
    public NinePatchIcon getNinePatchIcon() {
        return this.icon;
    }

    public void setNinePatchIcon(@Nullable NinePatchIcon icon) {
        if (this.icon != null && this.isInstalled()) {
            this.icon.setComponent(null);
        }
        this.icon = icon;
        if (this.icon != null && this.isInstalled()) {
            this.icon.setComponent(this.component);
        }
        this.updateAll();
    }

    @Override
    protected void installPropertiesAndListeners() {
        super.installPropertiesAndListeners();
        this.installIconComponent();
    }

    @Override
    protected void uninstallPropertiesAndListeners() {
        this.uninstallIconComponent();
        super.uninstallPropertiesAndListeners();
    }

    protected void installIconComponent() {
        if (this.icon != null) {
            this.icon.setComponent(this.component);
        }
    }

    protected void uninstallIconComponent() {
        if (this.icon != null) {
            this.icon.setComponent(null);
        }
    }

    @Override
    @Nullable
    protected Insets getBorder() {
        return this.icon != null ? this.icon.getMargin() : null;
    }

    @Override
    public void paint(@NotNull Graphics2D g2d, @NotNull C c, @NotNull U ui, @NotNull Bounds bounds) {
        if (this.icon != null) {
            this.icon.paintIcon(g2d, bounds.get());
        }
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        return this.icon != null ? this.icon.getPreferredSize() : super.getPreferredSize();
    }
}

