/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.common;

import com.alee.api.annotations.NotNull;
import com.alee.managers.style.Bounds;
import com.alee.painter.common.BorderPainter;
import com.alee.painter.common.TitlePosition;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.plaf.ComponentUI;

public class TitledBorderPainter<C extends JComponent, U extends ComponentUI>
extends BorderPainter<C, U>
implements SwingConstants {
    protected int titleOffset = 4;
    protected int titleBorderGap = 3;
    protected TitlePosition titlePosition = TitlePosition.insideLine;
    protected Color foreground = null;
    protected Color background = null;
    protected boolean clipTitleBackground = true;
    protected int titleAlignment;
    protected int titleSide;
    protected String titleText;
    protected transient int w;
    protected transient int h;
    protected transient int sw;
    protected transient boolean emptyTitle;
    protected transient FontMetrics fontMetrics;
    protected transient int titleAreaHeight;
    protected transient int titleWidth;
    protected transient int titleX;
    protected transient int titleY;
    protected transient double borderCenter;
    protected transient double borderPosition;
    protected transient Shape borderShape;
    protected transient boolean doClip;

    public TitledBorderPainter() {
        this((String)null);
    }

    public TitledBorderPainter(String titleText) {
        this(titleText, 10);
    }

    public TitledBorderPainter(String titleText, int titleAlignment) {
        this(titleText, titleAlignment, 1);
    }

    public TitledBorderPainter(String titleText, int titleAlignment, int titleSide) {
        this.titleText = titleText;
        this.titleAlignment = titleAlignment;
        this.titleSide = titleSide;
    }

    public int getTitleOffset() {
        return this.titleOffset;
    }

    public void setTitleOffset(int titleOffset) {
        this.titleOffset = titleOffset;
        this.updateAll();
    }

    public int getTitleBorderGap() {
        return this.titleBorderGap;
    }

    public void setTitleBorderGap(int titleBorderGap) {
        this.titleBorderGap = titleBorderGap;
        this.updateAll();
    }

    public int getTitleSide() {
        return this.titleSide;
    }

    public void setTitleSide(int titleSide) {
        this.titleSide = titleSide;
        this.updateAll();
    }

    public int getTitleAlignment() {
        return this.titleAlignment;
    }

    public void setTitleAlignment(int titleAlignment) {
        this.titleAlignment = titleAlignment;
        this.repaint();
    }

    public TitlePosition getTitlePosition() {
        return this.titlePosition;
    }

    public void setTitlePosition(TitlePosition titlePosition) {
        this.titlePosition = titlePosition;
        this.repaint();
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color foreground) {
        this.foreground = foreground;
        this.repaint();
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        this.background = background;
        this.repaint();
    }

    public boolean isClipTitleBackground() {
        return this.clipTitleBackground;
    }

    public void setClipTitleBackground(boolean clipTitleBackground) {
        this.clipTitleBackground = clipTitleBackground;
        this.repaint();
    }

    public String getTitleText() {
        return this.titleText;
    }

    public void setTitleText(String titleText) {
        this.titleText = titleText;
        this.updateAll();
    }

    @Override
    @NotNull
    protected Insets getBorder() {
        Insets m = super.getBorder();
        if (!this.isEmptyTitle()) {
            switch (this.titleSide) {
                case 1: {
                    m.top += this.getTitleAreaHeight(this.component);
                    break;
                }
                case 2: {
                    m.left += this.getTitleAreaHeight(this.component);
                    break;
                }
                case 3: {
                    m.bottom += this.getTitleAreaHeight(this.component);
                    break;
                }
                case 4: {
                    m.right += this.getTitleAreaHeight(this.component);
                }
            }
        }
        return m;
    }

    @Override
    public void paint(@NotNull Graphics2D g2d, @NotNull C c, @NotNull U ui, @NotNull Bounds bounds) {
        this.w = ((JComponent)c).getWidth();
        this.h = ((JComponent)c).getHeight();
        this.sw = this.getStrokeWidth();
        this.emptyTitle = this.isEmptyTitle();
        this.fontMetrics = this.emptyTitle ? null : ((JComponent)c).getFontMetrics(((Component)c).getFont());
        this.titleWidth = this.emptyTitle ? 0 : this.fontMetrics.stringWidth(this.titleText);
        this.titleAreaHeight = this.getTitleAreaHeight(c);
        this.titleX = this.getTitleX();
        this.titleY = this.getTitleY();
        this.borderCenter = (double)this.sw / 2.0;
        this.borderPosition = this.getBorderPosition();
        this.borderShape = this.getBorderShape();
        this.doClip = this.clipTitleBackground && !this.emptyTitle && this.titlePosition.equals((Object)TitlePosition.insideLine);
        Object aa = GraphicsUtils.setupAntialias(g2d);
        Stroke os = GraphicsUtils.setupStroke(g2d, this.stroke, this.stroke != null);
        if (this.background != null && !this.doClip) {
            g2d.setPaint(this.background);
            g2d.fill(this.borderShape);
        }
        Shape clipShape = this.doClip ? this.getBorderClipShape() : null;
        Shape oldClip = GraphicsUtils.subtractClip(g2d, clipShape, this.doClip);
        if (this.background != null && this.doClip) {
            g2d.setPaint(this.background);
            g2d.fill(this.borderShape);
        }
        g2d.setPaint(this.color);
        g2d.draw(this.borderShape);
        GraphicsUtils.restoreClip(g2d, oldClip, this.doClip);
        GraphicsUtils.restoreStroke(g2d, os, this.stroke != null);
        GraphicsUtils.restoreAntialias(g2d, aa);
        if (!this.emptyTitle) {
            g2d.setPaint(this.foreground != null ? this.foreground : ((Component)c).getForeground());
            switch (this.titleSide) {
                case 1: 
                case 3: {
                    Map hints = SwingUtils.setupTextAntialias(g2d);
                    g2d.drawString(this.titleText, this.titleX, this.titleY);
                    SwingUtils.restoreTextAntialias(g2d, hints);
                    break;
                }
            }
        }
    }

    protected int getTitleX() {
        if (this.titleAlignment == 2 || this.titleAlignment == 10 && this.ltr || this.titleAlignment == 11 && !this.ltr) {
            return Math.max(this.sw, this.getRound()) + this.titleOffset + this.titleBorderGap;
        }
        if (this.titleAlignment == 4 || this.titleAlignment == 11 && this.ltr || this.titleAlignment == 10 && !this.ltr) {
            return this.w - Math.max(this.sw, this.getRound()) - this.titleOffset - this.titleBorderGap - this.titleWidth;
        }
        return this.w / 2 - this.titleWidth / 2;
    }

    protected int getTitleY() {
        int fontDescent = this.fontMetrics != null ? this.fontMetrics.getDescent() : 0;
        switch (this.titleSide) {
            case 1: {
                return this.titlePosition.equals((Object)TitlePosition.aboveLive) ? this.titleAreaHeight - this.sw - fontDescent : this.titleAreaHeight - fontDescent;
            }
            case 3: {
                return this.titlePosition.equals((Object)TitlePosition.belowLine) ? this.h - this.sw - fontDescent : this.h - fontDescent;
            }
            case 2: {
                break;
            }
        }
        return 0;
    }

    protected double getBorderPosition() {
        if (this.emptyTitle) {
            return this.borderCenter;
        }
        if (this.titlePosition.equals((Object)TitlePosition.insideLine)) {
            return (double)this.titleAreaHeight / 2.0;
        }
        if (this.titlePosition.equals((Object)TitlePosition.aboveLive)) {
            return (double)this.titleAreaHeight - this.borderCenter;
        }
        return this.borderCenter;
    }

    protected int getTitleAreaHeight(C c) {
        if (this.isEmptyTitle()) {
            return this.sw;
        }
        int height = ((JComponent)c).getFontMetrics(((Component)c).getFont()).getHeight();
        return this.titlePosition.equals((Object)TitlePosition.insideLine) ? height : height + this.sw;
    }

    protected boolean isEmptyTitle() {
        return this.titleText == null;
    }

    protected Shape getBorderShape() {
        RectangularShape rect = null;
        switch (this.titleSide) {
            case 1: {
                rect = new Rectangle2D.Double(this.borderCenter, this.borderPosition, (double)this.w - this.borderCenter * 2.0, (double)this.h - this.borderPosition - this.borderCenter);
                break;
            }
            case 2: {
                rect = new Rectangle2D.Double(this.borderPosition, this.borderCenter, (double)this.w - this.borderPosition - this.borderCenter, (double)this.h - this.borderCenter * 2.0);
                break;
            }
            case 3: {
                rect = new Rectangle2D.Double(this.borderCenter, this.borderCenter, (double)this.w - this.borderCenter * 2.0, (double)this.h - this.borderPosition - this.borderCenter);
                break;
            }
            case 4: {
                rect = new Rectangle2D.Double(this.borderCenter, this.borderCenter, (double)this.w - this.borderPosition - this.borderCenter, (double)this.h - this.borderCenter * 2.0);
            }
        }
        int round = this.getRound();
        return round <= 0 ? rect : new RoundRectangle2D.Double(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), round * 2, round * 2);
    }

    protected Shape getBorderClipShape() {
        if (this.emptyTitle) {
            return null;
        }
        switch (this.titleSide) {
            case 1: {
                return new RoundRectangle2D.Double(this.titleX - this.titleBorderGap, this.borderPosition - (double)(this.titleAreaHeight / 2), this.titleWidth + this.titleBorderGap * 2, this.titleAreaHeight, 3.0, 3.0);
            }
            case 3: {
                return new RoundRectangle2D.Double(this.titleX - this.titleBorderGap, (double)this.h - this.borderPosition - (double)(this.titleAreaHeight / 2), this.titleWidth + this.titleBorderGap * 2, this.titleAreaHeight, 3.0, 3.0);
            }
            case 2: {
                return null;
            }
            case 4: {
                return null;
            }
        }
        return null;
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension ps;
        if (this.isEmptyTitle()) {
            ps = super.getPreferredSize();
        } else {
            int titleAreaHeight = this.getTitleAreaHeight(this.component);
            int titleWidth = this.component.getFontMetrics(this.component.getFont()).stringWidth(this.titleText);
            int border = Math.max(this.getStrokeWidth(), this.getRound());
            int title = Math.max(titleAreaHeight, border);
            switch (this.titleSide) {
                case 1: 
                case 3: {
                    ps = new Dimension(border * 2 + titleWidth + this.titleOffset * 2 + this.titleBorderGap * 2, title + border);
                    break;
                }
                case 2: 
                case 4: {
                    ps = new Dimension(title + border, border * 2 + titleWidth + this.titleOffset * 2 + this.titleBorderGap * 2);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown title side: " + this.titleSide);
                }
            }
        }
        return ps;
    }
}

