/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration;

import com.alee.api.annotations.NotNull;
import com.alee.managers.style.Bounds;
import com.alee.painter.decoration.ContentDecoration;
import com.alee.painter.decoration.DecorationException;
import com.alee.painter.decoration.background.IBackground;
import com.alee.painter.decoration.border.BorderWidth;
import com.alee.painter.decoration.border.IBorder;
import com.alee.painter.decoration.border.LineBorder;
import com.alee.painter.decoration.shadow.IShadow;
import com.alee.painter.decoration.shadow.ShadowType;
import com.alee.painter.decoration.shape.IPartialShape;
import com.alee.painter.decoration.shape.IShape;
import com.alee.painter.decoration.shape.ShapeType;
import com.alee.utils.CollectionUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.SwingUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

@XStreamAlias(value="decoration")
public class WebDecoration<C extends JComponent, I extends WebDecoration<C, I>>
extends ContentDecoration<C, I> {
    @XStreamImplicit
    protected List<IShape> shapes = new ArrayList<IShape>(1);
    @XStreamImplicit
    protected List<IShadow> shadows = new ArrayList<IShadow>(1);
    @XStreamImplicit
    protected List<IBorder> borders = new ArrayList<IBorder>(1);
    @XStreamImplicit
    protected List<IBackground> backgrounds = new ArrayList<IBackground>(1);

    @Override
    public void activate(C c) {
        super.activate(c);
        if (this.hasShape()) {
            this.getShape().activate(c, this);
        }
        if (this.hasShadow(ShadowType.outer)) {
            this.getShadow(ShadowType.outer).activate(c, this);
        }
        if (this.hasShadow(ShadowType.inner)) {
            this.getShadow(ShadowType.inner).activate(c, this);
        }
        if (this.hasBorder()) {
            this.getBorder().activate(c, this);
        }
        if (this.hasBackground()) {
            for (IBackground background : this.getBackgrounds()) {
                background.activate(c, this);
            }
        }
    }

    @Override
    public void deactivate(C c) {
        super.deactivate(c);
        if (this.hasShape()) {
            this.getShape().deactivate(c, this);
        }
        if (this.hasShadow(ShadowType.outer)) {
            this.getShadow(ShadowType.outer).deactivate(c, this);
        }
        if (this.hasShadow(ShadowType.inner)) {
            this.getShadow(ShadowType.inner).deactivate(c, this);
        }
        if (this.hasBorder()) {
            this.getBorder().deactivate(c, this);
        }
        if (this.hasBackground()) {
            for (IBackground background : this.getBackgrounds()) {
                background.deactivate(c, this);
            }
        }
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.hasShape();
    }

    public boolean hasShape() {
        return CollectionUtils.notEmpty(this.shapes);
    }

    public IShape getShape() {
        if (CollectionUtils.notEmpty(this.shapes)) {
            if (this.shapes.size() == 1) {
                return this.shapes.get(0);
            }
            throw new DecorationException("Only one shape can be provided per decoration");
        }
        return null;
    }

    public boolean hasShadow(ShadowType type) {
        return CollectionUtils.notEmpty(this.shadows) && this.getShadow(type) != null;
    }

    public IShadow getShadow(ShadowType type) {
        if (CollectionUtils.notEmpty(this.shadows)) {
            if (this.shadows.size() == 1) {
                return this.shadows.get(0).getType() == type ? this.shadows.get(0) : null;
            }
            if (this.shadows.size() == 2) {
                if (this.shadows.get(0).getType() == type) {
                    return this.shadows.get(0);
                }
                if (this.shadows.get(1).getType() == type) {
                    return this.shadows.get(1);
                }
                throw new DecorationException("Provided shadows must have distinct types");
            }
            throw new DecorationException("Only two shadows with different types can be provided per decoration");
        }
        return null;
    }

    public int getShadowWidth(ShadowType type) {
        IShadow shadow = this.getShadow(type);
        return shadow != null ? shadow.getWidth() : 0;
    }

    public boolean hasBorder() {
        return CollectionUtils.notEmpty(this.borders);
    }

    public IBorder getBorder() {
        if (CollectionUtils.notEmpty(this.borders)) {
            if (this.borders.size() == 1) {
                return this.borders.get(0);
            }
            throw new DecorationException("Only one border can be provided per decoration");
        }
        return null;
    }

    @NotNull
    public BorderWidth getBorderWidth() {
        IBorder border = this.getBorder();
        return border != null ? border.getWidth() : BorderWidth.EMPTY;
    }

    public boolean hasBackground() {
        return CollectionUtils.notEmpty(this.backgrounds);
    }

    public List<IBackground> getBackgrounds() {
        return CollectionUtils.notEmpty(this.backgrounds) ? this.backgrounds : null;
    }

    @Override
    public Insets getBorderInsets(C c) {
        Insets insets = super.getBorderInsets(c);
        if (this.isVisible()) {
            IShape shape = this.getShape();
            BorderWidth bw = this.getBorderWidth();
            int sw = this.getShadowWidth(ShadowType.outer);
            if (shape instanceof IPartialShape) {
                int bottom;
                int left;
                int top;
                IPartialShape ps = (IPartialShape)shape;
                int n = ps.isPaintTop(c, this) ? bw.top + sw : (top = ps.isPaintTopLine(c, this) ? bw.top : 0);
                int n2 = ps.isPaintLeft(c, this) ? bw.left + sw : (left = ps.isPaintLeftLine(c, this) ? bw.left : 0);
                int n3 = ps.isPaintBottom(c, this) ? bw.bottom + sw : (bottom = ps.isPaintBottomLine(c, this) ? bw.bottom : 0);
                int right = ps.isPaintRight(c, this) ? bw.right + sw : (ps.isPaintRightLine(c, this) ? bw.right : 0);
                SwingUtils.increase(insets, new Insets(top, left, bottom, right));
            } else {
                SwingUtils.increase(insets, new Insets(bw.top + sw, bw.left + sw, bw.bottom + sw, bw.right + sw));
            }
        }
        return insets;
    }

    @Override
    public boolean contains(C c, Bounds b, int x, int y) {
        boolean contains;
        if (this.isVisible()) {
            IShape shape = this.getShape();
            if (shape != null) {
                Rectangle bounds = b.get();
                Shape backgroundShape = shape.getShape(ShapeType.background, bounds, c, this);
                contains = backgroundShape.contains(x, y);
            } else {
                contains = super.contains(c, b, x, y);
            }
        } else {
            contains = super.contains(c, b, x, y);
        }
        return contains;
    }

    @Override
    @NotNull
    public Shape provideShape(@NotNull C component2, @NotNull Rectangle bounds) {
        return this.isVisible() ? this.getShape().getShape(ShapeType.background, bounds, component2, this) : bounds;
    }

    @Override
    public void paint(Graphics2D g2d, C c, Bounds b) {
        Rectangle bounds = b.get();
        if (bounds.width > 0 && bounds.height > 0) {
            Rectangle2D cl;
            Rectangle2D rectangle2D = cl = g2d.getClip() instanceof Rectangle2D ? (Rectangle2D)g2d.getClip() : ((JComponent)c).getVisibleRect();
            if (bounds.intersects(cl)) {
                if (this.isVisible()) {
                    Object oaa = GraphicsUtils.setupAntialias(g2d);
                    Composite oc = GraphicsUtils.setupAlphaComposite(g2d, Float.valueOf(this.getOpacity()), this.getOpacity() < 1.0f);
                    Shape ocl = GraphicsUtils.setupClip(g2d, cl.createIntersection(bounds));
                    this.paintDecoration(g2d, c, b);
                    GraphicsUtils.restoreClip(g2d, ocl);
                    GraphicsUtils.restoreAntialias(g2d, oaa);
                    GraphicsUtils.restoreComposite(g2d, oc);
                }
                this.paintContent(g2d, b, c);
            }
        }
    }

    protected void paintDecoration(Graphics2D g2d, C c, Bounds b) {
        Shape s;
        Rectangle bounds = b.get();
        IShape shape = this.getShape();
        if (this.hasShadow(ShadowType.outer) && shape.isVisible(ShapeType.outerShadow, bounds, c, this)) {
            s = shape.getShape(ShapeType.outerShadow, bounds, c, this);
            this.getShadow(ShadowType.outer).paint(g2d, bounds, c, this, s);
        }
        if (this.hasBackground() && shape.isVisible(ShapeType.background, bounds, c, this)) {
            s = shape.getShape(ShapeType.background, bounds, c, this);
            for (IBackground background : this.getBackgrounds()) {
                background.paint(g2d, bounds, c, this, s);
            }
        }
        if (this.hasShadow(ShadowType.inner) && shape.isVisible(ShapeType.innerShadow, bounds, c, this)) {
            s = shape.getShape(ShapeType.innerShadow, bounds, c, this);
            this.getShadow(ShadowType.inner).paint(g2d, bounds, c, this, s);
        }
        if (this.hasBorder() && shape.isVisible(ShapeType.border, bounds, c, this)) {
            s = shape.getShape(ShapeType.border, bounds, c, this);
            IBorder border = this.getBorder();
            border.paint(g2d, bounds, c, this, s);
            if (shape instanceof IPartialShape && border instanceof LineBorder) {
                IPartialShape ps = (IPartialShape)shape;
                boolean ltr = ((Component)c).getComponentOrientation().isLeftToRight();
                boolean paintTop = ps.isPaintTop(c, this);
                boolean paintBottom = ps.isPaintBottom(c, this);
                boolean actualPaintLeft = ltr ? ps.isPaintLeft(c, this) : ps.isPaintRight(c, this);
                boolean actualPaintRight = ltr ? ps.isPaintRight(c, this) : ps.isPaintLeft(c, this);
                boolean paintTopLine = ps.isPaintTopLine(c, this);
                boolean paintBottomLine = ps.isPaintBottomLine(c, this);
                boolean actualPaintLeftLine = ltr ? ps.isPaintLeftLine(c, this) : ps.isPaintRightLine(c, this);
                boolean actualPaintRightLine = ltr ? ps.isPaintRightLine(c, this) : ps.isPaintLeftLine(c, this);
                int shadowWidth = this.getShadowWidth(ShadowType.outer);
                LineBorder lineBorder = (LineBorder)border;
                Stroke stroke = lineBorder.getStroke();
                Stroke os = GraphicsUtils.setupStroke(g2d, stroke, stroke != null);
                Color bc = lineBorder.getColor();
                Paint op = GraphicsUtils.setupPaint(g2d, bc, bc != null);
                if (!paintTop && paintTopLine) {
                    int x1 = bounds.x + (actualPaintLeft ? shadowWidth : 0);
                    int x2 = bounds.x + bounds.width - (actualPaintRight ? shadowWidth : 0) - 1;
                    g2d.drawLine(x1, bounds.y, x2, bounds.y);
                }
                if (!paintBottom && paintBottomLine) {
                    int y = bounds.y + bounds.height - 1;
                    int x1 = bounds.x + (actualPaintLeft ? shadowWidth : 0);
                    int x2 = bounds.x + bounds.width - (actualPaintRight ? shadowWidth : 0) - 1;
                    g2d.drawLine(x1, y, x2, y);
                }
                if (!actualPaintLeft && actualPaintLeftLine) {
                    int y1 = bounds.y + (paintTop ? shadowWidth : 0);
                    int y2 = bounds.y + bounds.height - (paintBottom ? shadowWidth : 0) - 1;
                    g2d.drawLine(bounds.x, y1, bounds.x, y2);
                }
                if (!actualPaintRight && actualPaintRightLine) {
                    int x = bounds.x + bounds.width - 1;
                    int y1 = bounds.y + (paintTop ? shadowWidth : 0);
                    int y2 = bounds.y + bounds.height - (paintBottom ? shadowWidth : 0) - 1;
                    g2d.drawLine(x, y1, x, y2);
                }
                GraphicsUtils.restorePaint(g2d, op, bc != null);
                GraphicsUtils.restoreStroke(g2d, os, stroke != null);
            }
        }
    }
}

