/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.background;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.painter.decoration.DecorationException;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.background.AbstractBackground;
import com.alee.painter.decoration.background.IBackground;
import com.alee.utils.CollectionUtils;
import com.alee.utils.GraphicsUtils;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.List;
import javax.swing.JComponent;

public abstract class AbstractClipBackground<C extends JComponent, D extends IDecoration<C, D>, I extends AbstractClipBackground<C, D, I>>
extends AbstractBackground<C, D, I> {
    @XStreamImplicit
    @Nullable
    private List<IBackground> backgrounds;

    @NotNull
    protected List<IBackground> backgrounds() {
        if (CollectionUtils.isEmpty(this.backgrounds)) {
            throw new DecorationException("At least one background implementation must be specified");
        }
        return this.backgrounds;
    }

    @Override
    public void activate(@NotNull C c, @NotNull D d) {
        for (IBackground background : this.backgrounds()) {
            background.activate(c, d);
        }
    }

    @Override
    public void deactivate(@NotNull C c, @NotNull D d) {
        for (IBackground background : this.backgrounds()) {
            background.deactivate(c, d);
        }
    }

    @Override
    public void paint(@NotNull Graphics2D g2d, @NotNull Rectangle bounds, @NotNull C c, @NotNull D d, @NotNull Shape shape) {
        float opacity = this.getOpacity(c, d);
        if (opacity > 0.0f) {
            Composite oc = GraphicsUtils.setupAlphaComposite(g2d, Float.valueOf(opacity), opacity < 1.0f);
            Shape clipped = this.clip(g2d, bounds, c, d, shape);
            for (IBackground background : this.backgrounds()) {
                background.paint(g2d, bounds, c, d, clipped);
            }
            GraphicsUtils.restoreComposite(g2d, oc, opacity < 1.0f);
        }
    }

    @NotNull
    protected abstract Shape clip(@NotNull Graphics2D var1, @NotNull Rectangle var2, @NotNull C var3, @NotNull D var4, @NotNull Shape var5);
}

