/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.background;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.painter.decoration.DecorationException;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.background.AbstractTextureBackground;
import com.alee.utils.ImageUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

@XStreamAlias(value="AlphaLayerBackground")
public class AlphaLayerBackground<C extends JComponent, D extends IDecoration<C, D>, I extends AlphaLayerBackground<C, D, I>>
extends AbstractTextureBackground<C, D, I> {
    public static final Dimension DEFAULT_CELL_SIZE = new Dimension(10, 10);
    public static final Color DEFAULT_DARK_COLOR = new Color(204, 204, 204);
    public static final Color DEFAULT_LIGHT_COLOR = Color.WHITE;
    @XStreamAsAttribute
    @Nullable
    protected Dimension size;
    @XStreamAsAttribute
    @Nullable
    protected Color darkColor;
    @XStreamAsAttribute
    @Nullable
    protected Color lightColor;

    @NotNull
    protected Dimension getSize(@NotNull C c, @NotNull D d) {
        Dimension size;
        Dimension dimension = size = this.size != null ? this.size : DEFAULT_CELL_SIZE;
        if (size.width <= 0 || size.height <= 0) {
            throw new DecorationException("Cell size must be greater than zero");
        }
        return size;
    }

    @NotNull
    protected Color getDarkColor(@NotNull C c, @NotNull D d) {
        return this.darkColor != null ? this.darkColor : DEFAULT_DARK_COLOR;
    }

    @NotNull
    protected Color getLightColor(@NotNull C c, @NotNull D d) {
        return this.lightColor != null ? this.lightColor : DEFAULT_LIGHT_COLOR;
    }

    @Override
    @NotNull
    protected TexturePaint createTexturePaint(@NotNull Rectangle bounds, @NotNull C c, @NotNull D d) {
        BufferedImage image = this.createTextureImage(c, d);
        Rectangle anchor = new Rectangle(bounds.x, bounds.y, image.getWidth(), image.getHeight());
        return new TexturePaint(image, anchor);
    }

    @NotNull
    protected BufferedImage createTextureImage(@NotNull C c, @NotNull D d) {
        return AlphaLayerBackground.createAlphaBackgroundTexture(this.getSize(c, d), this.getDarkColor(c, d), this.getLightColor(c, d));
    }

    @NotNull
    public static BufferedImage createAlphaBackgroundTexture() {
        return AlphaLayerBackground.createAlphaBackgroundTexture(DEFAULT_CELL_SIZE, DEFAULT_DARK_COLOR, DEFAULT_LIGHT_COLOR);
    }

    @NotNull
    public static BufferedImage createAlphaBackgroundTexture(@NotNull Dimension size) {
        return AlphaLayerBackground.createAlphaBackgroundTexture(size, DEFAULT_DARK_COLOR, DEFAULT_LIGHT_COLOR);
    }

    @NotNull
    public static BufferedImage createAlphaBackgroundTexture(@NotNull Dimension size, @NotNull Color darkColor, @NotNull Color lightColor) {
        BufferedImage image = ImageUtils.createCompatibleImage(size.width * 2, size.height * 2, 1);
        Graphics2D g2d = image.createGraphics();
        g2d.setPaint(darkColor);
        g2d.fillRect(0, 0, size.width, size.height);
        g2d.fillRect(size.width, size.height, size.width, size.height);
        g2d.setPaint(lightColor);
        g2d.fillRect(size.width, 0, size.width, size.height);
        g2d.fillRect(0, size.height, size.width, size.height);
        g2d.dispose();
        return image;
    }
}

