/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.background;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.managers.icon.IconManager;
import com.alee.painter.decoration.DecorationException;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.background.AbstractImageTextureBackground;
import com.alee.utils.ImageUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

@XStreamAlias(value="ImageTextureBackground")
public class ImageTextureBackground<C extends JComponent, D extends IDecoration<C, D>, I extends ImageTextureBackground<C, D, I>>
extends AbstractImageTextureBackground<C, D, I> {
    @XStreamAsAttribute
    @Nullable
    protected String iconId;

    @NotNull
    protected String getIconId(@NotNull C c, @NotNull D d) {
        if (this.iconId == null) {
            throw new DecorationException("Texture icon identifier must be specified");
        }
        if (!IconManager.hasIcon(this.iconId)) {
            throw new DecorationException("Texture icon doesn't exist");
        }
        return this.iconId;
    }

    @Override
    @NotNull
    protected BufferedImage createTextureImage(@NotNull C c, @NotNull D d) {
        return ImageUtils.toNonNullBufferedImage(IconManager.getIcon(this.getIconId(c, d)));
    }
}

