/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.background;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.clone.behavior.OmitOnClone;
import com.alee.api.data.Orientation;
import com.alee.api.merge.behavior.OmitOnMerge;
import com.alee.extended.behavior.VisibilityBehavior;
import com.alee.managers.animation.transition.IdleTransition;
import com.alee.managers.animation.transition.QueueTransition;
import com.alee.managers.animation.transition.TimedTransition;
import com.alee.managers.animation.transition.Transition;
import com.alee.managers.animation.transition.TransitionAdapter;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.background.AbstractBackground;
import com.alee.utils.ColorUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.parsing.DurationUnits;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JComponent;

@XStreamAlias(value="MovingHighlightBackground")
public class MovingHighlightBackground<C extends JComponent, D extends IDecoration<C, D>, I extends MovingHighlightBackground<C, D, I>>
extends AbstractBackground<C, D, I> {
    @XStreamAsAttribute
    @Nullable
    protected Orientation orientation;
    @XStreamAsAttribute
    @Nullable
    protected Integer width;
    @XStreamAsAttribute
    @Nullable
    protected Color color;
    @XStreamAsAttribute
    @Nullable
    protected Integer passes;
    @XStreamAsAttribute
    @Nullable
    protected String duration;
    @XStreamAsAttribute
    @Nullable
    protected String delay;
    @OmitOnClone
    @OmitOnMerge
    protected transient VisibilityBehavior<C> visibilityBehavior;
    @OmitOnClone
    @OmitOnMerge
    protected transient float position;
    @OmitOnClone
    @OmitOnMerge
    @Nullable
    protected transient QueueTransition transitionsQueue;

    @Override
    public void activate(@NotNull C c, @NotNull D d) {
        this.visibilityBehavior = new VisibilityBehavior<C>((JComponent)c, true){

            @Override
            protected void displayed(@NotNull C component2) {
                MovingHighlightBackground.this.playAnimation((JComponent)this.getComponent());
            }

            @Override
            protected void hidden(@NotNull C component2) {
                MovingHighlightBackground.this.stopAnimation((JComponent)this.getComponent());
            }
        };
        this.visibilityBehavior.install();
    }

    @Override
    public void deactivate(@NotNull C c, @NotNull D d) {
        this.visibilityBehavior.uninstall();
        this.visibilityBehavior = null;
        this.stopAnimation(c);
    }

    @Nullable
    public Orientation getOrientation() {
        return this.orientation;
    }

    @Nullable
    public Integer getWidth() {
        return this.width;
    }

    @Nullable
    public Color getColor() {
        return this.color;
    }

    @Nullable
    protected Integer getPasses() {
        return this.passes;
    }

    @Nullable
    protected Long getDelay() {
        return this.delay != null ? Long.valueOf(DurationUnits.get().fromString(this.delay)) : null;
    }

    @Nullable
    protected Long getDuration() {
        return this.duration != null ? Long.valueOf(DurationUnits.get().fromString(this.duration)) : null;
    }

    protected void playAnimation(final @NotNull C c) {
        if (this.transitionsQueue == null) {
            Orientation orientation = this.getOrientation();
            Integer width = this.getWidth();
            Color color = this.getColor();
            Integer passes = this.getPasses();
            Long duration = this.getDuration();
            if (orientation != null && width != null && color != null && passes != null && duration != null) {
                this.position = 0.0f;
                this.transitionsQueue = new QueueTransition(true, new Transition[0]);
                Long delay = this.getDelay();
                if (delay != null && delay > 0L) {
                    this.transitionsQueue.add(new IdleTransition<Float>(Float.valueOf(passes % 2 == 0 ? 0.0f : 1.0f), delay));
                }
                for (int i = 0; i < passes; ++i) {
                    float from = i % 2 == 0 ? 0.0f : 1.0f;
                    float to = i % 2 == 0 ? 1.0f : 0.0f;
                    this.transitionsQueue.add(new TimedTransition<Float>(Float.valueOf(from), Float.valueOf(to), duration));
                }
                this.transitionsQueue.addListener(new TransitionAdapter<Float>(){

                    @Override
                    public void adjusted(Transition transition, Float value) {
                        MovingHighlightBackground.this.position = value.floatValue();
                        c.repaint();
                    }
                });
                this.transitionsQueue.play();
            }
        }
    }

    protected void stopAnimation(@NotNull C c) {
        if (this.transitionsQueue != null) {
            this.transitionsQueue.stop();
            this.transitionsQueue = null;
            this.position = 0.0f;
        }
    }

    @Override
    public void paint(@NotNull Graphics2D g2d, @NotNull Rectangle bounds, @NotNull C c, @NotNull D d, @NotNull Shape shape) {
        float opacity = this.getOpacity(c, d);
        if (opacity > 0.0f) {
            Orientation orientation = this.getOrientation();
            Integer width = this.getWidth();
            Color color = this.getColor();
            if (orientation != null && width != null && color != null) {
                Rectangle b = shape.getBounds();
                RadialGradientPaint paint = orientation.isHorizontal() ? (((Component)c).getComponentOrientation().isLeftToRight() ? new RadialGradientPaint((float)(b.x - width / 2) + (float)(b.width + width) * this.position, (float)(b.y + b.height / 2), width / 2, new float[]{0.0f, 1.0f}, new Color[]{color, ColorUtils.transparent()}) : new RadialGradientPaint((float)(b.x + b.width + width / 2) - (float)(b.width + width) * this.position, (float)(b.y + b.height / 2), width / 2, new float[]{0.0f, 1.0f}, new Color[]{color, ColorUtils.transparent()})) : (((Component)c).getComponentOrientation().isLeftToRight() ? new RadialGradientPaint(b.x + b.width / 2, (float)(b.y + b.height + width / 2) - (float)(b.height + width) * this.position, width / 2, new float[]{0.0f, 1.0f}, new Color[]{color, ColorUtils.transparent()}) : new RadialGradientPaint(b.x + b.width / 2, (float)(b.y - width / 2) + (float)(b.height + width) * this.position, width / 2, new float[]{0.0f, 1.0f}, new Color[]{color, ColorUtils.transparent()}));
                Shape ocl = GraphicsUtils.intersectClip(g2d, shape);
                Composite oc = GraphicsUtils.setupAlphaComposite(g2d, Float.valueOf(opacity), opacity < 1.0f);
                Paint op = GraphicsUtils.setupPaint(g2d, paint);
                g2d.fillRect(b.x, b.y, b.width, b.height);
                GraphicsUtils.restorePaint(g2d, op);
                GraphicsUtils.restoreComposite(g2d, oc, opacity < 1.0f);
                GraphicsUtils.restoreClip(g2d, ocl);
            }
        }
    }
}

