/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.content;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.data.BoxOrientation;
import com.alee.api.data.Orientation;
import com.alee.api.merge.behavior.OverwriteOnMerge;
import com.alee.painter.decoration.DecorationException;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.content.AbstractContent;
import com.alee.painter.decoration.content.Stripe;
import com.alee.utils.GraphicsUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.List;
import javax.swing.JComponent;

@XStreamAlias(value="Stripes")
public class Stripes<C extends JComponent, D extends IDecoration<C, D>, I extends Stripes<C, D, I>>
extends AbstractContent<C, D, I> {
    @XStreamAsAttribute
    @Nullable
    protected Orientation orientation;
    @XStreamAsAttribute
    @Nullable
    protected BoxOrientation align;
    @XStreamImplicit
    @OverwriteOnMerge
    @Nullable
    protected List<Stripe> stripes;

    @Override
    @NotNull
    public String getId() {
        return this.id != null ? this.id : "stripes";
    }

    @NotNull
    protected Orientation getOrientation(@NotNull C c, @NotNull D d) {
        if (this.orientation == null) {
            throw new DecorationException("Stripe orientation must be specified");
        }
        return this.orientation;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    protected BoxOrientation getAlign(@NotNull C c, @NotNull D d) {
        if (this.align == null) return BoxOrientation.center;
        if (this.getOrientation(c, d).isVertical()) {
            if (this.align.isLeft()) return this.align;
            if (this.align.isCenter()) return this.align;
            if (!this.align.isRight()) throw new DecorationException("Vertical stripe cannot use " + this.align + " alignment");
            return this.align;
        }
        if (this.align.isTop()) return this.align;
        if (this.align.isCenter()) return this.align;
        if (!this.align.isBottom()) throw new DecorationException("Horizontal stripe cannot use " + this.align + " alignment");
        return this.align;
    }

    protected int getStripesCount() {
        return this.stripes != null ? this.stripes.size() : 0;
    }

    @Override
    public boolean isEmpty(@NotNull C c, @NotNull D d) {
        return this.getStripesCount() == 0;
    }

    @Override
    protected void paintContent(@NotNull Graphics2D g2d, @NotNull C c, @NotNull D d, @NotNull Rectangle bounds) {
        if (this.stripes != null) {
            boolean ltr = this.isLeftToRight(c, d);
            Orientation orientation = this.getOrientation(c, d);
            BoxOrientation align = this.getAlign(c, d);
            for (int i = 0; i < this.stripes.size(); ++i) {
                int y2;
                int y1;
                int x1;
                int x2;
                Stripe stripe = this.stripes.get(i);
                if (orientation.isVertical()) {
                    x1 = (ltr ? align.isLeft() : align.isRight()) ? (x2 = bounds.x + i) : ((!ltr ? align.isLeft() : align.isRight()) ? (x2 = bounds.x + bounds.width - i - 1) : (x2 = bounds.x + (bounds.width - this.stripes.size()) / 2 + i));
                    y1 = bounds.y;
                    y2 = bounds.y + bounds.height - 1;
                } else {
                    y1 = align.isTop() ? (y2 = bounds.y + i) : (align.isBottom() ? (y2 = bounds.y + bounds.height - this.stripes.size() + i) : (y2 = bounds.y + (bounds.height - this.stripes.size()) / 2 + i));
                    x1 = bounds.x;
                    x2 = bounds.x + bounds.width - 1;
                }
                Stroke stroke = GraphicsUtils.setupStroke(g2d, stripe.getStroke(), stripe.getStroke() != null);
                Paint op = GraphicsUtils.setupPaint(g2d, stripe.getPaint(x1, y1, x2, y2));
                g2d.drawLine(x1, y1, x2, y2);
                GraphicsUtils.restorePaint(g2d, op);
                GraphicsUtils.restoreStroke(g2d, stroke, stripe.getStroke() != null);
            }
        }
    }

    @Override
    @NotNull
    protected Dimension getContentPreferredSize(@NotNull C c, @NotNull D d, @NotNull Dimension available) {
        int stripes = this.getStripesCount();
        Orientation orientation = this.getOrientation(c, d);
        return new Dimension(orientation.isVertical() ? stripes : 0, orientation.isVertical() ? 0 : stripes);
    }
}

