/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.layout;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.content.AbstractContent;
import com.alee.painter.decoration.content.IContent;
import com.alee.painter.decoration.layout.ContentLayoutData;
import com.alee.painter.decoration.layout.IContentLayout;
import com.alee.utils.CollectionUtils;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;

public abstract class AbstractContentLayout<C extends JComponent, D extends IDecoration<C, D>, I extends AbstractContentLayout<C, D, I>>
extends AbstractContent<C, D, I>
implements IContentLayout<C, D, I> {
    @XStreamImplicit
    @Nullable
    protected List<IContent> contents;
    @Nullable
    protected transient Map<String, List<IContent>> contentsCache;

    @Override
    @NotNull
    public String getId() {
        return this.id != null ? this.id : "layout";
    }

    @Override
    public void activate(@NotNull C c, @NotNull D d) {
        super.activate(c, d);
        for (IContent content : this.getContents(c, d)) {
            content.activate(c, d);
        }
    }

    @Override
    public void deactivate(@NotNull C c, @NotNull D d) {
        super.deactivate(c, d);
        for (IContent content : this.getContents(c, d)) {
            content.deactivate(c, d);
        }
    }

    @Override
    public boolean isEmpty(@NotNull C c, @NotNull D d) {
        boolean isEmpty = true;
        for (IContent content : this.getContents(c, d)) {
            if (content.isEmpty(c, d)) continue;
            isEmpty = false;
            break;
        }
        return isEmpty;
    }

    public boolean isEmpty(@NotNull C c, @NotNull D d, @Nullable String constraints) {
        boolean isEmpty = true;
        for (IContent content : this.getContents(c, d, constraints)) {
            if (content.isEmpty(c, d)) continue;
            isEmpty = false;
            break;
        }
        return isEmpty;
    }

    @Override
    @NotNull
    public List<IContent> getContents(@NotNull C c, @NotNull D d) {
        return CollectionUtils.notEmpty(this.contents) ? this.contents : Collections.emptyList();
    }

    @NotNull
    protected List<IContent> getContents(@NotNull C c, @NotNull D d, @Nullable String constraints) {
        Map<String, List<IContent>> contentsCache;
        List<IContent> cached;
        List contents = CollectionUtils.notEmpty(this.contents) ? (CollectionUtils.notEmpty(cached = (contentsCache = this.getContentsCache(c, d)).get(constraints)) ? cached : Collections.emptyList()) : Collections.emptyList();
        return contents;
    }

    @NotNull
    protected Map<String, List<IContent>> getContentsCache(@NotNull C c, @NotNull D d) {
        if (this.contentsCache == null) {
            List<IContent> contents = this.getContents(c, d);
            this.contentsCache = new HashMap<String, List<IContent>>(contents.size());
            for (IContent content : contents) {
                String cst = content.getConstraints();
                List<IContent> existing = this.contentsCache.get(cst);
                if (existing == null) {
                    existing = new ArrayList<IContent>(1);
                    this.contentsCache.put(cst, existing);
                }
                existing.add(content);
            }
        }
        return this.contentsCache;
    }

    @Override
    public boolean hasContentBaseline(@NotNull C c, @NotNull D d) {
        boolean hasContentBaseline = false;
        for (IContent content : this.getContents(c, d)) {
            if (content.isEmpty(c, d) || !content.hasBaseline(c, d)) continue;
            hasContentBaseline = true;
            break;
        }
        return hasContentBaseline;
    }

    @Override
    public int getContentBaseline(@NotNull C c, @NotNull D d, @NotNull Rectangle bounds) {
        int contentBaseline = -1;
        for (IContent content : this.getContents(c, d)) {
            if (content.isEmpty(c, d) || !content.hasBaseline(c, d)) continue;
            ContentLayoutData layoutData = this.layoutContent(c, d, bounds);
            Rectangle b = (Rectangle)layoutData.get(content.getConstraints());
            contentBaseline = content.getBaseline(c, d, b);
            break;
        }
        return contentBaseline;
    }

    @Override
    @NotNull
    public Component.BaselineResizeBehavior getContentBaselineResizeBehavior(@NotNull C c, @NotNull D d) {
        return Component.BaselineResizeBehavior.OTHER;
    }

    @Override
    protected void paintContent(@NotNull Graphics2D g2d, @NotNull C c, @NotNull D d, @NotNull Rectangle bounds) {
        if (!this.isEmpty(c, d)) {
            ContentLayoutData layoutData = this.layoutContent(c, d, bounds);
            for (String constraints : layoutData.keySet()) {
                Rectangle b = (Rectangle)layoutData.get(constraints);
                for (IContent content : this.getContents(c, d, constraints)) {
                    if (content.isEmpty(c, d)) continue;
                    content.paint(g2d, c, d, b);
                }
            }
        }
    }

    @NotNull
    protected Dimension getPreferredSize(@NotNull C c, @NotNull D d, @NotNull Dimension available, @Nullable String constraints) {
        Dimension ps = new Dimension(0, 0);
        for (IContent content : this.getContents(c, d, constraints)) {
            if (content.isEmpty(c, d)) continue;
            Dimension size = content.getPreferredSize(c, d, new Dimension(available));
            ps.width = Math.max(ps.width, size.width);
            ps.height = Math.max(ps.height, size.height);
        }
        return ps;
    }
}

