/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.layout;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.content.IContent;
import com.alee.painter.decoration.layout.AbstractContentLayout;
import com.alee.painter.decoration.layout.ContentLayoutData;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;

@XStreamAlias(value="BorderLayout")
public class BorderLayout<C extends JComponent, D extends IDecoration<C, D>, I extends BorderLayout<C, D, I>>
extends AbstractContentLayout<C, D, I> {
    protected static final String NORTH = "north";
    protected static final String SOUTH = "south";
    protected static final String WEST = "west";
    protected static final String EAST = "east";
    protected static final String CENTER = "center";
    @XStreamAsAttribute
    @Nullable
    protected Integer hgap;
    @XStreamAsAttribute
    @Nullable
    protected Integer vgap;

    protected int getHorizontalGap(@NotNull C c, @NotNull D d) {
        return this.hgap != null ? this.hgap : 0;
    }

    protected int getVerticalGap(@NotNull C c, @NotNull D d) {
        return this.vgap != null ? this.vgap : 0;
    }

    @Override
    @NotNull
    public List<IContent> getContents(@NotNull C c, @NotNull D d, @Nullable String constraints) {
        boolean ltr = this.isLeftToRight(c, d);
        if (!ltr) {
            if (Objects.equals((Object)constraints, (Object)WEST)) {
                constraints = EAST;
            } else if (Objects.equals((Object)constraints, (Object)EAST)) {
                constraints = WEST;
            }
        }
        return super.getContents(c, d, constraints);
    }

    @Override
    @NotNull
    public ContentLayoutData layoutContent(@NotNull C c, @NotNull D d, @NotNull Rectangle bounds) {
        Dimension ps;
        ContentLayoutData layoutData = new ContentLayoutData(5);
        int hgap = this.getHorizontalGap(c, d);
        int vgap = this.getVerticalGap(c, d);
        int x = bounds.x;
        int y = bounds.y;
        int width = bounds.width;
        int height = bounds.height;
        if (!this.isEmpty(c, d, NORTH)) {
            ps = this.getPreferredSize(c, d, new Dimension(width, height), NORTH);
            layoutData.put(NORTH, new Rectangle(x, y, width, ps.height));
            y += ps.height + vgap;
            height -= ps.height + vgap;
        }
        if (!this.isEmpty(c, d, SOUTH)) {
            ps = this.getPreferredSize(c, d, new Dimension(width, height), SOUTH);
            layoutData.put(SOUTH, new Rectangle(x, y + height - ps.height, width, ps.height));
            height -= ps.height + vgap;
        }
        if (!this.isEmpty(c, d, EAST)) {
            ps = this.getPreferredSize(c, d, new Dimension(width, height), EAST);
            layoutData.put(EAST, new Rectangle(x + width - ps.width, y, ps.width, height));
            width -= ps.width + hgap;
        }
        if (!this.isEmpty(c, d, WEST)) {
            ps = this.getPreferredSize(c, d, new Dimension(width, height), WEST);
            layoutData.put(WEST, new Rectangle(x, y, ps.width, height));
            x += ps.width + hgap;
            width -= ps.width + hgap;
        }
        if (!this.isEmpty(c, d, CENTER)) {
            layoutData.put(CENTER, new Rectangle(x, y, width, height));
        }
        return layoutData;
    }

    @Override
    @NotNull
    protected Dimension getContentPreferredSize(@NotNull C c, @NotNull D d, @NotNull Dimension available) {
        Dimension cps;
        Dimension cps2;
        int hgap = this.getHorizontalGap(c, d);
        int vgap = this.getVerticalGap(c, d);
        Dimension ps = new Dimension(0, 0);
        if (!this.isEmpty(c, d, NORTH)) {
            cps2 = this.getPreferredSize(c, d, available, NORTH);
            ps.width = Math.max(ps.width, cps2.width);
            ps.height += cps2.height + vgap;
            available.height -= ps.height + vgap;
        }
        if (!this.isEmpty(c, d, SOUTH)) {
            cps2 = this.getPreferredSize(c, d, available, SOUTH);
            ps.width = Math.max(ps.width, cps2.width);
            ps.height += cps2.height + vgap;
            available.height -= ps.height + vgap;
        }
        int centerWidth = 0;
        int centerHeight = 0;
        if (!this.isEmpty(c, d, EAST)) {
            cps = this.getPreferredSize(c, d, available, EAST);
            centerWidth += cps.width + hgap;
            centerHeight = Math.max(centerHeight, cps.height);
            available.width -= ps.width + hgap;
        }
        if (!this.isEmpty(c, d, WEST)) {
            cps = this.getPreferredSize(c, d, available, WEST);
            centerWidth += cps.width + hgap;
            centerHeight = Math.max(centerHeight, cps.height);
            available.width -= ps.width + hgap;
        }
        if (!this.isEmpty(c, d, CENTER)) {
            cps = this.getPreferredSize(c, d, available, CENTER);
            centerWidth += cps.width;
            centerHeight = Math.max(centerHeight, cps.height);
        }
        ps.width = Math.max(ps.width, centerWidth);
        ps.height += centerHeight;
        return ps;
    }
}

