/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.layout;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.data.BoxOrientation;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.layout.AbstractContentLayout;
import com.alee.painter.decoration.layout.ContentLayoutData;
import com.alee.utils.MathUtils;
import com.alee.utils.SwingUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.SwingConstants;

@XStreamAlias(value="IconTextLayout")
public class IconTextLayout<C extends JComponent, D extends IDecoration<C, D>, I extends IconTextLayout<C, D, I>>
extends AbstractContentLayout<C, D, I>
implements SwingConstants {
    protected static final String ICON = "icon";
    protected static final String TEXT = "text";
    protected static final String TOP_SPACE = "top-space";
    protected static final String LEFT_SPACE = "left-space";
    protected static final String RIGHT_SPACE = "right-space";
    protected static final String BOTTOM_SPACE = "bottom-space";
    @XStreamAsAttribute
    @Nullable
    protected Integer gap;
    @XStreamAsAttribute
    @Nullable
    protected BoxOrientation halign;
    @XStreamAsAttribute
    @Nullable
    protected BoxOrientation valign;
    @XStreamAsAttribute
    @Nullable
    protected BoxOrientation hpos;
    @XStreamAsAttribute
    @Nullable
    protected BoxOrientation vpos;

    protected int getIconTextGap(@NotNull C c, @NotNull D d) {
        return this.gap != null ? this.gap : 0;
    }

    protected int getHorizontalAlignment(@NotNull C c, @NotNull D d) {
        return this.halign != null ? this.halign.getValue() : 0;
    }

    protected int getVerticalAlignment(@NotNull C c, @NotNull D d) {
        return this.valign != null ? this.valign.getValue() : 0;
    }

    protected int getHorizontalTextPosition(@NotNull C c, @NotNull D d) {
        return this.hpos != null ? this.hpos.getValue() : 11;
    }

    protected int getVerticalTextPosition(@NotNull C c, @NotNull D d) {
        return this.vpos != null ? this.vpos.getValue() : 0;
    }

    @Override
    @NotNull
    public ContentLayoutData layoutContent(@NotNull C c, @NotNull D d, @NotNull Rectangle bounds) {
        boolean hasText;
        ContentLayoutData layoutData = new ContentLayoutData(2);
        Dimension available = bounds.getSize();
        boolean ltr = this.isLeftToRight(c, d);
        int halign = this.getHorizontalAlignment(c, d);
        int valign = this.getVerticalAlignment(c, d);
        Dimension top = this.getPreferredSize(c, d, available, TOP_SPACE);
        Dimension left = this.getPreferredSize(c, d, available, LEFT_SPACE);
        Dimension right = this.getPreferredSize(c, d, available, RIGHT_SPACE);
        Dimension bottom = this.getPreferredSize(c, d, available, BOTTOM_SPACE);
        int lw = halign == 0 ? Math.max(left.width, right.width) : left.width;
        int rw = halign == 0 ? Math.max(left.width, right.width) : right.width;
        int th = valign == 0 ? Math.max(top.height, bottom.height) : top.height;
        int bh = valign == 0 ? Math.max(top.height, bottom.height) : bottom.height;
        Dimension iconTextAvailable = new Dimension(available.width - lw - rw, available.height - th - bh);
        Dimension iconTextPS = this.getIconTextPreferredSize(c, d, iconTextAvailable);
        iconTextPS.width = Math.max(0, Math.min(iconTextPS.width, bounds.width - lw - rw));
        iconTextPS.height = Math.max(0, Math.min(iconTextPS.height, bounds.height - th - bh));
        Rectangle b = new Rectangle(0, 0, iconTextPS.width, iconTextPS.height);
        b.x = halign == 2 || halign == 10 && ltr || halign == 11 && !ltr ? bounds.x + lw : (halign == 0 ? bounds.x + bounds.width / 2 - iconTextPS.width / 2 : bounds.x + bounds.width - iconTextPS.width - rw);
        b.y = valign == 1 ? bounds.y + th : (valign == 0 ? bounds.y + bounds.height / 2 - iconTextPS.height / 2 : bounds.y + bounds.height - iconTextPS.height - bh);
        if (!this.isEmpty(c, d, TOP_SPACE)) {
            layoutData.put(TOP_SPACE, new Rectangle(bounds.x, bounds.y, bounds.width, b.y - bounds.y));
        }
        if (!this.isEmpty(c, d, LEFT_SPACE)) {
            layoutData.put(LEFT_SPACE, new Rectangle(bounds.x, b.y, b.x - bounds.x, b.height));
        }
        if (!this.isEmpty(c, d, RIGHT_SPACE)) {
            layoutData.put(RIGHT_SPACE, new Rectangle(b.x + b.width, b.y, bounds.x + bounds.width - b.x - b.width, b.height));
        }
        if (!this.isEmpty(c, d, BOTTOM_SPACE)) {
            layoutData.put(BOTTOM_SPACE, new Rectangle(bounds.x, b.y + b.height, bounds.width, bounds.y + bounds.height - b.y - b.height));
        }
        boolean hasIcon = !this.isEmpty(c, d, ICON);
        boolean bl = hasText = !this.isEmpty(c, d, TEXT);
        if (hasIcon && hasText) {
            int hpos = this.getHorizontalTextPosition(c, d);
            int vpos = this.getVerticalTextPosition(c, d);
            if (hpos != 0 || vpos != 0) {
                Dimension ips = this.getPreferredSize(c, d, available, ICON);
                int gap = this.getIconTextGap(c, d);
                if (hpos == 4 || hpos == 11 && ltr) {
                    layoutData.put(ICON, new Rectangle(b.x, b.y, ips.width, b.height));
                    layoutData.put(TEXT, new Rectangle(b.x + gap + ips.width, b.y, b.width - ips.width - gap, b.height));
                } else if (hpos == 0) {
                    if (vpos == 1) {
                        layoutData.put(ICON, new Rectangle(b.x, b.y + b.height - ips.height, b.width, ips.height));
                        layoutData.put(TEXT, new Rectangle(b.x, b.y, b.width, b.height - gap - ips.height));
                    } else {
                        layoutData.put(ICON, new Rectangle(b.x, b.y, b.width, ips.height));
                        layoutData.put(TEXT, new Rectangle(b.x, b.y + ips.height + gap, b.width, b.height - ips.height - gap));
                    }
                } else {
                    layoutData.put(ICON, new Rectangle(b.x + b.width - ips.width, b.y, ips.width, b.height));
                    layoutData.put(TEXT, new Rectangle(b.x, b.y, b.width - ips.width - gap, b.height));
                }
            } else {
                layoutData.put(ICON, b);
                layoutData.put(TEXT, b);
            }
        } else if (hasIcon) {
            layoutData.put(ICON, b);
        } else if (hasText) {
            layoutData.put(TEXT, b);
        }
        return layoutData;
    }

    @Override
    @NotNull
    protected Dimension getContentPreferredSize(@NotNull C c, @NotNull D d, @NotNull Dimension available) {
        int halign = this.getHorizontalAlignment(c, d);
        int valign = this.getVerticalAlignment(c, d);
        Dimension top = this.getPreferredSize(c, d, available, TOP_SPACE);
        Dimension left = this.getPreferredSize(c, d, available, LEFT_SPACE);
        Dimension right = this.getPreferredSize(c, d, available, RIGHT_SPACE);
        Dimension bottom = this.getPreferredSize(c, d, available, BOTTOM_SPACE);
        int lw = halign == 0 ? Math.max(left.width, right.width) : left.width;
        int rw = halign == 0 ? Math.max(left.width, right.width) : right.width;
        int th = valign == 0 ? Math.max(top.height, bottom.height) : top.height;
        int bh = valign == 0 ? Math.max(top.height, bottom.height) : bottom.height;
        Dimension iconTextAvailable = new Dimension(available.width - lw - rw, available.height - th - bh);
        Dimension iconText = this.getIconTextPreferredSize(c, d, iconTextAvailable);
        int pw = MathUtils.max(top.width, lw + iconText.width + rw, bottom.width);
        int ph = th + MathUtils.max(left.height, iconText.height, right.height) + bh;
        return new Dimension(pw, ph);
    }

    @NotNull
    protected Dimension getIconTextPreferredSize(@NotNull C c, @NotNull D d, @NotNull Dimension available) {
        Dimension size;
        boolean hasText;
        boolean hasIcon = !this.isEmpty(c, d, ICON);
        boolean bl = hasText = !this.isEmpty(c, d, TEXT);
        if (hasIcon && hasText) {
            int hpos = this.getHorizontalTextPosition(c, d);
            int vpos = this.getVerticalTextPosition(c, d);
            Dimension ips = this.getPreferredSize(c, d, available, ICON);
            if (hpos != 0 || vpos != 0) {
                int gap = this.getIconTextGap(c, d);
                if (hpos == 2 || hpos == 10 || hpos == 4 || hpos == 11) {
                    Dimension havailable = new Dimension(available.width - gap - ips.width, available.height);
                    Dimension cps = this.getPreferredSize(c, d, havailable, TEXT);
                    size = new Dimension(ips.width + gap + cps.width, Math.max(ips.height, cps.height));
                } else {
                    Dimension vavailable = new Dimension(available.width, available.height - gap - ips.height);
                    Dimension cps = this.getPreferredSize(c, d, vavailable, TEXT);
                    size = new Dimension(Math.max(ips.width, cps.width), ips.height + gap + cps.height);
                }
            } else {
                size = SwingUtils.max(ips, this.getPreferredSize(c, d, available, TEXT));
            }
        } else {
            size = hasIcon ? this.getPreferredSize(c, d, available, ICON) : (hasText ? this.getPreferredSize(c, d, available, TEXT) : new Dimension(0, 0));
        }
        return size;
    }
}

