/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.layout;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.painter.decoration.IDecoration;
import com.alee.painter.decoration.content.IContent;
import com.alee.painter.decoration.layout.AbstractContentLayout;
import com.alee.painter.decoration.layout.ContentLayoutData;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;

@XStreamAlias(value="OverflowLineLayout")
public class OverflowLineLayout<C extends JComponent, D extends IDecoration<C, D>, I extends OverflowLineLayout<C, D, I>>
extends AbstractContentLayout<C, D, I> {
    protected static final String LEADING = "leading";
    protected static final String OVERFLOW = "overflow";
    protected static final String TRAILING = "trailing";
    @XStreamAsAttribute
    @Nullable
    protected Integer gap;

    protected int getGap() {
        return this.gap != null ? this.gap : 0;
    }

    @Override
    @NotNull
    public List<IContent> getContents(@NotNull C c, @NotNull D d, @Nullable String constraints) {
        boolean ltr = this.isLeftToRight(c, d);
        if (!ltr) {
            if (Objects.equals((Object)constraints, (Object)LEADING)) {
                constraints = TRAILING;
            } else if (Objects.equals((Object)constraints, (Object)TRAILING)) {
                constraints = LEADING;
            }
        }
        return super.getContents(c, d, constraints);
    }

    @Override
    @NotNull
    public ContentLayoutData layoutContent(@NotNull C c, @NotNull D d, @NotNull Rectangle bounds) {
        ContentLayoutData layoutData = new ContentLayoutData(5);
        boolean ltr = this.isLeftToRight(c, d);
        int gap = this.getGap();
        Dimension lps = this.getPreferredSize(c, d, new Dimension(bounds.width, bounds.height), LEADING);
        Dimension tps = this.getPreferredSize(c, d, new Dimension(Math.max(0, bounds.width - lps.width - gap), bounds.height), TRAILING);
        Dimension ops = this.getPreferredSize(c, d, new Dimension(Math.max(0, bounds.width - lps.width - gap - tps.width - gap), bounds.height), OVERFLOW);
        int x = ltr ? bounds.x : Math.max(bounds.x, bounds.x + bounds.width - lps.width - gap - ops.width - gap - tps.width);
        int y = bounds.y;
        int width = Math.min(bounds.width, lps.width + gap + ops.width + gap + tps.width);
        int height = bounds.height;
        if (!this.isEmpty(c, d, LEADING)) {
            layoutData.put(LEADING, new Rectangle(x, y, lps.width, height));
            x += lps.width + gap;
            width -= lps.width + gap;
        }
        if (!this.isEmpty(c, d, TRAILING)) {
            int tx = Math.max(x, x + width - tps.width);
            layoutData.put(TRAILING, new Rectangle(tx, y, tps.width, height));
            width -= tps.width + gap;
        }
        if (!this.isEmpty(c, d, OVERFLOW)) {
            layoutData.put(OVERFLOW, new Rectangle(x, y, width, height));
        }
        return layoutData;
    }

    @Override
    @NotNull
    protected Dimension getContentPreferredSize(@NotNull C c, @NotNull D d, @NotNull Dimension available) {
        Dimension cps;
        Dimension ps = new Dimension(0, 0);
        int gap = this.getGap();
        if (!this.isEmpty(c, d, LEADING)) {
            cps = this.getPreferredSize(c, d, available, LEADING);
            ps.width += cps.width + gap;
            ps.height = Math.max(ps.height, cps.height);
            available.width -= ps.width + gap;
        }
        if (!this.isEmpty(c, d, TRAILING)) {
            cps = this.getPreferredSize(c, d, available, TRAILING);
            ps.width += cps.width + gap;
            ps.height = Math.max(ps.height, cps.height);
            available.width -= ps.width + gap;
        }
        if (!this.isEmpty(c, d, OVERFLOW)) {
            cps = this.getPreferredSize(c, d, available, OVERFLOW);
            ps.width += cps.width;
            ps.height = Math.max(ps.height, cps.height);
        }
        return ps;
    }
}

