/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.shape;

import com.alee.api.annotations.NotNull;
import com.alee.api.data.Orientation;
import com.alee.painter.decoration.WebDecoration;
import com.alee.painter.decoration.shape.ShapeType;
import com.alee.painter.decoration.shape.StretchInfo;
import com.alee.painter.decoration.shape.WebShape;
import com.alee.utils.MathUtils;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JComponent;

public abstract class AbstractProgressShape<C extends JComponent, D extends WebDecoration<C, D>, I extends AbstractProgressShape<C, D, I>>
extends WebShape<C, D, I> {
    @Override
    public boolean isVisible(@NotNull ShapeType type, @NotNull Rectangle bounds, @NotNull C c, @NotNull D d) {
        return super.isVisible(type, this.adjustBounds(bounds, c, d), c, d);
    }

    @Override
    @NotNull
    public Shape getShape(@NotNull ShapeType type, @NotNull Rectangle bounds, @NotNull C c, @NotNull D d) {
        return super.getShape(type, this.adjustBounds(bounds, c, d), c, d);
    }

    @Override
    @NotNull
    public Object[] getShapeSettings(@NotNull Rectangle bounds, @NotNull C c, @NotNull D d) {
        return super.getShapeSettings(this.adjustBounds(bounds, c, d), c, d);
    }

    @Override
    @NotNull
    public StretchInfo getStretchInfo(@NotNull Rectangle bounds, @NotNull C c, @NotNull D d) {
        return super.getStretchInfo(this.adjustBounds(bounds, c, d), c, d);
    }

    @NotNull
    protected Rectangle adjustBounds(@NotNull Rectangle bounds, @NotNull C c, @NotNull D d) {
        Rectangle result2;
        if (this.isIndeterminate(c, d)) {
            result2 = bounds;
        } else {
            Orientation orientation = this.getOrientation(c, d);
            double progress = this.getProgress(c, d);
            boolean ltr = ((Component)c).getComponentOrientation().isLeftToRight();
            if (orientation.isHorizontal()) {
                int barLength = MathUtils.roundToInt((double)bounds.width * progress);
                result2 = new Rectangle(ltr ? bounds.x : bounds.x + bounds.width - barLength, bounds.y, barLength, bounds.height);
            } else {
                int barLength = MathUtils.roundToInt((double)bounds.height * progress);
                result2 = new Rectangle(bounds.x, ltr ? bounds.y + bounds.height - barLength : bounds.y, bounds.width, barLength);
            }
        }
        return result2;
    }

    @NotNull
    protected abstract Orientation getOrientation(@NotNull C var1, @NotNull D var2);

    protected abstract boolean isIndeterminate(@NotNull C var1, @NotNull D var2);

    protected abstract double getProgress(@NotNull C var1, @NotNull D var2);
}

