/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.shape;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.data.CompassDirection;
import com.alee.api.jdk.Supplier;
import com.alee.painter.decoration.WebDecoration;
import com.alee.painter.decoration.shape.AbstractShape;
import com.alee.painter.decoration.shape.ShapeType;
import com.alee.utils.ShapeUtils;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import javax.swing.JComponent;

@XStreamAlias(value="ArrowShape")
public class ArrowShape<C extends JComponent, D extends WebDecoration<C, D>, I extends ArrowShape<C, D, I>>
extends AbstractShape<C, D, I> {
    @XStreamAsAttribute
    @Nullable
    protected CompassDirection direction;

    @NotNull
    public CompassDirection getDirection(@NotNull C c, @NotNull D d) {
        return this.direction != null ? this.direction.adjust(((Component)c).getComponentOrientation()) : CompassDirection.north;
    }

    @Override
    @NotNull
    public Shape getShape(final @NotNull ShapeType type, final @NotNull Rectangle bounds, @NotNull C c, @NotNull D d) {
        final CompassDirection direction = this.getDirection(c, d);
        return ShapeUtils.getShape(c, "ArrowShape." + (Object)((Object)type), new Supplier<Shape>(){

            @Override
            public Shape get() {
                return ArrowShape.this.createArrowButtonShape(type, bounds, direction);
            }
        }, new Object[]{type, bounds, direction});
    }

    @NotNull
    protected Shape createArrowButtonShape(@NotNull ShapeType type, @NotNull Rectangle bounds, @NotNull CompassDirection direction) {
        int x = bounds.x;
        int y = bounds.y;
        int w = bounds.width + (type == ShapeType.border ? -1 : 0);
        int h = bounds.height + (type == ShapeType.border ? -1 : 0);
        GeneralPath shape = new GeneralPath(0);
        switch (direction) {
            case north: {
                shape.moveTo(x, y + h);
                shape.quadTo((float)x + (float)w / 2.0f, (float)y + (float)(h * 2) / 3.0f, x + w, y + h);
                shape.lineTo((float)x + (float)w / 2.0f, y);
                break;
            }
            case south: {
                shape.moveTo(x, y);
                shape.quadTo((float)x + (float)w / 2.0f, (float)y + (float)h / 3.0f, x + w, y);
                shape.lineTo((float)x + (float)w / 2.0f, y + h);
                break;
            }
            case west: {
                shape.moveTo(x + w, y);
                shape.quadTo((float)x + (float)(w * 2) / 3.0f, (float)y + (float)h / 2.0f, x + w, y + h);
                shape.lineTo(x, (float)y + (float)h / 2.0f);
                break;
            }
            case east: {
                shape.moveTo(x, y);
                shape.quadTo((float)x + (float)w / 3.0f, (float)y + (float)h / 2.0f, x, y + h);
                shape.lineTo(x + w, (float)y + (float)h / 2.0f);
            }
        }
        shape.closePath();
        return shape;
    }

    @Override
    @NotNull
    public Object[] getShapeSettings(@NotNull Rectangle bounds, @NotNull C c, @NotNull D d) {
        return new Object[]{this.getDirection(c, d)};
    }
}

