/*
 * Decompiled with CFR 0.152.
 */
package com.alee.painter.decoration.shape;

import com.alee.api.annotations.NotNull;
import com.alee.api.jdk.Objects;
import com.alee.painter.decoration.shape.Sides;
import com.alee.utils.TextUtils;
import com.alee.utils.xml.XmlException;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import java.util.ArrayList;
import java.util.StringTokenizer;

public final class SidesConverter
extends AbstractSingleValueConverter {
    public static final String separator = ",";

    @Override
    public boolean canConvert(@NotNull Class type) {
        return Sides.class.isAssignableFrom(type);
    }

    @Override
    @NotNull
    public String toString(@NotNull Object object) {
        return SidesConverter.sidesToString((Sides)object);
    }

    @Override
    @NotNull
    public Object fromString(@NotNull String sides) {
        return SidesConverter.sidesFromString(sides);
    }

    @NotNull
    public static String sidesToString(@NotNull Sides sides) {
        ArrayList<String> list = new ArrayList<String>(4);
        if (sides.top) {
            list.add("top");
        }
        if (sides.left) {
            list.add("left");
        }
        if (sides.bottom) {
            list.add("bottom");
        }
        if (sides.right) {
            list.add("right");
        }
        if (list.isEmpty()) {
            list.add("none");
        }
        return TextUtils.listToString(list, separator);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static Sides sidesFromString(String string) {
        try {
            if (!TextUtils.notEmpty(string)) return new Sides(false);
            StringTokenizer tokenizer = new StringTokenizer(string, separator, false);
            if (!tokenizer.hasMoreTokens()) return new Sides(false);
            String first = tokenizer.nextToken().trim();
            if (Objects.equals((Object)first, "top", "left", "bottom", "right", "none")) {
                boolean top = string.contains("top");
                boolean left = string.contains("left");
                boolean bottom = string.contains("bottom");
                boolean right = string.contains("right");
                return new Sides(top, left, bottom, right);
            }
            if (first.length() == 1 && (first.charAt(0) == '0' || first.charAt(0) == '1')) {
                boolean top = Integer.parseInt(tokenizer.nextToken()) == 1;
                if (!tokenizer.hasMoreTokens()) return new Sides(top);
                boolean left = Integer.parseInt(tokenizer.nextToken()) == 1;
                if (!tokenizer.hasMoreTokens()) return new Sides(top, left);
                boolean bottom = Integer.parseInt(tokenizer.nextToken()) == 1;
                if (!tokenizer.hasMoreTokens()) return new Sides(top, left, bottom);
                boolean right = Integer.parseInt(tokenizer.nextToken()) == 1;
                return new Sides(top, left, bottom, right);
            }
            if (!first.equalsIgnoreCase("true")) {
                if (!first.equalsIgnoreCase("false")) throw new ConversionException("Unknown Sides format used: " + string);
            }
            boolean top = Boolean.parseBoolean(tokenizer.nextToken());
            if (!tokenizer.hasMoreTokens()) return new Sides(top);
            boolean left = Boolean.parseBoolean(tokenizer.nextToken());
            if (!tokenizer.hasMoreTokens()) return new Sides(top, left);
            boolean bottom = Boolean.parseBoolean(tokenizer.nextToken());
            if (!tokenizer.hasMoreTokens()) return new Sides(top, left, bottom);
            boolean right = Boolean.parseBoolean(tokenizer.nextToken());
            return new Sides(top, left, bottom, right);
        }
        catch (Exception e) {
            throw new XmlException("Unable to parse Sides: " + string, e);
        }
    }
}

