/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Function;
import com.alee.api.jdk.Objects;
import com.alee.api.jdk.Supplier;
import com.alee.utils.UtilityException;
import com.alee.utils.compare.Filter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;

public final class CollectionUtils {
    private CollectionUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    public static boolean isEmpty(@Nullable Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean notEmpty(@Nullable Collection collection) {
        return !CollectionUtils.isEmpty(collection);
    }

    @NotNull
    public static <T> List<T> nonNull(@Nullable List<T> list) {
        return list != null ? list : new ArrayList(0);
    }

    @NotNull
    public static <T> List<T> limit(@NotNull List<T> list, int limit) {
        return list.size() <= limit ? list : CollectionUtils.copySubList(list, 0, limit);
    }

    @Nullable
    public static <T> T max(@Nullable Collection<T> collection, @NotNull Comparator<T> comparator) {
        T result2 = CollectionUtils.isEmpty(collection) ? null : (collection.size() == 1 ? (T)collection.iterator().next() : (T)Collections.max(collection, comparator));
        return result2;
    }

    @NotNull
    public static <T> ArrayList<T> copySubList(@NotNull List<T> list, int fromIndex, int toIndex) {
        return new ArrayList<T>(list.subList(fromIndex, toIndex));
    }

    @NotNull
    public static ArrayList<Boolean> asList(@NotNull boolean[] data) {
        ArrayList<Boolean> list = new ArrayList<Boolean>(data.length);
        for (boolean i : data) {
            list.add(i);
        }
        return list;
    }

    @NotNull
    public static ArrayList<Integer> asList(@NotNull int[] data) {
        ArrayList<Integer> list = new ArrayList<Integer>(data.length);
        for (int i : data) {
            list.add(i);
        }
        return list;
    }

    @NotNull
    public static ArrayList<Character> asList(@NotNull char[] data) {
        ArrayList<Character> list = new ArrayList<Character>(data.length);
        for (char i : data) {
            list.add(Character.valueOf(i));
        }
        return list;
    }

    @NotNull
    public static ArrayList<Byte> asList(@NotNull byte[] data) {
        ArrayList<Byte> list = new ArrayList<Byte>(data.length);
        for (byte i : data) {
            list.add(i);
        }
        return list;
    }

    @NotNull
    public static ArrayList<Short> asList(@NotNull short[] data) {
        ArrayList<Short> list = new ArrayList<Short>(data.length);
        for (short i : data) {
            list.add(i);
        }
        return list;
    }

    @NotNull
    public static ArrayList<Long> asList(@NotNull long[] data) {
        ArrayList<Long> list = new ArrayList<Long>(data.length);
        for (long i : data) {
            list.add(i);
        }
        return list;
    }

    @NotNull
    public static ArrayList<Float> asList(@NotNull float[] data) {
        ArrayList<Float> list = new ArrayList<Float>(data.length);
        for (float i : data) {
            list.add(Float.valueOf(i));
        }
        return list;
    }

    @NotNull
    public static ArrayList<Double> asList(@NotNull double[] data) {
        ArrayList<Double> list = new ArrayList<Double>(data.length);
        for (double i : data) {
            list.add(i);
        }
        return list;
    }

    @NotNull
    public static <T> ArrayList<T> asList(T ... data) {
        ArrayList list = new ArrayList(data.length);
        Collections.addAll(list, data);
        return list;
    }

    @NotNull
    public static <T> ArrayList<T> asList(@NotNull Iterator<T> data) {
        ArrayList<T> list = new ArrayList<T>();
        while (data.hasNext()) {
            list.add(data.next());
        }
        return list;
    }

    @NotNull
    public static <T> ArrayList<T> asNonNullList(T ... data) {
        ArrayList<T> list = new ArrayList<T>(data.length);
        for (T object : data) {
            if (object == null) continue;
            list.add(object);
        }
        return list;
    }

    public static <T> boolean areAllUnique(@NotNull Collection<T> collection) {
        return new HashSet<T>(collection).size() == collection.size();
    }

    public static boolean addUnique(@NotNull Collection<Boolean> collection, @NotNull boolean[] objects) {
        boolean result2 = false;
        for (boolean object : objects) {
            if (collection.contains(object)) continue;
            result2 |= collection.add(object);
        }
        return result2;
    }

    public static boolean addUnique(@NotNull Collection<Integer> collection, @NotNull int[] objects) {
        boolean result2 = false;
        for (int object : objects) {
            if (collection.contains(object)) continue;
            result2 |= collection.add(object);
        }
        return result2;
    }

    public static boolean addUnique(@NotNull Collection<Character> collection, @NotNull char[] objects) {
        boolean result2 = false;
        for (char object : objects) {
            if (collection.contains(Character.valueOf(object))) continue;
            result2 |= collection.add(Character.valueOf(object));
        }
        return result2;
    }

    public static boolean addUnique(@NotNull Collection<Byte> collection, @NotNull byte[] objects) {
        boolean result2 = false;
        for (byte object : objects) {
            if (collection.contains(object)) continue;
            result2 |= collection.add(object);
        }
        return result2;
    }

    public static boolean addUnique(@NotNull Collection<Short> collection, @NotNull short[] objects) {
        boolean result2 = false;
        for (short object : objects) {
            if (collection.contains(object)) continue;
            result2 |= collection.add(object);
        }
        return result2;
    }

    public static boolean addUnique(@NotNull Collection<Long> collection, @NotNull long[] objects) {
        boolean result2 = false;
        for (long object : objects) {
            if (collection.contains(object)) continue;
            result2 |= collection.add(object);
        }
        return result2;
    }

    public static boolean addUnique(@NotNull Collection<Float> collection, @NotNull float[] objects) {
        boolean result2 = false;
        for (float object : objects) {
            if (collection.contains(Float.valueOf(object))) continue;
            result2 |= collection.add(Float.valueOf(object));
        }
        return result2;
    }

    public static boolean addUnique(@NotNull Collection<Double> collection, @NotNull double[] objects) {
        boolean result2 = false;
        for (double object : objects) {
            if (collection.contains(object)) continue;
            result2 |= collection.add(object);
        }
        return result2;
    }

    public static <T> boolean addUnique(@NotNull Collection<T> collection, T ... objects) {
        boolean result2 = false;
        for (T object : objects) {
            if (collection.contains(object)) continue;
            result2 |= collection.add(object);
        }
        return result2;
    }

    public static <T> boolean addUnique(@NotNull Collection<T> collection, @NotNull Collection<T> objects) {
        boolean result2 = false;
        for (T object : objects) {
            if (collection.contains(object)) continue;
            result2 |= collection.add(object);
        }
        return result2;
    }

    public static <T> boolean addUniqueNonNull(@NotNull Collection<T> collection, T ... objects) {
        boolean result2 = false;
        for (T object : objects) {
            if (collection.contains(object) || object == null) continue;
            result2 |= collection.add(object);
        }
        return result2;
    }

    public static <T> boolean addUniqueNonNull(@NotNull Collection<T> collection, @NotNull Collection<T> objects) {
        boolean result2 = false;
        for (T object : objects) {
            if (collection.contains(object) || object == null) continue;
            result2 |= collection.add(object);
        }
        return result2;
    }

    public static <T> boolean removeAll(@NotNull Collection<T> collection, T ... objects) {
        boolean result2 = false;
        for (T object : objects) {
            result2 |= collection.remove(object);
        }
        return result2;
    }

    public static <T> boolean removeAll(@NotNull Collection<T> collection, @NotNull Collection<T> objects) {
        boolean result2 = false;
        for (T object : objects) {
            result2 |= collection.remove(object);
        }
        return result2;
    }

    @NotNull
    public static <T> ArrayList<T> join(Collection<T> ... collections) {
        int size = 0;
        if (collections != null) {
            for (Collection<T> collection : collections) {
                size += collection != null ? collection.size() : 0;
            }
        }
        ArrayList<T> list = new ArrayList<T>(size);
        if (collections != null) {
            for (Collection<T> collection : collections) {
                if (!CollectionUtils.notEmpty(collection)) continue;
                list.addAll(collection);
            }
        }
        return list;
    }

    @Nullable
    public static <T> ArrayList<T> copy(@Nullable Collection<T> collection) {
        return collection != null ? new ArrayList<T>(collection) : null;
    }

    @NotNull
    public static <T> ArrayList<T> nonNullCopy(@NotNull Collection<T> collection) {
        return new ArrayList<T>(collection);
    }

    @Nullable
    public static <T> List<T> removeNulls(@Nullable List<T> list) {
        if (list != null) {
            for (int i = list.size() - 1; i >= 0; --i) {
                if (list.get(i) != null) continue;
                list.remove(i);
            }
        }
        return list;
    }

    public static boolean equals(@NotNull Collection collection1, @NotNull Collection collection2) {
        boolean equal;
        boolean bl = equal = collection1.size() == collection2.size();
        if (equal) {
            for (Object element : collection1) {
                if (collection2.contains(element)) continue;
                equal = false;
                break;
            }
        }
        return equal;
    }

    public static boolean equals(@Nullable List list1, @Nullable List list2, boolean strictIndices) {
        boolean equals;
        if (list1 == null && list2 == null) {
            equals = true;
        } else if (list1 == null || list2 == null || list1.size() != list2.size()) {
            equals = false;
        } else {
            boolean eq2 = true;
            if (strictIndices) {
                for (int i = 0; i < list1.size(); ++i) {
                    if (!Objects.notEquals(list1.get(i), list2.get(i))) continue;
                    eq2 = false;
                    break;
                }
            } else {
                for (Object object : list1) {
                    if (list2.contains(object)) continue;
                    eq2 = false;
                    break;
                }
                for (Object object : list2) {
                    if (list1.contains(object)) continue;
                    eq2 = false;
                    break;
                }
            }
            equals = eq2;
        }
        return equals;
    }

    @NotNull
    public static int[] toIntArray(@NotNull Collection<Integer> collection) {
        int[] array = new int[collection.size()];
        int index = 0;
        for (Integer integer : collection) {
            array[index] = integer != null ? integer : 0;
            ++index;
        }
        return array;
    }

    @NotNull
    public static Object[] toObjectArray(@NotNull Collection collection) {
        Object[] array = new Object[collection.size()];
        int index = 0;
        for (Object object : collection) {
            array[index] = object;
            ++index;
        }
        return array;
    }

    @NotNull
    public static <T> ArrayList<String> toStringList(@NotNull List<T> list, @NotNull Function<T, String> textProvider) {
        ArrayList<String> stringList = new ArrayList<String>(list.size());
        for (T element : list) {
            stringList.add(textProvider.apply(element));
        }
        return stringList;
    }

    @NotNull
    public static <T> ArrayList<T> toList(@NotNull T[] array) {
        ArrayList list = new ArrayList(array.length);
        Collections.addAll(list, array);
        return list;
    }

    @NotNull
    public static <T> ArrayList<T> toList(@NotNull Collection<T> collection) {
        return new ArrayList<T>(collection);
    }

    @NotNull
    public static <T> Vector<T> toVector(@NotNull Collection<T> collection) {
        return new Vector<T>(collection);
    }

    @NotNull
    public static <T> Vector<T> asVector(T ... data) {
        Vector vector = new Vector(data.length);
        Collections.addAll(vector, data);
        return vector;
    }

    @NotNull
    public static <T> ArrayList<T> filter(@NotNull Collection<T> collection, @Nullable Filter<T> filter2) {
        ArrayList<Object> filtered2;
        if (filter2 != null) {
            filtered2 = new ArrayList(collection.size());
            for (T element : collection) {
                if (!filter2.accept(element)) continue;
                filtered2.add(element);
            }
        } else {
            filtered2 = new ArrayList<T>(collection);
        }
        return filtered2;
    }

    @NotNull
    public static <T> ArrayList<T> filter(@NotNull Collection<T> collection, Filter<T> ... filters) {
        ArrayList<T> filtered2 = new ArrayList<T>(collection.size());
        for (T element : collection) {
            Filter<T> filter2;
            for (int i = 0; i < filters.length && ((filter2 = filters[i]) == null || filter2.accept(element)); ++i) {
                if (i != filters.length - 1) continue;
                filtered2.add(element);
            }
        }
        return filtered2;
    }

    @NotNull
    public static <T> List<T> distinct(@NotNull List<T> list) {
        HashSet<T> seen = new HashSet<T>(list.size());
        Iterator<T> iterator = list.iterator();
        while (iterator.hasNext()) {
            T element = iterator.next();
            if (!seen.contains(element)) {
                seen.add(element);
                continue;
            }
            iterator.remove();
        }
        return list;
    }

    @NotNull
    public static <T> List<T> sort(@NotNull List<T> list, @Nullable Comparator<T> comparator) {
        if (comparator != null) {
            Object[] array = list.toArray();
            Arrays.sort(array, comparator);
            ListIterator<T> iterator = list.listIterator();
            for (Object element : array) {
                iterator.next();
                iterator.set(element);
            }
        }
        return list;
    }

    @NotNull
    public static <T> List<T> sort(@NotNull List<T> list, Comparator<T> ... comparators) {
        for (Comparator<T> comparator : comparators) {
            if (comparator == null) continue;
            CollectionUtils.sort(list, comparator);
        }
        return list;
    }

    @NotNull
    public static <K, V> ArrayList<K> keysList(@NotNull Map<K, V> map) {
        return new ArrayList<K>(map.keySet());
    }

    @NotNull
    public static <K, V> ArrayList<V> valuesList(@NotNull Map<K, V> map) {
        return new ArrayList<V>(map.values());
    }

    @NotNull
    public static <K, V> ArrayList<V> valuesSummaryList(@NotNull Map<K, List<V>> map) {
        ArrayList<V> summary = new ArrayList<V>(0);
        for (Map.Entry<K, List<V>> entry : map.entrySet()) {
            List<V> list = entry.getValue();
            summary.ensureCapacity(summary.size() + list.size());
            for (V value : list) {
                if (summary.contains(value)) continue;
                summary.add(value);
            }
        }
        return summary;
    }

    @NotNull
    public static <T> List<T> fillList(int size, @NotNull Function<Integer, T> indexMapper) {
        ArrayList<T> list = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            list.add(indexMapper.apply(i));
        }
        return list;
    }

    @NotNull
    public static <T> HashSet<T> asHashSet(@NotNull Collection<T> data) {
        return new HashSet<T>(data);
    }

    @NotNull
    public static <T> HashSet<T> asHashSet(T ... data) {
        HashSet set = new HashSet(data.length);
        Collections.addAll(set, data);
        return set;
    }

    @NotNull
    public static List<Integer> intRange(int from, int to) {
        ArrayList<Integer> range = new ArrayList<Integer>(Math.max(from, to) - Math.min(from, to) + 1);
        for (int i = from; i != to; i += from < to ? 1 : -1) {
            range.add(i);
        }
        range.add(to);
        return range;
    }

    @NotNull
    public static <T extends Collection<?>> T requireNotEmpty(@Nullable T collection, @NotNull Supplier<RuntimeException> exceptionSupplier) {
        if (CollectionUtils.isEmpty(collection)) {
            throw exceptionSupplier.get();
        }
        return collection;
    }

    @Nullable
    public static <T> T roundRobin(int index, @NotNull List<T> items) {
        return items.size() > 0 ? (T)items.get(index % items.size()) : null;
    }
}

