/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.utils.ReflectUtils;
import com.alee.utils.SystemUtils;
import com.alee.utils.UtilityException;
import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.slf4j.LoggerFactory;

public final class CoreSwingUtils {
    private CoreSwingUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    public static void enableEventQueueLogging() {
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(new EventQueue(){

            @Override
            protected void dispatchEvent(AWTEvent event) {
                try {
                    super.dispatchEvent(event);
                }
                catch (Throwable e) {
                    String msg = "Uncaught EventQueue exception: %s";
                    LoggerFactory.getLogger(CoreSwingUtils.class).error(String.format("Uncaught EventQueue exception: %s", e.toString()), e);
                }
            }
        });
    }

    @Nullable
    public static AWTEvent getCurrentEvent() {
        return EventQueue.getCurrentEvent();
    }

    public static int getCurrentEventModifiers() {
        int modifiers = 0;
        AWTEvent currentEvent = CoreSwingUtils.getCurrentEvent();
        if (currentEvent instanceof InputEvent) {
            modifiers = ((InputEvent)currentEvent).getModifiers();
        } else if (currentEvent instanceof ActionEvent) {
            modifiers = ((ActionEvent)currentEvent).getModifiers();
        }
        return modifiers;
    }

    @NotNull
    public static Window getNonNullWindowAncestor(@NotNull Component component2) {
        Window window = CoreSwingUtils.getWindowAncestor(component2);
        if (window == null) {
            throw new UtilityException("Unable to retrieve Window ancestor for Component: " + component2);
        }
        return window;
    }

    @Nullable
    public static Window getWindowAncestor(@Nullable Component component2) {
        Window window;
        if (component2 != null) {
            if (!(component2 instanceof Window)) {
                Container parent;
                for (parent = component2.getParent(); parent != null && !(parent instanceof Window); parent = parent.getParent()) {
                }
                window = (Window)parent;
            } else {
                window = (Window)component2;
            }
        } else {
            window = null;
        }
        return window;
    }

    @NotNull
    public static JRootPane getNonNullRootPane(@NotNull Component component2) {
        JRootPane rootPane = CoreSwingUtils.getRootPane(component2);
        if (rootPane == null) {
            throw new UtilityException("Unable to retrieve JRootPane for Component: " + component2);
        }
        return rootPane;
    }

    @Nullable
    public static JRootPane getRootPane(@Nullable Component component2) {
        JRootPane rootPane = null;
        if (component2 instanceof JRootPane) {
            rootPane = (JRootPane)component2;
        } else if (component2 instanceof RootPaneContainer) {
            rootPane = ((RootPaneContainer)((Object)component2)).getRootPane();
        } else if (component2 != null) {
            for (Component other = component2; other != null; other = other.getParent()) {
                if (!(other instanceof JRootPane)) continue;
                rootPane = (JRootPane)other;
                break;
            }
        }
        return rootPane;
    }

    public static boolean isVisibleOnScreen(@NotNull Component component2) {
        boolean visible;
        if (component2.isShowing()) {
            Rectangle bounds = CoreSwingUtils.getBoundsOnScreen(component2, true);
            visible = bounds.width > 0 && bounds.height > 0;
        } else {
            visible = false;
        }
        return visible;
    }

    @NotNull
    public static Rectangle getBoundsOnScreen(@NotNull Component component2, boolean visibleOnly) {
        Rectangle bounds;
        Point los = CoreSwingUtils.locationOnScreen(component2);
        Dimension size = component2.getSize();
        if (visibleOnly) {
            Rectangle visible = CoreSwingUtils.getVisibleRect(component2);
            bounds = new Rectangle(los.x + visible.x, los.y + visible.y, visible.width, visible.height);
        } else {
            bounds = new Rectangle(los, size);
        }
        return bounds;
    }

    @Nullable
    public static Rectangle getBoundsInWindow(@NotNull Component component2) {
        JRootPane rootPane = CoreSwingUtils.getRootPane(component2);
        Rectangle boundsInWindow = rootPane != null ? (component2 instanceof Window || component2 instanceof JApplet ? rootPane.getBounds() : CoreSwingUtils.getRelativeBounds(component2, rootPane)) : null;
        return boundsInWindow;
    }

    @NotNull
    public static Rectangle getRelativeBounds(@NotNull Component component2, @NotNull Component relativeTo) {
        return new Rectangle(CoreSwingUtils.getRelativeLocation(component2, relativeTo), component2.getSize());
    }

    @NotNull
    public static Point getRelativeLocation(@NotNull Component component2, @NotNull Component relativeTo) {
        Point los = CoreSwingUtils.locationOnScreen(component2);
        Point rt = CoreSwingUtils.locationOnScreen(relativeTo);
        return new Point(los.x - rt.x, los.y - rt.y);
    }

    public static boolean isAncestorOf(@Nullable Component ancestor, @Nullable Component component2) {
        return ancestor instanceof Container && ((Container)ancestor).isAncestorOf(component2);
    }

    public static boolean isSameAncestor(@Nullable Component component1, @Nullable Component component2) {
        return CoreSwingUtils.getWindowAncestor(component1) == CoreSwingUtils.getWindowAncestor(component2);
    }

    @NotNull
    public static Insets getWindowDecorationInsets(@Nullable Window window) {
        JRootPane rootPane;
        Insets insets = new Insets(0, 0, 0, 0);
        if ((window instanceof Dialog || window instanceof Frame) && (rootPane = CoreSwingUtils.getRootPane(window)) != null) {
            if (window.isShowing()) {
                if (window instanceof Dialog && !((Dialog)window).isUndecorated() || window instanceof Frame && !((Frame)window).isUndecorated()) {
                    Rectangle wlos = CoreSwingUtils.getBoundsOnScreen(window, false);
                    Rectangle rlos = CoreSwingUtils.getBoundsOnScreen(rootPane, false);
                    insets.top = rlos.y - wlos.y;
                    insets.left = rlos.x - wlos.x;
                    insets.bottom = wlos.y + wlos.height - rlos.y - rlos.height;
                    insets.right = wlos.x + wlos.width - rlos.x - rlos.width;
                } else {
                    insets.top = 25;
                }
            } else {
                insets.top = 25;
            }
        }
        return insets;
    }

    public static boolean isFullScreen(@Nullable Component component2) {
        GraphicsDevice device;
        GraphicsConfiguration gc;
        Window window = CoreSwingUtils.getWindowAncestor(component2);
        boolean fullScreen = window != null ? ((gc = window.getGraphicsConfiguration()) != null ? (device = gc.getDevice()) != null && device.getFullScreenWindow() == window : false) : false;
        return fullScreen;
    }

    @NotNull
    public static PointerInfo getPointerInfo() {
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        if (pointerInfo == null) {
            try {
                pointerInfo = (PointerInfo)ReflectUtils.createInstance(PointerInfo.class, SystemUtils.getDefaultScreenDevice(), new Point(0, 0));
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to create empty PointerInfo", e);
            }
        }
        return pointerInfo;
    }

    @NotNull
    public static Point getMouseLocation() {
        return CoreSwingUtils.getPointerInfo().getLocation();
    }

    @NotNull
    public static Point getMouseLocation(@NotNull Component component2) {
        Point mouse = CoreSwingUtils.getMouseLocation();
        Point los = CoreSwingUtils.locationOnScreen(component2);
        return new Point(mouse.x - los.x, mouse.y - los.y);
    }

    public static boolean isHovered(@NotNull Component component2) {
        boolean hover = false;
        if (component2.isShowing() && !CoreSwingUtils.getVisibleRect(component2).isEmpty() && CoreSwingUtils.getBoundsOnScreen(component2, true).contains(CoreSwingUtils.getMouseLocation())) {
            hover = true;
        }
        return hover;
    }

    @Nullable
    public static Component getTopComponentAt(@Nullable Component component2, @NotNull Point point) {
        return CoreSwingUtils.getTopComponentAt(component2, point.x, point.y);
    }

    @Nullable
    public static Component getTopComponentAt(@Nullable Component component2, int x, int y) {
        Component top;
        if (component2 != null && component2.isVisible() && component2.contains(x, y)) {
            if (component2 instanceof Container) {
                Component child;
                Component topInChild = null;
                Container container = (Container)component2;
                for (int i = 0; i < container.getComponentCount() && (topInChild = CoreSwingUtils.getTopComponentAt(child = container.getComponent(i), x - child.getX(), y - child.getY())) == null; ++i) {
                }
                top = topInChild != null ? topInChild : component2;
            } else {
                top = component2;
            }
        } else {
            top = null;
        }
        return top;
    }

    @NotNull
    public static Point locationOnScreen(@NotNull Component component2) {
        try {
            return component2.getLocationOnScreen();
        }
        catch (IllegalComponentStateException e) {
            throw new UtilityException("Component must be showing on the screen to determine its location: " + component2);
        }
    }

    @NotNull
    public static List<JPopupMenu> getPopupMenus() {
        MenuElement[] selected = MenuSelectionManager.defaultManager().getSelectedPath();
        ArrayList<JPopupMenu> menus = new ArrayList<JPopupMenu>(selected.length);
        for (MenuElement element : selected) {
            if (!(element instanceof JPopupMenu)) continue;
            menus.add((JPopupMenu)element);
        }
        return menus;
    }

    public static boolean isMenuShortcutKeyDown(@NotNull InputEvent event) {
        return (event.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) != 0;
    }

    public static boolean isEventDispatchThread() {
        return SwingUtilities.isEventDispatchThread();
    }

    public static void invokeLater(@NotNull Runnable runnable) {
        SwingUtilities.invokeLater(runnable);
    }

    public static void invokeOnEventDispatchThread(@NotNull Runnable runnable) {
        if (CoreSwingUtils.isEventDispatchThread()) {
            runnable.run();
        } else {
            CoreSwingUtils.invokeLater(runnable);
        }
    }

    public static void invokeAndWait(@NotNull Runnable runnable) {
        CoreSwingUtils.invokeAndWait(runnable, false);
    }

    public static void invokeAndWait(@NotNull Runnable runnable, boolean ignoreInterrupts) {
        block5: {
            try {
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    SwingUtilities.invokeAndWait(runnable);
                }
            }
            catch (InvocationTargetException e) {
                throw new UtilityException(e);
            }
            catch (InterruptedException e) {
                if (ignoreInterrupts) break block5;
                throw new UtilityException(e);
            }
        }
    }

    @NotNull
    public static Rectangle getVisibleRect(@NotNull Component component2) {
        return component2 instanceof JComponent ? ((JComponent)component2).getVisibleRect() : CoreSwingUtils.computeVisibleRect(component2, new Rectangle());
    }

    @NotNull
    private static Rectangle computeVisibleRect(@NotNull Component component2, @NotNull Rectangle visibleRect) {
        Container p = component2.getParent();
        Rectangle bounds = component2.getBounds();
        if (p == null || p instanceof Window || p instanceof Applet) {
            visibleRect.setBounds(0, 0, bounds.width, bounds.height);
        } else {
            CoreSwingUtils.computeVisibleRect(p, visibleRect);
            visibleRect.x -= bounds.x;
            visibleRect.y -= bounds.y;
            SwingUtilities.computeIntersection(0, 0, bounds.width, bounds.height, visibleRect);
        }
        return visibleRect;
    }
}

