/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.api.annotations.NotNull;
import com.alee.utils.UtilityException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;

public final class ExceptionUtils {
    private ExceptionUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    @NotNull
    public static String getStackTrace(@NotNull Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    @NotNull
    public static String getStackTrace(@NotNull StackTraceElement[] trace) {
        StringWriter sw = new StringWriter();
        PrintWriter s = new PrintWriter((Writer)sw, true);
        for (StackTraceElement element : trace) {
            s.println("\tat " + element);
        }
        return sw.getBuffer().toString();
    }
}

