/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.utils.MathUtils;
import com.alee.utils.UtilityException;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;

public final class GeometryUtils {
    private GeometryUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    @Nullable
    public static Rectangle getContainingRect(@Nullable List<Point> points) {
        return points != null && points.size() > 0 ? GeometryUtils.getContainingRect(points.toArray(new Point[points.size()])) : null;
    }

    @Nullable
    public static Rectangle getContainingRect(Point ... points) {
        Rectangle rect;
        if (points != null && points.length > 0) {
            rect = new Rectangle(points[0], new Dimension(0, 0));
            for (int i = 1; i < points.length; ++i) {
                int diff;
                Point p = points[i];
                if (p.x < rect.x) {
                    diff = rect.x - p.x;
                    rect.x = p.x;
                    rect.width += diff;
                } else if (rect.x + rect.width < p.x) {
                    rect.width = p.x - rect.x;
                }
                if (p.y < rect.y) {
                    diff = rect.y - p.y;
                    rect.y = p.y;
                    rect.height += diff;
                    continue;
                }
                if (rect.y + rect.height >= p.y) continue;
                rect.height = p.y - rect.y;
            }
            if (rect.width == 0) {
                rect.width = 1;
            }
            if (rect.height == 0) {
                rect.height = 1;
            }
        } else {
            rect = null;
        }
        return rect;
    }

    @Nullable
    public static Rectangle getContainingRect(Rectangle ... rectangles) {
        Rectangle rect = null;
        if (rectangles != null && rectangles.length > 0) {
            rect = rectangles[0];
            for (int i = 1; i < rectangles.length; ++i) {
                rect = GeometryUtils.getContainingRect(rect, rectangles[i]);
            }
        }
        return rect;
    }

    @Nullable
    public static Rectangle getContainingRect(@Nullable Rectangle r1, @Nullable Rectangle r2) {
        Rectangle rect;
        if (r1 != null && r2 != null) {
            int minX = Math.min(r1.x, r2.x);
            int minY = Math.min(r1.y, r2.y);
            int maxX = Math.max(r1.x + r1.width, r2.x + r2.width);
            int maxY = Math.max(r1.y + r1.height, r2.y + r2.height);
            rect = new Rectangle(minX, minY, maxX - minX, maxY - minY);
        } else {
            rect = r1 != null ? r1 : r2;
        }
        return rect;
    }

    @NotNull
    public static Rectangle getNonNullContainingRect(@NotNull List<Point> points) {
        if (points.size() <= 0) {
            throw new RuntimeException("At least one point must be specified");
        }
        Rectangle rect = GeometryUtils.getNonNullContainingRect(points.toArray(new Point[points.size()]));
        return rect;
    }

    @NotNull
    public static Rectangle getNonNullContainingRect(Point ... points) {
        Rectangle rect;
        if (points.length > 0) {
            rect = new Rectangle(points[0], new Dimension(0, 0));
            for (int i = 1; i < points.length; ++i) {
                int diff;
                Point p = points[i];
                if (p.x < rect.x) {
                    diff = rect.x - p.x;
                    rect.x = p.x;
                    rect.width += diff;
                } else if (rect.x + rect.width < p.x) {
                    rect.width = p.x - rect.x;
                }
                if (p.y < rect.y) {
                    diff = rect.y - p.y;
                    rect.y = p.y;
                    rect.height += diff;
                    continue;
                }
                if (rect.y + rect.height >= p.y) continue;
                rect.height = p.y - rect.y;
            }
            if (rect.width == 0) {
                rect.width = 1;
            }
            if (rect.height == 0) {
                rect.height = 1;
            }
        } else {
            throw new RuntimeException("At least one point must be specified");
        }
        return rect;
    }

    @NotNull
    public static Rectangle getNonNullContainingRect(Rectangle ... rectangles) {
        Rectangle rect;
        if (rectangles.length > 0) {
            rect = rectangles[0];
            for (int i = 1; i < rectangles.length; ++i) {
                rect = GeometryUtils.getNonNullContainingRect(rect, rectangles[i]);
            }
        } else {
            throw new RuntimeException("At least one rectangle must be specified");
        }
        return rect;
    }

    @NotNull
    public static Rectangle getNonNullContainingRect(@NotNull Rectangle r1, @NotNull Rectangle r2) {
        int minX = Math.min(r1.x, r2.x);
        int minY = Math.min(r1.y, r2.y);
        int maxX = Math.max(r1.x + r1.width, r2.x + r2.width);
        int maxY = Math.max(r1.y + r1.height, r2.y + r2.height);
        return new Rectangle(minX, minY, maxX - minX, maxY - minY);
    }

    @NotNull
    public static Point middle(@NotNull Rectangle rectangle) {
        return new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
    }

    @NotNull
    public static Point middle(@NotNull Point p1, @NotNull Point p2) {
        return new Point((p1.x + p2.x) / 2, (p1.y + p2.y) / 2);
    }

    @NotNull
    public static Point middle(int x1, int y1, int x2, int y2) {
        return new Point((x1 + x2) / 2, (y1 + y2) / 2);
    }

    @NotNull
    public static Rectangle expand(@NotNull Rectangle rect, int expansion) {
        return GeometryUtils.expand(rect, expansion, expansion, expansion, expansion);
    }

    @NotNull
    public static Rectangle expand(@NotNull Rectangle rect, int top, int left, int bottom, int right) {
        return new Rectangle(rect.x - left, rect.y - top, rect.width + left + right, rect.height + top + bottom);
    }

    @NotNull
    public static Point modify(@NotNull Point point, int xMod, int yMod) {
        return new Point(point.x + xMod, point.y + yMod);
    }

    public static double getAngle(@NotNull Point p1, @NotNull Point p2) {
        return GeometryUtils.getAngle(p1.x, p1.y, p2.x, p2.y);
    }

    public static double getAngle(int x1, int y1, int x2, int y2) {
        double angle = Math.asin((double)(y2 - y1) / Math.sqrt(MathUtils.sqr(x2 - x1) + MathUtils.sqr(y2 - y1)));
        return x1 > x2 ? -angle - Math.PI : angle;
    }

    @NotNull
    public static Point findMiddleLineIntersection(@NotNull Rectangle rect, @NotNull Point outer) {
        int y;
        int x;
        Point intersection = null;
        Point middle = GeometryUtils.middle(rect);
        int x1 = middle.x;
        int y1 = middle.y;
        int x2 = outer.x;
        int y2 = outer.y;
        if (x2 < rect.x) {
            x = rect.x;
            y = (x1 * (y2 - y1) - y1 * (x2 - x1) - x * (y2 - y1)) / (x1 - x2);
            if (y >= rect.y && y <= rect.y + rect.height) {
                intersection = new Point(x, y);
            }
        } else if (x2 > rect.x + rect.width && (y = (x1 * (y2 - y1) - y1 * (x2 - x1) - (x = rect.x + rect.width) * (y2 - y1)) / (x1 - x2)) >= rect.y && y <= rect.y + rect.height) {
            intersection = new Point(x, y);
        }
        if (intersection == null) {
            int x3;
            int y3;
            if (y2 < rect.y) {
                y3 = rect.y;
                x3 = (x1 * (y2 - y1) - y1 * (x2 - x1) - y3 * (x1 - x2)) / (y2 - y1);
                if (x3 >= rect.x && x3 <= rect.x + rect.width) {
                    intersection = new Point(x3, y3);
                }
            } else if (y2 > rect.y + rect.height && (x3 = (x1 * (y2 - y1) - y1 * (x2 - x1) - (y3 = rect.y + rect.height) * (x1 - x2)) / (y2 - y1)) >= rect.x && x3 <= rect.x + rect.width) {
                intersection = new Point(x3, y3);
            }
            if (intersection == null) {
                intersection = middle;
            }
        }
        return intersection;
    }

    public static double toRadians(double angle) {
        return angle * Math.PI / 180.0;
    }

    public static double toDegrees(double angle) {
        return angle * 180.0 / Math.PI;
    }

    public static int distance(@NotNull Point p1, @NotNull Point p2) {
        return MathUtils.sqrtToInt(MathUtils.sqr(p2.x - p1.x) + MathUtils.sqr(p2.y - p1.y));
    }
}

