/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.resource.Resource;
import com.alee.api.ui.DisabledCopySupplier;
import com.alee.api.ui.TransparentCopySupplier;
import com.alee.graphics.filters.ShadowFilter;
import com.alee.utils.ColorUtils;
import com.alee.utils.EncryptionUtils;
import com.alee.utils.FileUtils;
import com.alee.utils.GraphicsUtils;
import com.alee.utils.IOUtils;
import com.alee.utils.SystemUtils;
import com.alee.utils.TextUtils;
import com.alee.utils.UtilityException;
import com.alee.utils.collection.ImmutableList;
import com.mortennobel.imagescaling.ResampleOp;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.slf4j.LoggerFactory;

public final class ImageUtils {
    public static final List<String> SUPPORTED_IMAGES = new ImmutableList<String>("png", "apng", "gif", "agif", "jpg", "jpeg", "jpeg2000", "bmp");
    private static final ColorConvertOp GRAYSCALE_FILTER = new ColorConvertOp(ColorSpace.getInstance(1003), null);
    protected static final Map<Icon, Icon> DISABLED_ICONS_CACHE = new WeakHashMap<Icon, Icon>(50);
    protected static final Map<Icon, Map<Float, Icon>> TRANSPARENT_ICONS_CACHE = new WeakHashMap<Icon, Map<Float, Icon>>(10);

    private ImageUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    public static boolean isImageSupported(@Nullable String name) {
        return SUPPORTED_IMAGES.contains(FileUtils.getFileExtPart(name, false).toLowerCase(Locale.ROOT));
    }

    public static boolean isTransparent(@NotNull BufferedImage bufferedImage, int x, int y) {
        return (bufferedImage.getRGB(x, y) >> 24 & 0xFF) > 0;
    }

    @NotNull
    public static BufferedImage createCompatibleImage(@NotNull BufferedImage bufferedImage) {
        return ImageUtils.createCompatibleImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getTransparency());
    }

    @NotNull
    public static BufferedImage createCompatibleImage(int width, int height) {
        return SystemUtils.getGraphicsConfiguration().createCompatibleImage(width, height);
    }

    @NotNull
    public static BufferedImage createCompatibleImage(int width, int height, int transparency) {
        return SystemUtils.getGraphicsConfiguration().createCompatibleImage(width, height, transparency);
    }

    public static boolean isCompatibleImage(@NotNull BufferedImage bufferedImage) {
        return bufferedImage.getColorModel().equals(SystemUtils.getGraphicsConfiguration().getColorModel());
    }

    @NotNull
    public static BufferedImage loadCompatibleImage(@NotNull Resource resource) {
        try {
            return ImageUtils.toCompatibleImage(ImageUtils.loadBufferedImage(resource));
        }
        catch (Exception e) {
            throw new UtilityException("Unable to load compatible BufferedImage: " + resource, e);
        }
    }

    @NotNull
    public static BufferedImage toCompatibleImage(@NotNull BufferedImage bufferedImage) {
        BufferedImage compatibleImage;
        if (ImageUtils.isCompatibleImage(bufferedImage)) {
            compatibleImage = bufferedImage;
        } else {
            compatibleImage = ImageUtils.createCompatibleImage(bufferedImage);
            Graphics2D g2d = compatibleImage.createGraphics();
            g2d.drawImage((Image)bufferedImage, 0, 0, null);
            g2d.dispose();
        }
        return compatibleImage;
    }

    @NotNull
    public static BufferedImage loadBufferedImage(@NotNull Resource resource) {
        return ImageUtils.loadBufferedImage(resource.getInputStream());
    }

    @NotNull
    public static BufferedImage loadBufferedImage(@NotNull InputStream inputStream) {
        try {
            return ImageIO.read(inputStream);
        }
        catch (Exception e) {
            throw new UtilityException("Unable to load BufferedImage: " + inputStream, e);
        }
    }

    @Nullable
    public static BufferedImage toBufferedImage(@Nullable Image image) {
        BufferedImage bufferedImage;
        if (image instanceof BufferedImage) {
            bufferedImage = (BufferedImage)image;
        } else if (image != null && image.getWidth(null) > 0 && image.getHeight(null) > 0) {
            BufferedImage bi = ImageUtils.createCompatibleImage(image.getWidth(null), image.getHeight(null), 3);
            Graphics2D g2d = bi.createGraphics();
            g2d.drawImage(image, 0, 0, null);
            g2d.dispose();
            bufferedImage = bi;
        } else {
            bufferedImage = null;
        }
        return bufferedImage;
    }

    @NotNull
    public static BufferedImage toNonNullBufferedImage(@NotNull Image image) {
        BufferedImage bufferedImage;
        if (image instanceof BufferedImage) {
            bufferedImage = (BufferedImage)image;
        } else if (image.getWidth(null) > 0 && image.getHeight(null) > 0) {
            BufferedImage bi = ImageUtils.createCompatibleImage(image.getWidth(null), image.getHeight(null), 3);
            Graphics2D g2d = bi.createGraphics();
            g2d.drawImage(image, 0, 0, null);
            g2d.dispose();
            bufferedImage = bi;
        } else {
            throw new UtilityException("Unable to convert Image to BufferedImage: " + image);
        }
        return bufferedImage;
    }

    @Nullable
    public static BufferedImage toBufferedImage(@Nullable Icon icon) {
        return icon != null ? ImageUtils.toNonNullBufferedImage(icon) : null;
    }

    @NotNull
    public static BufferedImage toNonNullBufferedImage(@NotNull Icon icon) {
        BufferedImage bufferedImage = icon instanceof ImageIcon && ((ImageIcon)icon).getImage() != null ? ImageUtils.toNonNullBufferedImage(((ImageIcon)icon).getImage()) : ImageUtils.paintToBufferedImage(icon);
        return bufferedImage;
    }

    @NotNull
    private static BufferedImage paintToBufferedImage(@NotNull Icon icon) {
        BufferedImage bufferedImage = ImageUtils.createCompatibleImage(icon.getIconWidth(), icon.getIconHeight(), 3);
        Graphics2D g2d = bufferedImage.createGraphics();
        icon.paintIcon(null, g2d, 0, 0);
        g2d.dispose();
        return bufferedImage;
    }

    @Nullable
    public static BufferedImage toBufferedImage(@Nullable RenderedImage renderedImage) {
        return renderedImage != null ? ImageUtils.toNonNullBufferedImage(renderedImage) : null;
    }

    @NotNull
    public static BufferedImage toNonNullBufferedImage(@NotNull RenderedImage renderedImage) {
        BufferedImage bufferedImage;
        if (renderedImage instanceof BufferedImage) {
            bufferedImage = (BufferedImage)renderedImage;
        } else {
            ColorModel cm = renderedImage.getColorModel();
            int width = renderedImage.getWidth();
            int height = renderedImage.getHeight();
            WritableRaster raster = cm.createCompatibleWritableRaster(width, height);
            boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            String[] keys = renderedImage.getPropertyNames();
            if (keys != null) {
                for (String key : keys) {
                    properties.put(key, renderedImage.getProperty(key));
                }
            }
            bufferedImage = new BufferedImage(cm, raster, isAlphaPremultiplied, properties);
            renderedImage.copyData(raster);
        }
        return bufferedImage;
    }

    @NotNull
    public static BufferedImage copyToBufferedImage(@NotNull Icon icon) {
        return ImageUtils.copyToBufferedImage(ImageUtils.toNonNullBufferedImage(icon));
    }

    @NotNull
    public static BufferedImage copyToBufferedImage(@NotNull Image image) {
        return ImageUtils.copyToBufferedImage(ImageUtils.toNonNullBufferedImage(image));
    }

    @NotNull
    public static BufferedImage copyToBufferedImage(@NotNull BufferedImage bufferedImage) {
        BufferedImage newImage = ImageUtils.createCompatibleImage(bufferedImage);
        Graphics2D g2d = newImage.createGraphics();
        g2d.drawImage((Image)bufferedImage, 0, 0, null);
        g2d.dispose();
        return newImage;
    }

    @NotNull
    public static ImageIcon loadImageIcon(@NotNull Resource resource) {
        return ImageUtils.loadImageIcon(resource.getInputStream());
    }

    @NotNull
    public static ImageIcon loadImageIcon(@NotNull InputStream inputStream) {
        return new ImageIcon(IOUtils.toByteArray(inputStream));
    }

    @Nullable
    public static ImageIcon toImageIcon(@Nullable Image image) {
        return image != null ? ImageUtils.toNonNullImageIcon(image) : null;
    }

    @NotNull
    public static ImageIcon toNonNullImageIcon(@NotNull Image image) {
        return new ImageIcon(image);
    }

    @Nullable
    public static ImageIcon toImageIcon(@Nullable Icon icon) {
        return icon != null ? ImageUtils.toNonNullImageIcon(icon) : null;
    }

    @NotNull
    public static ImageIcon toNonNullImageIcon(@NotNull Icon icon) {
        ImageIcon imageIcon = icon instanceof ImageIcon ? (ImageIcon)icon : new ImageIcon(ImageUtils.toNonNullBufferedImage(icon));
        return imageIcon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Icon getDisabledCopy(@NotNull Icon icon) {
        Icon disabledIcon;
        if (DISABLED_ICONS_CACHE.containsKey(icon)) {
            disabledIcon = DISABLED_ICONS_CACHE.get(icon);
        } else {
            Map<Icon, Icon> map = DISABLED_ICONS_CACHE;
            synchronized (map) {
                if (DISABLED_ICONS_CACHE.containsKey(icon)) {
                    disabledIcon = DISABLED_ICONS_CACHE.get(icon);
                } else {
                    disabledIcon = ImageUtils.createDisabledCopy(icon);
                    DISABLED_ICONS_CACHE.put(icon, disabledIcon);
                }
            }
        }
        return disabledIcon;
    }

    @NotNull
    public static Icon createDisabledCopy(@NotNull Icon icon) {
        Icon disabledCopy = icon instanceof DisabledCopySupplier ? (Icon)((DisabledCopySupplier)((Object)icon)).createDisabledCopy() : new ImageIcon(ImageUtils.createDisabledCopy(ImageUtils.toNonNullBufferedImage(icon)));
        return disabledCopy;
    }

    @NotNull
    public static BufferedImage createDisabledCopy(@NotNull Image image) {
        return ImageUtils.createDisabledCopy(ImageUtils.toNonNullBufferedImage(image));
    }

    @NotNull
    public static BufferedImage createDisabledCopy(@NotNull BufferedImage bufferedImage) {
        BufferedImage disabledCopy = ImageUtils.createCompatibleImage(bufferedImage);
        Graphics2D g2d = disabledCopy.createGraphics();
        GraphicsUtils.setupAlphaComposite(g2d, Float.valueOf(0.7f));
        g2d.drawImage((Image)bufferedImage, 0, 0, null);
        g2d.dispose();
        GRAYSCALE_FILTER.filter(disabledCopy, disabledCopy);
        return disabledCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Icon getTransparentCopy(@NotNull Icon icon, float opacity) {
        Icon transparentIcon;
        Map<Float, Icon> transparentCopies;
        if (TRANSPARENT_ICONS_CACHE.containsKey(icon)) {
            transparentCopies = TRANSPARENT_ICONS_CACHE.get(icon);
        } else {
            Map<Icon, Map<Float, Icon>> map = TRANSPARENT_ICONS_CACHE;
            synchronized (map) {
                if (TRANSPARENT_ICONS_CACHE.containsKey(icon)) {
                    transparentCopies = TRANSPARENT_ICONS_CACHE.get(icon);
                } else {
                    transparentCopies = new HashMap<Float, Icon>(1);
                    TRANSPARENT_ICONS_CACHE.put(icon, transparentCopies);
                }
            }
        }
        if (transparentCopies.containsKey(Float.valueOf(opacity))) {
            transparentIcon = transparentCopies.get(Float.valueOf(opacity));
        } else {
            Map<Icon, Map<Float, Icon>> map = TRANSPARENT_ICONS_CACHE;
            synchronized (map) {
                if (transparentCopies.containsKey(Float.valueOf(opacity))) {
                    transparentIcon = transparentCopies.get(Float.valueOf(opacity));
                } else {
                    transparentIcon = ImageUtils.createTransparentCopy(icon, opacity);
                    transparentCopies.put(Float.valueOf(opacity), transparentIcon);
                }
            }
        }
        return transparentIcon;
    }

    @NotNull
    public static Icon createTransparentCopy(@NotNull Icon icon, float opacity) {
        Icon transparentCopy = icon instanceof TransparentCopySupplier ? (Icon)((TransparentCopySupplier)((Object)icon)).createTransparentCopy(opacity) : new ImageIcon(ImageUtils.createTransparentCopy(ImageUtils.toNonNullBufferedImage(icon), opacity));
        return transparentCopy;
    }

    @NotNull
    public static BufferedImage createTransparentCopy(@NotNull Image image, float opacity) {
        return ImageUtils.createTransparentCopy(ImageUtils.toNonNullBufferedImage(image), opacity);
    }

    @NotNull
    public static BufferedImage createTransparentCopy(@NotNull BufferedImage bufferedImage, float opacity) {
        BufferedImage transparentCopy = ImageUtils.createCompatibleImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 3);
        Graphics2D g2d = transparentCopy.createGraphics();
        GraphicsUtils.setupAlphaComposite(g2d, Float.valueOf(opacity));
        g2d.drawImage((Image)bufferedImage, 0, 0, null);
        g2d.dispose();
        return transparentCopy;
    }

    public static BufferedImage cutImage(@NotNull Icon icon, @NotNull Shape shape) {
        return ImageUtils.cutImage(ImageUtils.toNonNullBufferedImage(icon), shape);
    }

    public static BufferedImage cutImage(@NotNull Image image, @NotNull Shape shape) {
        return ImageUtils.cutImage(ImageUtils.toNonNullBufferedImage(image), shape);
    }

    public static BufferedImage cutImage(@NotNull BufferedImage bufferedImage, @NotNull Shape shape) {
        BufferedImage cutImage = ImageUtils.createCompatibleImage(bufferedImage);
        Graphics2D g2d = cutImage.createGraphics();
        GraphicsUtils.setupAntialias(g2d);
        g2d.setPaint(Color.WHITE);
        g2d.fill(shape);
        g2d.setComposite(AlphaComposite.getInstance(5));
        g2d.drawImage((Image)bufferedImage, 0, 0, null);
        g2d.dispose();
        return cutImage;
    }

    @NotNull
    public static BufferedImage createImageThumbnail(@NotNull BufferedImage bufferedImage, @NotNull Dimension maxSize) {
        return ImageUtils.createImageThumbnail(bufferedImage, maxSize.width, maxSize.height);
    }

    @NotNull
    public static BufferedImage createImageThumbnail(@NotNull BufferedImage bufferedImage, int maxWidth, int maxHeight) {
        BufferedImage preview = bufferedImage.getWidth() > maxWidth || bufferedImage.getHeight() > maxHeight ? ((float)maxHeight * ((float)bufferedImage.getWidth() / (float)bufferedImage.getHeight()) <= (float)maxWidth ? ImageUtils.createImageThumbnail(bufferedImage, Math.max(maxHeight, Math.round((float)maxHeight * ((float)bufferedImage.getWidth() / (float)bufferedImage.getHeight())))) : ImageUtils.createImageThumbnail(bufferedImage, Math.max(maxWidth, Math.round((float)maxWidth * ((float)bufferedImage.getHeight() / (float)bufferedImage.getWidth()))))) : bufferedImage;
        return preview;
    }

    @NotNull
    public static BufferedImage createImageThumbnail(@NotNull BufferedImage bufferedImage, int maxSize) {
        BufferedImage preview;
        if (bufferedImage.getWidth() <= maxSize && bufferedImage.getHeight() <= maxSize) {
            preview = ImageUtils.toCompatibleImage(bufferedImage);
        } else {
            int height;
            int width;
            if (bufferedImage.getWidth() > bufferedImage.getHeight()) {
                width = maxSize;
                height = Math.round((float)maxSize * (float)bufferedImage.getHeight() / (float)bufferedImage.getWidth());
            } else if (bufferedImage.getWidth() < bufferedImage.getHeight()) {
                height = maxSize;
                width = Math.round((float)maxSize * (float)bufferedImage.getWidth() / (float)bufferedImage.getHeight());
            } else {
                width = height = maxSize;
            }
            if (width >= 3 && height >= 3) {
                ResampleOp scaleOp = new ResampleOp(width, height);
                preview = scaleOp.filter(bufferedImage, ImageUtils.createCompatibleImage(bufferedImage));
            } else {
                preview = ImageUtils.createCompatibleImage(Math.max(1, width), Math.max(1, height), 3);
                Graphics2D g2d = preview.createGraphics();
                GraphicsUtils.setupImageQuality(g2d);
                g2d.drawImage(bufferedImage, 0, 0, width, height, null);
                g2d.dispose();
            }
        }
        return preview;
    }

    @NotNull
    public static Color getDominantColor(@NotNull BufferedImage image) {
        int red = 0;
        int green = 0;
        int blue = 0;
        for (int i = 0; i < image.getWidth(); ++i) {
            for (int j = 0; j < image.getHeight(); ++j) {
                int rgb = image.getRGB(i, j);
                red += rgb >> 16 & 0xFF;
                green += rgb >> 8 & 0xFF;
                blue += rgb & 0xFF;
            }
        }
        int count = image.getWidth() * image.getHeight();
        return new Color(red / count, green / count, blue / count);
    }

    @NotNull
    public static ImageIcon rotateIcon90CW(@NotNull Icon icon) {
        return new ImageIcon(ImageUtils.rotateImage90CW(ImageUtils.toNonNullBufferedImage(icon)));
    }

    @NotNull
    public static BufferedImage rotateImage90CW(@NotNull Image image) {
        return ImageUtils.rotateImage90CW(ImageUtils.toNonNullBufferedImage(image));
    }

    @NotNull
    public static BufferedImage rotateImage90CW(@NotNull BufferedImage bufferedImage) {
        BufferedImage rotatedImage = ImageUtils.createCompatibleImage(bufferedImage);
        Graphics2D g2d = rotatedImage.createGraphics();
        g2d.translate(bufferedImage.getHeight(), 0);
        g2d.rotate(1.5707963267948966);
        g2d.drawImage((Image)bufferedImage, 0, 0, null);
        g2d.dispose();
        return rotatedImage;
    }

    @NotNull
    public static ImageIcon rotateIcon90CCW(@NotNull Icon icon) {
        return new ImageIcon(ImageUtils.rotateImage90CCW(ImageUtils.toBufferedImage(icon)));
    }

    @NotNull
    public static BufferedImage rotateImage90CCW(@NotNull Image image) {
        return ImageUtils.rotateImage90CCW(ImageUtils.toNonNullBufferedImage(image));
    }

    @NotNull
    public static BufferedImage rotateImage90CCW(@NotNull BufferedImage bufferedImage) {
        BufferedImage rotatedImage = ImageUtils.createCompatibleImage(bufferedImage);
        Graphics2D g2d = rotatedImage.createGraphics();
        g2d.translate(0, bufferedImage.getWidth());
        g2d.rotate(-1.5707963267948966);
        g2d.drawImage((Image)bufferedImage, 0, 0, null);
        g2d.dispose();
        return rotatedImage;
    }

    @NotNull
    public static ImageIcon rotateIcon180(@NotNull Icon icon) {
        return new ImageIcon(ImageUtils.rotateImage180(ImageUtils.toBufferedImage(icon)));
    }

    @NotNull
    public static BufferedImage rotateImage180(@NotNull Image image) {
        return ImageUtils.rotateImage180(ImageUtils.toNonNullBufferedImage(image));
    }

    @NotNull
    public static BufferedImage rotateImage180(@NotNull BufferedImage bufferedImage) {
        BufferedImage rotatedImage = ImageUtils.createCompatibleImage(bufferedImage);
        Graphics2D g2d = rotatedImage.createGraphics();
        g2d.translate(bufferedImage.getWidth(), bufferedImage.getHeight());
        g2d.rotate(Math.PI);
        g2d.drawImage((Image)bufferedImage, 0, 0, null);
        g2d.dispose();
        return rotatedImage;
    }

    @NotNull
    public static BufferedImage createShadowImage(int width, int height, @NotNull Shape shape, int shadowWidth, float opacity, boolean clip) {
        BufferedImage bi = ImageUtils.createCompatibleImage(width, height, 3);
        Graphics2D ig = bi.createGraphics();
        GraphicsUtils.setupAntialias(ig);
        ig.setPaint(Color.BLACK);
        ig.fill(shape);
        ig.dispose();
        ShadowFilter sf = new ShadowFilter(shadowWidth, 0.0f, 0.0f, opacity);
        BufferedImage shadow = sf.filter(bi, null);
        if (clip) {
            Graphics2D g2d = shadow.createGraphics();
            GraphicsUtils.setupAntialias(g2d);
            g2d.setComposite(AlphaComposite.getInstance(5));
            g2d.setPaint(ColorUtils.transparent());
            g2d.fill(shape);
            g2d.dispose();
        }
        return shadow;
    }

    @NotNull
    public static BufferedImage createInnerShadowImage(int width, @NotNull Shape shape, int shadowWidth, float opacity) {
        BufferedImage bi = ImageUtils.createCompatibleImage(width, width, 3);
        Graphics2D ig = bi.createGraphics();
        GraphicsUtils.setupAntialias(ig);
        Area area = new Area(new Rectangle(0, 0, width, width));
        area.exclusiveOr(new Area(shape));
        ig.setPaint(Color.BLACK);
        ig.fill(area);
        ig.dispose();
        ShadowFilter sf = new ShadowFilter(shadowWidth, 0.0f, 0.0f, opacity);
        BufferedImage shadow = sf.filter(bi, null);
        Graphics2D g2d = shadow.createGraphics();
        GraphicsUtils.setupAntialias(g2d);
        g2d.setComposite(AlphaComposite.getInstance(5));
        g2d.setPaint(ColorUtils.transparent());
        g2d.fill(area);
        g2d.dispose();
        return shadow.getSubimage(shadowWidth, shadowWidth, width - shadowWidth * 2, width - shadowWidth * 2);
    }

    @Nullable
    public static BufferedImage decodeImage(@Nullable String imageData) {
        String rawImageData;
        BufferedImage image = null;
        if (TextUtils.notEmpty(imageData) && (rawImageData = EncryptionUtils.base64decode(imageData)) != null) {
            byte[] bytes = rawImageData.getBytes();
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            try {
                image = ImageIO.read(bis);
                bis.close();
            }
            catch (Exception ex) {
                String msg = "Unable to decode image icon";
                LoggerFactory.getLogger(ImageUtils.class).error("Unable to decode image icon", ex);
                try {
                    bis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return image;
    }

    @Nullable
    public static String encodeImage(@Nullable BufferedImage image) {
        String imageString = null;
        if (image != null) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)image, "png", bos);
                imageString = EncryptionUtils.base64encode(new String(bos.toByteArray()));
                bos.close();
            }
            catch (IOException ex) {
                String msg = "Unable to encode image icon";
                LoggerFactory.getLogger(ImageUtils.class).error("Unable to encode image icon", ex);
                try {
                    bos.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return imageString;
    }
}

