/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.utils.ArrayUtils;
import com.alee.utils.CollectionUtils;
import com.alee.utils.UtilityException;
import com.alee.utils.collection.ImmutableList;
import com.alee.utils.reflection.FieldHelper;
import com.alee.utils.reflection.ModifierType;
import com.alee.utils.reflection.ReflectionException;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.LoggerFactory;

public final class ReflectUtils {
    private static boolean safeMethodsLoggingEnabled = false;
    private static final Map<Class, Map<String, Field>> fieldsLookupCache = new HashMap<Class, Map<String, Field>>();
    private static final Map<Class, Map<String, Method>> methodsLookupCache = new HashMap<Class, Map<String, Method>>();

    private ReflectUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    public static boolean isSafeMethodsLoggingEnabled() {
        return safeMethodsLoggingEnabled;
    }

    public static void setSafeMethodsLoggingEnabled(boolean enabled) {
        safeMethodsLoggingEnabled = enabled;
    }

    @Nullable
    public static <T> Class<T> getClassSafely(@NotNull String canonicalName) {
        try {
            return ReflectUtils.getClass(canonicalName);
        }
        catch (Exception e) {
            if (safeMethodsLoggingEnabled) {
                String msg = "ReflectionUtils method failed: getClassSafely ( %s )";
                LoggerFactory.getLogger(ReflectUtils.class).error(String.format("ReflectionUtils method failed: getClassSafely ( %s )", canonicalName), e);
            }
            return null;
        }
    }

    @NotNull
    public static <T> Class<T> getClass(@NotNull String canonicalName) throws ClassNotFoundException {
        return Class.forName(canonicalName);
    }

    public static <T> Class<T> getInnerClassSafely(Class fromClass, String innerClassName) {
        return ReflectUtils.getInnerClassSafely(fromClass.getCanonicalName(), innerClassName);
    }

    public static <T> Class<T> getInnerClassSafely(String fromClassName, String innerClassName) {
        try {
            return ReflectUtils.getInnerClass(fromClassName, innerClassName);
        }
        catch (Exception e) {
            if (safeMethodsLoggingEnabled) {
                String msg = "ReflectionUtils method failed: getInnerClassSafely ( %s, %s )";
                LoggerFactory.getLogger(ReflectUtils.class).error(String.format("ReflectionUtils method failed: getInnerClassSafely ( %s, %s )", fromClassName, innerClassName), e);
            }
            return null;
        }
    }

    public static <T> Class<T> getInnerClass(Class fromClass, String innerClassName) throws ClassNotFoundException {
        return ReflectUtils.getInnerClass(fromClass.getCanonicalName(), innerClassName);
    }

    public static <T> Class<T> getInnerClass(String fromClassName, String innerClassName) throws ClassNotFoundException {
        return ReflectUtils.getClass(fromClassName + "$" + innerClassName);
    }

    public static Class getCallerClass() {
        return ReflectUtils.getCallerClass(1);
    }

    public static Class getCallerClass(int additionalDepth) {
        int depth = 2 + additionalDepth;
        try {
            return (Class)ReflectUtils.callStaticMethod("sun.reflect.Reflection", "getCallerClass", depth + 3);
        }
        catch (Exception e) {
            try {
                return ReflectUtils.getClass(new Throwable().getStackTrace()[depth].getClassName());
            }
            catch (ClassNotFoundException ex) {
                return null;
            }
        }
    }

    public static List<Field> getFields(Object object) {
        return ReflectUtils.getFields(object.getClass());
    }

    public static List<Field> getFields(Class clazz) {
        return ReflectUtils.getFields(clazz, ModifierType.STATIC);
    }

    public static List<Field> getFields(Object object, ModifierType ... ignoredModifiers) {
        return ReflectUtils.getFields(object.getClass(), ignoredModifiers);
    }

    public static List<Field> getFields(Class clazz, ModifierType ... ignoredModifiers) {
        return ReflectUtils.getFields(clazz, new HashSet<String>(), ignoredModifiers);
    }

    private static List<Field> getFields(Class clazz, Set<String> found, ModifierType ... ignoredModifiers) {
        Field[] declared = clazz.getDeclaredFields();
        ArrayList<Field> fields = new ArrayList<Field>(declared.length);
        for (Field field2 : declared) {
            if (found.contains(field2.getName()) || !ReflectUtils.hasNoneOfModifiers(field2, ignoredModifiers)) continue;
            field2.setAccessible(true);
            fields.add(field2);
            found.add(field2.getName());
        }
        Class superclass = clazz.getSuperclass();
        if (superclass != null) {
            fields.addAll(ReflectUtils.getFields(superclass, found, ignoredModifiers));
        }
        return fields;
    }

    public static boolean hasAnyOfModifiers(Class clazz, ModifierType ... modifiers) {
        return ReflectUtils.hasAnyOfModifiers(clazz, new ImmutableList<ModifierType>(modifiers));
    }

    public static boolean hasAnyOfModifiers(Class clazz, Collection<ModifierType> modifiers) {
        boolean contains = false;
        if (CollectionUtils.notEmpty(modifiers)) {
            for (ModifierType modifier : modifiers) {
                if (!modifier.is(clazz)) continue;
                contains = true;
                break;
            }
        }
        return contains;
    }

    public static boolean hasAllOfModifiers(Class clazz, ModifierType ... modifiers) {
        return ReflectUtils.hasAllOfModifiers(clazz, new ImmutableList<ModifierType>(modifiers));
    }

    public static boolean hasAllOfModifiers(Class clazz, Collection<ModifierType> modifiers) {
        boolean contains = true;
        if (ArrayUtils.notEmpty(modifiers)) {
            for (ModifierType modifier : modifiers) {
                if (!modifier.not(clazz)) continue;
                contains = false;
                break;
            }
        }
        return contains;
    }

    public static boolean hasNoneOfModifiers(Class clazz, ModifierType ... modifiers) {
        return ReflectUtils.hasNoneOfModifiers(clazz, new ImmutableList<ModifierType>(modifiers));
    }

    public static boolean hasNoneOfModifiers(Class clazz, Collection<ModifierType> modifiers) {
        return !ReflectUtils.hasAnyOfModifiers(clazz, modifiers);
    }

    public static boolean hasAnyOfModifiers(Method method, ModifierType ... modifiers) {
        return ReflectUtils.hasAnyOfModifiers(method, new ImmutableList<ModifierType>(modifiers));
    }

    public static boolean hasAnyOfModifiers(Method method, Collection<ModifierType> modifiers) {
        boolean contains = false;
        if (CollectionUtils.notEmpty(modifiers)) {
            for (ModifierType modifier : modifiers) {
                if (!modifier.is(method)) continue;
                contains = true;
                break;
            }
        }
        return contains;
    }

    public static boolean hasAllOfModifiers(Method method, ModifierType ... modifiers) {
        return ReflectUtils.hasAllOfModifiers(method, new ImmutableList<ModifierType>(modifiers));
    }

    public static boolean hasAllOfModifiers(Method method, Collection<ModifierType> modifiers) {
        boolean contains = true;
        if (ArrayUtils.notEmpty(modifiers)) {
            for (ModifierType modifier : modifiers) {
                if (!modifier.not(method)) continue;
                contains = false;
                break;
            }
        }
        return contains;
    }

    public static boolean hasNoneOfModifiers(Method method, ModifierType ... modifiers) {
        return ReflectUtils.hasNoneOfModifiers(method, new ImmutableList<ModifierType>(modifiers));
    }

    public static boolean hasNoneOfModifiers(Method method, Collection<ModifierType> modifiers) {
        return !ReflectUtils.hasAnyOfModifiers(method, modifiers);
    }

    public static boolean hasAnyOfModifiers(Field field2, ModifierType ... modifiers) {
        return ReflectUtils.hasAnyOfModifiers(field2, new ImmutableList<ModifierType>(modifiers));
    }

    public static boolean hasAnyOfModifiers(Field field2, Collection<ModifierType> modifiers) {
        boolean contains = false;
        if (CollectionUtils.notEmpty(modifiers)) {
            for (ModifierType modifier : modifiers) {
                if (!modifier.is(field2)) continue;
                contains = true;
                break;
            }
        }
        return contains;
    }

    public static boolean hasAllOfModifiers(Field field2, ModifierType ... modifiers) {
        return ReflectUtils.hasAllOfModifiers(field2, new ImmutableList<ModifierType>(modifiers));
    }

    public static boolean hasAllOfModifiers(Field field2, Collection<ModifierType> modifiers) {
        boolean contains = true;
        if (ArrayUtils.notEmpty(modifiers)) {
            for (ModifierType modifier : modifiers) {
                if (!modifier.not(field2)) continue;
                contains = false;
                break;
            }
        }
        return contains;
    }

    public static boolean hasNoneOfModifiers(Field field2, ModifierType ... modifiers) {
        return ReflectUtils.hasNoneOfModifiers(field2, new ImmutableList<ModifierType>(modifiers));
    }

    public static boolean hasNoneOfModifiers(Field field2, Collection<ModifierType> modifiers) {
        return !ReflectUtils.hasAnyOfModifiers(field2, modifiers);
    }

    @Nullable
    public static Field getFieldSafely(@NotNull Class classType, @NotNull String fieldName) {
        Field field2;
        block2: {
            field2 = null;
            try {
                field2 = ReflectUtils.getField(classType, fieldName);
            }
            catch (NoSuchFieldException e) {
                if (!safeMethodsLoggingEnabled) break block2;
                String msg = "ReflectionUtils method failed: getFieldSafely ( %s, %s )";
                LoggerFactory.getLogger(ReflectUtils.class).error(String.format("ReflectionUtils method failed: getFieldSafely ( %s, %s )", classType, fieldName), e);
            }
        }
        return field2;
    }

    @NotNull
    public static Field getField(@NotNull Class<?> classType, @NotNull String fieldName) throws NoSuchFieldException {
        String canonicalName = classType.getCanonicalName();
        String key = canonicalName + "." + fieldName;
        Field field2 = null;
        Map<String, Field> classFieldsCache = fieldsLookupCache.get(classType);
        if (classFieldsCache != null) {
            field2 = classFieldsCache.get(key);
        } else {
            classFieldsCache = new HashMap<String, Field>(1);
            fieldsLookupCache.put(classType, classFieldsCache);
        }
        if (field2 == null) {
            field2 = ReflectUtils.getFieldImpl(classType, fieldName);
            if (field2 == null) {
                field2 = ReflectUtils.getInterfaceFieldImpl(classType, fieldName);
            }
            if (field2 == null) {
                String msg = "Field '%s' not found in class: %s";
                throw new NoSuchFieldException(String.format("Field '%s' not found in class: %s", fieldName, canonicalName));
            }
            field2.setAccessible(true);
            classFieldsCache.put(key, field2);
        }
        return field2;
    }

    private static Field getFieldImpl(Class classType, String fieldName) {
        Field field2;
        try {
            field2 = classType.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Class superclass = classType.getSuperclass();
            field2 = superclass != null ? ReflectUtils.getFieldImpl(superclass, fieldName) : null;
        }
        return field2;
    }

    private static Field getInterfaceFieldImpl(Class classType, String fieldName) {
        AnnotatedElement field2 = null;
        if (classType.isInterface()) {
            Field[] fields = classType.getDeclaredFields();
            for (AnnotatedElement annotatedElement : fields) {
                if (!((Field)annotatedElement).getName().equals(fieldName)) continue;
                field2 = annotatedElement;
                break;
            }
        }
        if (field2 == null) {
            AnnotatedElement annotatedElement;
            Class<?>[] interfaces = classType.getInterfaces();
            AnnotatedElement[] annotatedElementArray = interfaces;
            int n = annotatedElementArray.length;
            for (int i = 0; i < n && (field2 = ReflectUtils.getInterfaceFieldImpl((Class)(annotatedElement = annotatedElementArray[i]), fieldName)) == null; ++i) {
            }
        }
        if (field2 == null) {
            Class superclass = classType.getSuperclass();
            field2 = superclass != null ? ReflectUtils.getInterfaceFieldImpl(superclass, fieldName) : null;
        }
        return field2;
    }

    public static Class<?> getFieldTypeSafely(Class classType, String fieldName) {
        try {
            return ReflectUtils.getFieldType(classType, fieldName);
        }
        catch (NoSuchFieldException e) {
            if (safeMethodsLoggingEnabled) {
                String msg = "ReflectionUtils method failed: getFieldTypeSafely ( %s, %s )";
                LoggerFactory.getLogger(ReflectUtils.class).error(String.format("ReflectionUtils method failed: getFieldTypeSafely ( %s, %s )", classType, fieldName), e);
            }
            return null;
        }
    }

    public static Class<?> getFieldType(Class classType, String fieldName) throws NoSuchFieldException {
        return ReflectUtils.getField(classType, fieldName).getType();
    }

    public static boolean setFieldValueSafely(Object object, String field2, Object value) {
        try {
            ReflectUtils.setFieldValue(object, field2, value);
            return true;
        }
        catch (Exception e) {
            if (safeMethodsLoggingEnabled) {
                String msg = "ReflectionUtils method failed: setFieldValueSafely";
                LoggerFactory.getLogger(ReflectUtils.class).error("ReflectionUtils method failed: setFieldValueSafely", e);
            }
            return false;
        }
    }

    public static void setFieldValue(Object object, String fieldName, Object value) throws NoSuchFieldException, IllegalAccessException {
        Field actualField = ReflectUtils.getField(object.getClass(), fieldName);
        ReflectUtils.setFieldValue(object, actualField, value);
    }

    public static boolean setStaticFieldValueSafely(Class classType, String field2, Object value) {
        try {
            ReflectUtils.setStaticFieldValue(classType, field2, value);
            return true;
        }
        catch (Exception e) {
            if (safeMethodsLoggingEnabled) {
                String msg = "ReflectionUtils method failed: setFieldValueSafely";
                LoggerFactory.getLogger(ReflectUtils.class).error("ReflectionUtils method failed: setFieldValueSafely", e);
            }
            return false;
        }
    }

    public static void setStaticFieldValue(Class classType, String fieldName, Object value) throws NoSuchFieldException, IllegalAccessException {
        Field actualField = ReflectUtils.getField(classType, fieldName);
        ReflectUtils.setFieldValue(null, actualField, value);
    }

    public static boolean setFieldValueSafely(Object object, Field field2, Object value) {
        try {
            ReflectUtils.setFieldValue(object, field2, value);
            return true;
        }
        catch (Exception e) {
            if (safeMethodsLoggingEnabled) {
                String msg = "ReflectionUtils method failed: setFieldValueSafely";
                LoggerFactory.getLogger(ReflectUtils.class).error("ReflectionUtils method failed: setFieldValueSafely", e);
            }
            return false;
        }
    }

    public static void setFieldValue(Object object, Field field2, Object value) throws IllegalAccessException {
        int oldModifiers;
        if (!field2.isAccessible()) {
            field2.setAccessible(true);
        }
        if (ModifierType.FINAL.is(oldModifiers = field2.getModifiers())) {
            FieldHelper.setFieldModifiers(field2, oldModifiers & 0xFFFFFFEF);
        }
        field2.set(object, value);
        if (ModifierType.FINAL.is(oldModifiers)) {
            FieldHelper.setFieldModifiers(field2, oldModifiers);
        }
    }

    public static <T> T getFieldValueSafely(Object object, String fieldName) {
        try {
            return ReflectUtils.getFieldValue(object, fieldName);
        }
        catch (Exception e) {
            if (safeMethodsLoggingEnabled) {
                String msg = "ReflectionUtils method failed: getFieldValueSafely";
                LoggerFactory.getLogger(ReflectUtils.class).error("ReflectionUtils method failed: getFieldValueSafely", e);
            }
            return null;
        }
    }

    public static <T> T getFieldValue(Object object, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field actualField = ReflectUtils.getField(object.getClass(), fieldName);
        ModifierType.STATIC.checkNot(actualField);
        return (T)actualField.get(object);
    }

    public static <T> T getStaticFieldValueSafely(Class classType, String fieldName) {
        try {
            return ReflectUtils.getStaticFieldValue(classType, fieldName);
        }
        catch (Exception e) {
            if (safeMethodsLoggingEnabled) {
                String msg = "ReflectionUtils method failed: getStaticFieldValueSafely";
                LoggerFactory.getLogger(ReflectUtils.class).error("ReflectionUtils method failed: getStaticFieldValueSafely", e);
            }
            return null;
        }
    }

    public static <T> T getStaticFieldValue(Class classType, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Field actualField = ReflectUtils.getField(classType, fieldName);
        ModifierType.STATIC.check(actualField);
        return (T)actualField.get(null);
    }

    @NotNull
    public static String getJavaClassName(@NotNull Object classObject) {
        return ReflectUtils.getJavaClassName(classObject.getClass());
    }

    @NotNull
    public static String getJavaClassName(@NotNull Class classType) {
        return ReflectUtils.getClassName(classType) + ".java";
    }

    @NotNull
    public static String getClassFileName(@NotNull Object classObject) {
        return ReflectUtils.getClassFileName(classObject.getClass());
    }

    @NotNull
    public static String getClassFileName(@NotNull Class classType) {
        return ReflectUtils.getClassName(classType) + ".class";
    }

    @NotNull
    public static String getClassName(@NotNull Object classObject) {
        return ReflectUtils.getClassName(classObject.getClass());
    }

    @NotNull
    public static String getClassName(@NotNull Class classType) {
        String canonicalName = classType.getCanonicalName();
        String fullName = canonicalName != null ? canonicalName : classType.toString();
        int dot = fullName.lastIndexOf(".");
        return dot != -1 ? fullName.substring(dot + 1) : fullName;
    }

    @NotNull
    public static String getCompleteClassName(@NotNull Object classObject) {
        return ReflectUtils.getCompleteClassName(classObject.getClass());
    }

    @NotNull
    public static String getCompleteClassName(@NotNull Class classType) {
        String name = ReflectUtils.getClassName(classType);
        Class<?> enclosingClass = classType.getEnclosingClass();
        return enclosingClass != null ? ReflectUtils.getCompleteClassName(enclosingClass) + "$" + name : name;
    }

    public static String[] getClassPackages(Object classObject) {
        return ReflectUtils.getClassPackages(classObject.getClass());
    }

    public static String[] getClassPackages(Class classType) {
        return ReflectUtils.getPackages(classType.getPackage().getName());
    }

    public static String[] getPackages(String packageName) {
        return packageName.split("\\.");
    }

    public static <T> T createInstanceSafely(String canonicalClassName, Object ... arguments) {
        try {
            return ReflectUtils.createInstance(canonicalClassName, arguments);
        }
        catch (Exception e) {
            if (safeMethodsLoggingEnabled) {
                String msg = "ReflectionUtils method failed: createInstanceSafely";
                LoggerFactory.getLogger(ReflectUtils.class).error("ReflectionUtils method failed: createInstanceSafely", e);
            }
            return null;
        }
    }

    public static <T> T createInstance(String canonicalClassName, Object ... arguments) throws ClassNotFoundException, InvocationTargetException, IllegalAccessException, InstantiationException, NoSuchMethodException {
        return ReflectUtils.createInstance(ReflectUtils.loadClass(canonicalClassName), arguments);
    }

    public static <T> T createInstanceSafely(Class theClass, Object ... arguments) {
        try {
            return ReflectUtils.createInstance(theClass, arguments);
        }
        catch (Exception e) {
            if (safeMethodsLoggingEnabled) {
                String msg = "ReflectionUtils method failed: createInstanceSafely";
                LoggerFactory.getLogger(ReflectUtils.class).error("ReflectionUtils method failed: createInstanceSafely", e);
            }
            return null;
        }
    }

    public static <T> T createInstance(Class theClass, Object ... arguments) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class[] parameterTypes = ReflectUtils.getClassTypes(arguments);
        Constructor constructor = ReflectUtils.getConstructor(theClass, parameterTypes);
        return constructor.newInstance(arguments);
    }

    public static Constructor getConstructor(Class theClass, Class ... parameterTypes) throws NoSuchMethodException {
        if (theClass.isMemberClass() && ModifierType.STATIC.not(theClass)) {
            if (parameterTypes.length == 0) {
                throw new ReflectionException("Enclosing class paramter for inner class constructor is missing");
            }
            if (!ReflectUtils.isAssignable(theClass.getEnclosingClass(), parameterTypes[0])) {
                throw new ReflectionException("Incorrect first parameter for inner class constructor");
            }
        }
        for (Constructor<?> constructor : theClass.getDeclaredConstructors()) {
            Class<?>[] types = constructor.getParameterTypes();
            if (types.length != parameterTypes.length) continue;
            if (types.length == 0) {
                constructor.setAccessible(true);
                return constructor;
            }
            boolean fits = true;
            for (int i = 0; i < types.length; ++i) {
                if (ReflectUtils.isAssignable(types[i], parameterTypes[i])) continue;
                fits = false;
                break;
            }
            if (!fits) continue;
            constructor.setAccessible(true);
            return constructor;
        }
        throw new NoSuchMethodException("Constructor was not found: " + theClass.getCanonicalName() + ReflectUtils.argumentTypesToString(parameterTypes));
    }

    public static <T> T callStaticMethodSafely(String canonicalClassName, String methodName, Object ... arguments) {
        try {
            return ReflectUtils.callStaticMethod(canonicalClassName, methodName, arguments);
        }
        catch (Exception e) {
            if (safeMethodsLoggingEnabled) {
                String msg = "ReflectionUtils method failed: callStaticMethodSafely";
                LoggerFactory.getLogger(ReflectUtils.class).error("ReflectionUtils method failed: callStaticMethodSafely", e);
            }
            return null;
        }
    }

    public static <T> T callStaticMethod(String canonicalClassName, String methodName, Object ... arguments) throws ClassNotFoundException, InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        return ReflectUtils.callStaticMethod(ReflectUtils.getClass(canonicalClassName), methodName, arguments);
    }

    public static <T> T callStaticMethodSafely(Class theClass, String methodName, Object ... arguments) {
        try {
            return ReflectUtils.callStaticMethod(theClass, methodName, arguments);
        }
        catch (Exception e) {
            if (safeMethodsLoggingEnabled) {
                String msg = "ReflectionUtils method failed: callStaticMethodSafely";
                LoggerFactory.getLogger(ReflectUtils.class).error("ReflectionUtils method failed: callStaticMethodSafely", e);
            }
            return null;
        }
    }

    public static <T> T callStaticMethod(Class theClass, String methodName, Object ... arguments) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = ReflectUtils.getMethod(theClass, methodName, arguments);
        return (T)method.invoke(null, arguments);
    }

    @NotNull
    public static <T> List<T> callMethodsSafely(@NotNull List<?> objects, @NotNull String methodName, Object ... arguments) {
        ArrayList<T> results = new ArrayList<T>();
        for (Object object : objects) {
            try {
                results.add(ReflectUtils.callMethod(object, methodName, arguments));
            }
            catch (Exception e) {
                if (safeMethodsLoggingEnabled) {
                    String msg = "ReflectionUtils method failed: callMethodsSafely:callMethod";
                    LoggerFactory.getLogger(ReflectUtils.class).error("ReflectionUtils method failed: callMethodsSafely:callMethod", e);
                }
                results.add(null);
            }
        }
        return results;
    }

    @NotNull
    public static <T> List<T> callMethods(@NotNull List<?> objects, @NotNull String methodName, Object ... arguments) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ArrayList<T> results = new ArrayList<T>();
        for (Object object : objects) {
            results.add(ReflectUtils.callMethod(object, methodName, arguments));
        }
        return results;
    }

    @NotNull
    public static Object[] callMethodsSafely(@NotNull Object[] objects, @NotNull String methodName, Object ... arguments) {
        Object[] results = new Object[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            try {
                results[i] = ReflectUtils.callMethod(objects[i], methodName, arguments);
                continue;
            }
            catch (Exception e) {
                if (safeMethodsLoggingEnabled) {
                    String msg = "ReflectionUtils method failed: callMethodsSafely:callMethod";
                    LoggerFactory.getLogger(ReflectUtils.class).error("ReflectionUtils method failed: callMethodsSafely:callMethod", e);
                }
                results[i] = null;
            }
        }
        return results;
    }

    @NotNull
    public static Object[] callMethods(@NotNull Object[] objects, @NotNull String methodName, Object ... arguments) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Object[] results = new Object[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            results[i] = ReflectUtils.callMethod(objects[i], methodName, arguments);
        }
        return results;
    }

    @Nullable
    public static <T> T callMethodSafely(@NotNull Object object, @NotNull String methodName, Object ... arguments) {
        T result2;
        try {
            result2 = ReflectUtils.callMethod(object, methodName, arguments);
        }
        catch (Exception e) {
            if (safeMethodsLoggingEnabled) {
                String msg = "ReflectionUtils method failed: callMethodSafely";
                LoggerFactory.getLogger(ReflectUtils.class).error("ReflectionUtils method failed: callMethodSafely", e);
            }
            result2 = null;
        }
        return result2;
    }

    @Nullable
    public static <T> T callMethod(@NotNull Object object, @NotNull String methodName, Object ... arguments) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = ReflectUtils.getMethod(object.getClass(), methodName, arguments);
        return (T)method.invoke(object, arguments);
    }

    public static Method getFieldGetter(Object object, String field2) {
        return ReflectUtils.getFieldGetter(object.getClass(), field2);
    }

    public static Method getFieldGetter(Class aClass, String field2) {
        Method get2 = ReflectUtils.getMethodSafely(aClass, ReflectUtils.getGetterMethodName(field2), new Object[0]);
        if (get2 != null) {
            return get2;
        }
        return ReflectUtils.getMethodSafely(aClass, ReflectUtils.getIsGetterMethodName(field2), new Object[0]);
    }

    public static String getSetterMethodName(String field2) {
        return "set" + field2.substring(0, 1).toUpperCase(Locale.ROOT) + field2.substring(1);
    }

    public static String getGetterMethodName(String field2) {
        return "get" + field2.substring(0, 1).toUpperCase(Locale.ROOT) + field2.substring(1);
    }

    public static String getIsGetterMethodName(String field2) {
        return "is" + field2.substring(0, 1).toUpperCase(Locale.ROOT) + field2.substring(1);
    }

    public static boolean hasMethod(@NotNull Object object, @NotNull String methodName, Object ... arguments) {
        return ReflectUtils.hasMethod(object.getClass(), methodName, arguments);
    }

    public static boolean hasMethod(@NotNull Class aClass, @NotNull String methodName, Object ... arguments) {
        boolean result2;
        try {
            result2 = ReflectUtils.getMethod(aClass, methodName, arguments) != null;
        }
        catch (Exception e) {
            result2 = false;
        }
        return result2;
    }

    public static Method getMethodSafely(Object object, String methodName, Object ... arguments) {
        return ReflectUtils.getMethodSafely(object.getClass(), methodName, arguments);
    }

    public static Method getMethodSafely(Class aClass, String methodName, Object ... arguments) {
        try {
            return ReflectUtils.getMethod(aClass, methodName, arguments);
        }
        catch (Exception e) {
            if (safeMethodsLoggingEnabled) {
                String msg = "ReflectionUtils method failed: getMethodSafely";
                LoggerFactory.getLogger(ReflectUtils.class).error("ReflectionUtils method failed: getMethodSafely", e);
            }
            return null;
        }
    }

    public static Method getMethod(Object object, String methodName, Object ... arguments) throws NoSuchMethodException {
        return ReflectUtils.getMethod(object.getClass(), methodName, arguments);
    }

    public static Method getMethod(@NotNull Class aClass, @NotNull String methodName, Object ... arguments) throws NoSuchMethodException {
        Class[] classTypes = ReflectUtils.getClassTypes(arguments);
        String key = aClass.getCanonicalName() + "." + methodName + ReflectUtils.argumentTypesToString(classTypes);
        Method method = null;
        Map<String, Method> classMethodsCache = methodsLookupCache.get(aClass);
        if (classMethodsCache != null) {
            method = classMethodsCache.get(key);
        } else {
            classMethodsCache = new HashMap<String, Method>(1);
            methodsLookupCache.put(aClass, classMethodsCache);
        }
        if (method == null) {
            method = ReflectUtils.getMethodImpl(aClass, methodName, arguments);
            classMethodsCache.put(key, method);
        }
        return method;
    }

    private static Method getMethodImpl(Class aClass, String methodName, Object[] arguments) throws NoSuchMethodException {
        Class[] types = ReflectUtils.getClassTypes(arguments);
        return ReflectUtils.getMethodImpl(aClass, aClass, methodName, types);
    }

    private static Method getMethodImpl(Class topClass, Class currentClass, String methodName, Class[] types) throws NoSuchMethodException {
        for (Method method : currentClass.getDeclaredMethods()) {
            Class<?>[] mt;
            if (!method.getName().equals(methodName) || (mt = method.getParameterTypes()).length != types.length) continue;
            boolean fits = true;
            for (int i = 0; i < mt.length; ++i) {
                if (ReflectUtils.isAssignable(mt[i], types[i])) continue;
                fits = false;
                break;
            }
            if (!fits) continue;
            method.setAccessible(true);
            return method;
        }
        Class superclass = currentClass.getSuperclass();
        if (superclass != null) {
            return ReflectUtils.getMethodImpl(topClass, superclass, methodName, types);
        }
        throw new NoSuchMethodException("Method was not found: " + topClass.getCanonicalName() + "." + methodName + ReflectUtils.argumentTypesToString(types));
    }

    private static String argumentTypesToString(Class[] argTypes) {
        StringBuilder buf2 = new StringBuilder("(");
        if (argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                Class c;
                if (i > 0) {
                    buf2.append(", ");
                }
                buf2.append((c = argTypes[i]) == null ? "null" : c.getCanonicalName());
            }
        }
        return buf2.append(")").toString();
    }

    public static <T extends Cloneable> T clone(T object) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (T)(object != null ? (Cloneable)ReflectUtils.callMethod(object, "clone", new Object[0]) : null);
    }

    public static <T extends Cloneable> T cloneSafely(T object) {
        return (T)(object != null ? (Cloneable)ReflectUtils.callMethodSafely(object, "clone", new Object[0]) : null);
    }

    public static Class loadClass(String canonicalClassName) throws ClassNotFoundException {
        return ReflectUtils.class.getClassLoader().loadClass(canonicalClassName);
    }

    public static Class[] getClassTypes(@NotNull Object[] arguments) {
        Class[] parameterTypes = new Class[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            parameterTypes[i] = arguments[i] != null ? arguments[i].getClass() : null;
        }
        return parameterTypes;
    }

    public static boolean isAssignable(Class type, Class from) {
        if (from == null) {
            return !type.isPrimitive();
        }
        if (type.isAssignableFrom(from)) {
            return true;
        }
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                return Boolean.class.isAssignableFrom(from);
            }
            if (type == Integer.TYPE) {
                return Integer.class.isAssignableFrom(from);
            }
            if (type == Character.TYPE) {
                return Character.class.isAssignableFrom(from);
            }
            if (type == Byte.TYPE) {
                return Byte.class.isAssignableFrom(from);
            }
            if (type == Short.TYPE) {
                return Short.class.isAssignableFrom(from);
            }
            if (type == Long.TYPE) {
                return Long.class.isAssignableFrom(from);
            }
            if (type == Float.TYPE) {
                return Float.class.isAssignableFrom(from);
            }
            if (type == Double.TYPE) {
                return Double.class.isAssignableFrom(from);
            }
            if (type == Void.TYPE) {
                return Void.class.isAssignableFrom(from);
            }
        }
        return false;
    }

    public static boolean isPrimitive(Object object) {
        return ReflectUtils.isPrimitive(object.getClass());
    }

    public static boolean isPrimitive(Class<?> type) {
        return type.isPrimitive() || Boolean.class.isAssignableFrom(type) || Character.class.isAssignableFrom(type) || Byte.class.isAssignableFrom(type) || Short.class.isAssignableFrom(type) || Integer.class.isAssignableFrom(type) || Long.class.isAssignableFrom(type) || Float.class.isAssignableFrom(type) || Double.class.isAssignableFrom(type) || Void.class.isAssignableFrom(type);
    }

    public static Object getDefaultPrimitiveValue(Class<?> type) {
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                return false;
            }
            if (type == Integer.TYPE) {
                return 0;
            }
            if (type == Character.TYPE) {
                return Character.valueOf('\u0000');
            }
            if (type == Byte.TYPE) {
                return (byte)0;
            }
            if (type == Short.TYPE) {
                return (short)0;
            }
            if (type == Long.TYPE) {
                return 0L;
            }
            if (type == Float.TYPE) {
                return Float.valueOf(0.0f);
            }
            if (type == Double.TYPE) {
                return 0.0;
            }
            throw new IllegalArgumentException("Unknown primitive type: " + type);
        }
        throw new IllegalArgumentException("Type is not primitive: " + type);
    }

    public static boolean containsInClassOrSuperclassName(Class theClass, String text) {
        if (theClass == null) {
            return false;
        }
        String name = theClass.getCanonicalName();
        if (name != null) {
            return name.contains(text) || ReflectUtils.containsInClassOrSuperclassName(theClass.getSuperclass(), text);
        }
        return ReflectUtils.containsInClassOrSuperclassName(theClass.getSuperclass(), text);
    }

    public static Class getClosestSuperclass(Object object1, Object object2) {
        return ReflectUtils.getClosestSuperclass(object1.getClass(), object2.getClass());
    }

    public static Class getClosestSuperclass(Class class1, Class class2) {
        if (class1.isAssignableFrom(class2)) {
            return class1;
        }
        if (class2.isAssignableFrom(class1)) {
            return class2;
        }
        Class super1 = class1.getSuperclass();
        Class super2 = class2.getSuperclass();
        return ReflectUtils.getClosestSuperclass(super1, super2);
    }
}

