/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.ImageUtils;
import com.alee.utils.UtilityException;
import com.alee.utils.system.JavaVersion;
import com.alee.utils.system.SystemType;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.slf4j.LoggerFactory;

public final class SystemUtils {
    @Nullable
    private static JavaVersion javaVersion;
    @NotNull
    private static final String osName;
    @NotNull
    private static final SystemType osType;
    @Nullable
    private static Cursor transparentCursor;

    private SystemUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    public static void copyToClipboard(@Nullable String text) {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(text), null);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(SystemUtils.class).error(e.toString(), e);
        }
    }

    @Nullable
    public static String getStringFromClipboard() {
        String string = null;
        Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        if (t != null && t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                string = (String)t.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string;
    }

    @NotNull
    public static String getJavaVersionString() {
        return System.getProperty("java.version");
    }

    @NotNull
    public static JavaVersion getJavaVersion() {
        if (javaVersion == null) {
            javaVersion = new JavaVersion();
        }
        return javaVersion;
    }

    public static boolean isJavaVersionOrAbove(double version) {
        return SystemUtils.isJavaVersionOrAbove(version, 0, 0);
    }

    public static boolean isJavaVersionOrAbove(double version, int update) {
        return SystemUtils.isJavaVersionOrAbove(version, 0, update);
    }

    public static boolean isJavaVersionOrAbove(double major, int minor, int update) {
        return SystemUtils.getJavaVersion().compareTo(major, minor, update) >= 0;
    }

    public static boolean isJava6orAbove() {
        return SystemUtils.isJavaVersionOrAbove(1.6);
    }

    public static boolean isJava7orAbove() {
        return SystemUtils.isJavaVersionOrAbove(1.7);
    }

    public static boolean isJava8orAbove() {
        return SystemUtils.isJavaVersionOrAbove(1.8);
    }

    public static boolean isJava9orAbove() {
        return SystemUtils.isJavaVersionOrAbove(9.0);
    }

    public static boolean isJava10orAbove() {
        return SystemUtils.isJavaVersionOrAbove(10.0);
    }

    @NotNull
    public static String getJavaName() {
        return System.getProperty("java.vm.name");
    }

    @NotNull
    public static String getJavaVendor() {
        return System.getProperty("java.vm.vendor");
    }

    @NotNull
    public static Icon getOsIcon() {
        return SystemUtils.getOsIcon(true);
    }

    @NotNull
    public static Icon getOsIcon(boolean color) {
        return SystemUtils.getOsIcon(16, color);
    }

    @NotNull
    public static Icon getOsIcon(int size) {
        return SystemUtils.getOsIcon(size, true);
    }

    @NotNull
    public static Icon getOsIcon(int size, boolean color) {
        String os = SystemUtils.getShortOsName();
        int iconSize = Objects.equals((Object)size, 16, 32) ? size : 16;
        String mark = color ? "_colored" : "";
        String path = "icons/os/" + iconSize + "/" + os + mark + ".png";
        return new ImageIcon(SystemUtils.class.getResource(path));
    }

    @NotNull
    public static SystemType getOsType() {
        return osType;
    }

    public static boolean isWindows() {
        return osType == SystemType.WINDOWS;
    }

    public static boolean isMac() {
        return osType == SystemType.MAC;
    }

    public static boolean isUnix() {
        return osType == SystemType.UNIX;
    }

    public static boolean isSolaris() {
        return osType == SystemType.SOLARIS;
    }

    @NotNull
    public static String getOsArch() {
        return ManagementFactory.getOperatingSystemMXBean().getArch();
    }

    @NotNull
    public static String getOsName() {
        return osName;
    }

    @NotNull
    public static String getShortOsName() {
        return osType.shortName();
    }

    @NotNull
    public static String getOsSite() {
        String site = SystemUtils.isWindows() ? "http://www.microsoft.com/" : (SystemUtils.isMac() ? "http://www.apple.com/" : (SystemUtils.isSolaris() ? "http://www.oracle.com/" : "http://www.unix.org/"));
        return site;
    }

    @NotNull
    public static String getOsVersion() {
        return ManagementFactory.getOperatingSystemMXBean().getVersion();
    }

    public static int getOsProcessors() {
        return ManagementFactory.getOperatingSystemMXBean().getAvailableProcessors();
    }

    @NotNull
    public static String getJreArch() {
        return SystemUtils.getJreArchName().contains("64") ? "64" : "32";
    }

    @NotNull
    public static String getJreArchName() {
        return System.getProperty("sun.arch.data.model");
    }

    public static boolean isCapsLock() {
        return Toolkit.getDefaultToolkit().getLockingKeyState(20);
    }

    public static boolean isNumLock() {
        return Toolkit.getDefaultToolkit().getLockingKeyState(144);
    }

    public static boolean isScrollLock() {
        return Toolkit.getDefaultToolkit().getLockingKeyState(145);
    }

    @NotNull
    public static GraphicsEnvironment getGraphicsEnvironment() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment();
    }

    public static boolean isHeadlessEnvironment() {
        return GraphicsEnvironment.isHeadless();
    }

    @NotNull
    public static GraphicsDevice getDefaultScreenDevice() {
        return SystemUtils.getGraphicsEnvironment().getDefaultScreenDevice();
    }

    @NotNull
    public static GraphicsConfiguration getGraphicsConfiguration() {
        return SystemUtils.getDefaultScreenDevice().getDefaultConfiguration();
    }

    @NotNull
    public static List<GraphicsDevice> getGraphicsDevices() {
        GraphicsDevice[] screenDevices = SystemUtils.getGraphicsEnvironment().getScreenDevices();
        GraphicsDevice defaultScreenDevice = SystemUtils.getDefaultScreenDevice();
        ArrayList<GraphicsDevice> devices = new ArrayList<GraphicsDevice>();
        for (GraphicsDevice gd : screenDevices) {
            if (gd.getType() != 0) continue;
            if (gd == defaultScreenDevice) {
                devices.add(0, gd);
                continue;
            }
            devices.add(gd);
        }
        return devices;
    }

    @NotNull
    public static GraphicsDevice getGraphicsDevice(@Nullable Window window) {
        return window != null ? window.getGraphicsConfiguration().getDevice() : SystemUtils.getDefaultScreenDevice();
    }

    @NotNull
    public static GraphicsDevice getGraphicsDevice(@NotNull Point location) {
        GraphicsDevice graphicsDevice = null;
        for (GraphicsDevice device : SystemUtils.getGraphicsDevices()) {
            if (!device.getDefaultConfiguration().getBounds().contains(location)) continue;
            graphicsDevice = device;
            break;
        }
        if (graphicsDevice == null) {
            graphicsDevice = SystemUtils.getDefaultScreenDevice();
        }
        return graphicsDevice;
    }

    @NotNull
    public static GraphicsDevice getGraphicsDevice(@NotNull Rectangle bounds) {
        int maxArea = 0;
        GraphicsDevice device = null;
        for (GraphicsDevice gd : SystemUtils.getGraphicsDevices()) {
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            Rectangle sb = gc.getBounds();
            if (!bounds.intersects(sb)) continue;
            Rectangle intersection = bounds.intersection(sb);
            int s = intersection.width * intersection.height;
            if (maxArea >= s) continue;
            maxArea = s;
            device = gd;
        }
        return device != null ? device : SystemUtils.getDefaultScreenDevice();
    }

    @NotNull
    public static Rectangle getDeviceBounds(@Nullable GraphicsDevice device, boolean applyScreenInsets) {
        return SystemUtils.getDeviceBounds(device != null ? device.getDefaultConfiguration() : SystemUtils.getGraphicsConfiguration(), applyScreenInsets);
    }

    @NotNull
    public static Rectangle getDeviceBounds(@Nullable GraphicsConfiguration gc, boolean applyScreenInsets) {
        GraphicsConfiguration conf = gc != null ? gc : SystemUtils.getGraphicsConfiguration();
        Rectangle bounds = conf.getBounds();
        if (applyScreenInsets) {
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(conf);
            bounds.x += insets.left;
            bounds.y += insets.top;
            bounds.width -= insets.left + insets.right;
            bounds.height -= insets.top + insets.bottom;
        }
        return bounds;
    }

    @NotNull
    public static List<Rectangle> getDevicesBounds(boolean applyScreenInsets) {
        List<GraphicsDevice> devices = SystemUtils.getGraphicsDevices();
        ArrayList<Rectangle> bounds = new ArrayList<Rectangle>(devices.size());
        for (GraphicsDevice device : devices) {
            bounds.add(SystemUtils.getDeviceBounds(device, applyScreenInsets));
        }
        return bounds;
    }

    @NotNull
    public static Rectangle getDeviceBounds(@NotNull Point location, boolean applyScreenInsets) {
        GraphicsDevice device = SystemUtils.getGraphicsDevice(location);
        return SystemUtils.getDeviceBounds(device, applyScreenInsets);
    }

    @NotNull
    public static Rectangle getDeviceBounds(@NotNull Rectangle bounds, boolean applyScreenInsets) {
        GraphicsDevice device = SystemUtils.getGraphicsDevice(bounds);
        return SystemUtils.getDeviceBounds(device, applyScreenInsets);
    }

    @NotNull
    public static Rectangle getDeviceBounds(@NotNull Component component2, boolean applyScreenInsets) {
        Rectangle bounds = CoreSwingUtils.getBoundsOnScreen(component2, true);
        return SystemUtils.getDeviceBounds(bounds, applyScreenInsets);
    }

    @NotNull
    public static Rectangle getMaximizedBounds(@NotNull Frame frame) {
        GraphicsConfiguration gc = frame.getGraphicsConfiguration();
        Rectangle max = SystemUtils.getDeviceBounds(gc, true);
        Rectangle b = SystemUtils.getDeviceBounds(gc, false);
        return new Rectangle(max.x - b.x, max.y - b.y, max.width, max.height);
    }

    @NotNull
    public static Rectangle getMaximizedWestBounds(@NotNull Frame frame) {
        Rectangle b = SystemUtils.getMaximizedBounds(frame);
        return new Rectangle(b.x, b.y, b.width / 2, b.height);
    }

    @NotNull
    public static Rectangle getMaximizedEastBounds(@NotNull Frame frame) {
        Rectangle b = SystemUtils.getMaximizedBounds(frame);
        return new Rectangle(b.x + b.width - b.width / 2, b.y, b.width / 2, b.height);
    }

    public static boolean isFrameStateSupported(int state) {
        return Toolkit.getDefaultToolkit().isFrameStateSupported(state);
    }

    @NotNull
    public static Cursor getTransparentCursor() {
        if (transparentCursor == null) {
            Dimension d = Toolkit.getDefaultToolkit().getBestCursorSize(16, 16);
            BufferedImage image = ImageUtils.createCompatibleImage(d.width, d.height, 3);
            transparentCursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), "transparent");
        }
        return transparentCursor;
    }

    static {
        osName = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("os.name");
            }
        });
        String lc = osName.toLowerCase(Locale.ROOT);
        osType = lc.contains("win") ? SystemType.WINDOWS : (lc.contains("mac") || lc.contains("darwin") ? SystemType.MAC : (lc.contains("nix") || lc.contains("nux") ? SystemType.UNIX : (lc.contains("sunos") ? SystemType.SOLARIS : SystemType.UNKNOWN)));
    }
}

