/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.utils.UtilityException;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class WebUtils {
    private WebUtils() {
        throw new UtilityException("Utility classes are not meant to be instantiated");
    }

    @NotNull
    public static String normalizeUrl(@NotNull String url2) {
        try {
            return new URI(url2).normalize().toASCIIString();
        }
        catch (URISyntaxException e) {
            throw new UtilityException("Unable to normalize URL: " + url2, e);
        }
    }

    @NotNull
    public static Map<String, List<String>> getUrlParameters(@NotNull String url2) {
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        String[] urlParts = url2.split("\\?");
        if (urlParts.length > 1) {
            String query2 = urlParts[1];
            for (String param2 : query2.split("&")) {
                ArrayList<String> values2;
                String[] pair = param2.split("=");
                String key = WebUtils.decodeUrl(pair[0]);
                String value = "";
                if (pair.length > 1) {
                    value = WebUtils.decodeUrl(pair[1]);
                }
                if ((values2 = (ArrayList<String>)params.get(key)) == null) {
                    values2 = new ArrayList<String>();
                    params.put(key, values2);
                }
                values2.add(value);
            }
        }
        return params;
    }

    @NotNull
    public static String encodeUrl(@NotNull String url2) {
        try {
            URL u = new URL(url2);
            URI uri = new URI(u.getProtocol(), u.getHost(), u.getPath(), u.getQuery(), null);
            return uri.toASCIIString();
        }
        catch (Exception e) {
            throw new UtilityException("Unable to encore URL: " + url2, e);
        }
    }

    @NotNull
    public static String decodeUrl(@NotNull String url2) {
        try {
            return URLDecoder.decode(url2, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UtilityException("Unable to decode URL: " + url2, e);
        }
    }

    public static void browseSite(@NotNull String address) throws URISyntaxException, IOException {
        Desktop.getDesktop().browse(new URI(address));
    }

    public static void browseSiteSafely(@NotNull String address) {
        try {
            WebUtils.browseSite(address);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void shareOnTwitter(final @NotNull String address) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                WebUtils.browseSiteSafely("http://twitter.com/intent/tweet?text=" + address);
            }
        }).start();
    }

    public static void shareOnVk(final @NotNull String address) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                WebUtils.browseSiteSafely("http://vkontakte.ru/share.php?url=" + address);
            }
        }).start();
    }

    public static void shareOnFb(final @NotNull String address) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                WebUtils.browseSiteSafely("http://www.facebook.com/sharer.php?u=" + address);
            }
        }).start();
    }

    public static void openFile(@NotNull File file) throws IOException {
        Desktop.getDesktop().open(file);
    }

    public static void openFileSafely(@NotNull File file) {
        try {
            WebUtils.openFile(file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void writeEmail(@NotNull String email) throws URISyntaxException, IOException {
        WebUtils.writeEmail(email, null, null);
    }

    public static void writeEmail(@NotNull String email, @Nullable String subject, @Nullable String body) throws URISyntaxException, IOException {
        URI uri;
        if (!email.startsWith("mailto:")) {
            email = "mailto:" + email;
        }
        if (subject != null && body != null) {
            subject = subject.replaceAll(" ", "%20");
            body = body.replaceAll(" ", "%20");
            uri = new URI(email + "?subject=" + subject + "&body=" + body);
        } else {
            uri = new URI(email);
        }
        Desktop.getDesktop().mail(uri);
    }

    public static void writeEmailSafely(@NotNull String email) {
        try {
            WebUtils.writeEmail(email);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void writeEmailSafely(@NotNull String email, @Nullable String subject, @Nullable String body) {
        try {
            WebUtils.writeEmail(email, subject, body);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

