/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.collection;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.Objects;
import com.alee.utils.ArrayUtils;
import com.alee.utils.array.ArrayIterator;
import com.alee.utils.array.ArrayListIterator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ImmutableList<E>
implements List<E>,
Cloneable,
Serializable {
    @NotNull
    protected final E[] data;

    public ImmutableList(E ... data) {
        this.data = data;
    }

    public ImmutableList(@NotNull Collection<? extends E> collection) {
        this.data = collection.toArray();
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public boolean isEmpty() {
        return this.data.length == 0;
    }

    @Override
    public boolean contains(@Nullable Object element) {
        return ArrayUtils.contains(element, this.data);
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.data;
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] array) {
        int size = this.size();
        if (array.length < this.size()) {
            return Arrays.copyOf(this.data, size, this.data.getClass());
        }
        System.arraycopy(this.data, 0, array, 0, size);
        if (array.length > size) {
            array[size] = null;
        }
        return array;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return new ArrayIterator((Object[])this.data){

            @Override
            public void remove() {
                throw ImmutableList.this.createModificationException();
            }
        };
    }

    @Override
    public boolean add(@Nullable E element) {
        throw this.createModificationException();
    }

    @Override
    public boolean remove(@Nullable Object element) {
        throw this.createModificationException();
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> collection) {
        for (Object element : collection) {
            if (ArrayUtils.contains(element, this.data)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> collection) {
        throw this.createModificationException();
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> collection) {
        throw this.createModificationException();
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> collection) {
        throw this.createModificationException();
    }

    @Override
    public void clear() {
        throw this.createModificationException();
    }

    @Override
    @Nullable
    public E get(int index) {
        return this.data[index];
    }

    @Override
    @Nullable
    public E set(int index, @Nullable E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, @Nullable E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(@Nullable Object o) {
        return ArrayUtils.indexOf(o, this.data);
    }

    @Override
    public int lastIndexOf(@Nullable Object o) {
        return ArrayUtils.lastIndexOf(o, this.data);
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator(int index) {
        return new ArrayListIterator<E>((Object[])this.data){

            @Override
            public void set(E e) {
                throw ImmutableList.this.createModificationException();
            }

            @Override
            public void add(E e) {
                throw ImmutableList.this.createModificationException();
            }
        };
    }

    @Override
    @NotNull
    public List<E> subList(int fromIndex, int toIndex) {
        return new ImmutableList<E>(Arrays.copyOfRange(this.data, fromIndex, toIndex));
    }

    @NotNull
    protected UnsupportedOperationException createModificationException() {
        return new UnsupportedOperationException("ImmutableList is unmodifiable");
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.data);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ImmutableList) {
            ImmutableList other = (ImmutableList)o;
            return Arrays.equals(this.data, other.data);
        }
        return false;
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + Arrays.toString(this.data);
    }
}

