/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.file;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Locale;

public class FileNameComparator
implements Comparator<String>,
Serializable {
    @Override
    public int compare(String name1, String name2) {
        if (name1 != null && name2 != null) {
            String lower1 = name1.toLowerCase(Locale.ROOT);
            String lower2 = name2.toLowerCase(Locale.ROOT);
            int thisMarker = 0;
            int thatMarker = 0;
            int s1Length = lower1.length();
            int s2Length = lower2.length();
            while (thisMarker < s1Length && thatMarker < s2Length) {
                int result2;
                String thisChunk = this.getChunk(lower1, s1Length, thisMarker);
                thisMarker += thisChunk.length();
                String thatChunk = this.getChunk(lower2, s2Length, thatMarker);
                thatMarker += thatChunk.length();
                if (this.isDigit(thisChunk.charAt(0)) && this.isDigit(thatChunk.charAt(0))) {
                    int thisChunkLength = thisChunk.length();
                    result2 = thisChunkLength - thatChunk.length();
                    if (result2 == 0) {
                        for (int i = 0; i < thisChunkLength; ++i) {
                            result2 = thisChunk.charAt(i) - thatChunk.charAt(i);
                            if (result2 == 0) continue;
                            return result2;
                        }
                    }
                } else {
                    result2 = thisChunk.compareTo(thatChunk);
                }
                if (result2 == 0) continue;
                return result2;
            }
            return s1Length - s2Length;
        }
        return 0;
    }

    protected String getChunk(String name, int slength, int marker) {
        StringBuilder chunk = new StringBuilder();
        char c = name.charAt(marker);
        chunk.append(c);
        ++marker;
        if (this.isDigit(c)) {
            while (marker < slength && this.isDigit(c = name.charAt(marker))) {
                chunk.append(c);
                ++marker;
            }
        } else {
            while (marker < slength && !this.isDigit(c = name.charAt(marker))) {
                chunk.append(c);
                ++marker;
            }
        }
        return chunk.toString();
    }

    protected boolean isDigit(char character) {
        return character >= '0' && character <= '9';
    }
}

