/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.filefilter;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.ui.RenderingParameters;
import com.alee.utils.filefilter.AbstractFileFilter;
import com.alee.utils.filefilter.FilterGroupType;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;

public class GroupedFileFilter
extends AbstractFileFilter {
    protected FilterGroupType filterGroupType;
    protected AbstractFileFilter defaultFilter;
    protected List<FileFilter> filters;

    public GroupedFileFilter(FileFilter ... filters) {
        this(FilterGroupType.AND, filters);
    }

    public GroupedFileFilter(FilterGroupType filterGroupType, FileFilter ... filters) {
        this(filters != null && filters.length > 0 && filters[0] instanceof AbstractFileFilter ? (AbstractFileFilter)filters[0] : null, filterGroupType, filters);
    }

    public GroupedFileFilter(AbstractFileFilter defaultFilter, FilterGroupType filterGroupType, FileFilter ... filters) {
        this.filterGroupType = filterGroupType;
        this.defaultFilter = defaultFilter;
        this.filters = new ArrayList<FileFilter>();
        if (filters != null) {
            Collections.addAll(this.filters, filters);
        }
    }

    @Override
    @Nullable
    public Icon getIcon(@NotNull RenderingParameters parameters) {
        return this.defaultFilter != null ? this.defaultFilter.getIcon(parameters) : null;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.defaultFilter != null ? this.defaultFilter.getDescription() : null;
    }

    @Override
    public boolean accept(@NotNull File file) {
        boolean accepted;
        if (this.filterGroupType.equals((Object)FilterGroupType.AND)) {
            accepted = true;
            for (FileFilter filter2 : this.filters) {
                if (filter2 == null || filter2.accept(file)) continue;
                accepted = false;
                break;
            }
        } else {
            accepted = false;
            for (FileFilter filter3 : this.filters) {
                if (filter3 != null && !filter3.accept(file)) continue;
                accepted = true;
                break;
            }
        }
        return accepted;
    }
}

