/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import com.alee.utils.ReflectUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javax.swing.UIDefaults;

public final class SwingLazyValue
implements UIDefaults.LazyValue {
    private final String className;
    private final String methodName;
    private final Object[] arguments;

    public SwingLazyValue(String className) {
        this(className, (String)null);
    }

    public SwingLazyValue(String className, String methodName) {
        this(className, methodName, null);
    }

    public SwingLazyValue(String className, Object[] arguments) {
        this(className, null, arguments);
    }

    public SwingLazyValue(String className, String methodName, Object[] arguments) {
        this.className = className;
        this.methodName = methodName;
        this.arguments = arguments != null ? (Object[])arguments.clone() : null;
    }

    @Override
    public Object createValue(UIDefaults table2) {
        Object value = null;
        try {
            Class<?> clazz = Class.forName(this.className, true, null);
            if (this.methodName != null) {
                Method m = ReflectUtils.getMethod(clazz, this.methodName, this.arguments);
                value = m.invoke(clazz, this.arguments);
            } else {
                Class[] types = ReflectUtils.getClassTypes(this.arguments);
                Constructor constructor = ReflectUtils.getConstructor(clazz, types);
                value = constructor.newInstance(this.arguments);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return value;
    }
}

