/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import com.alee.api.annotations.NotNull;
import com.alee.utils.CollectionUtils;
import com.alee.utils.ReflectUtils;
import com.alee.utils.swing.ButtonGroupListener;
import java.awt.Component;
import java.awt.Container;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.event.EventListenerList;

public class UnselectableButtonGroup
extends ButtonGroup {
    @NotNull
    protected final EventListenerList listeners = new EventListenerList();
    protected boolean unselectable;

    public UnselectableButtonGroup() {
    }

    public UnselectableButtonGroup(AbstractButton ... buttons) {
        this(true);
        this.add(buttons);
    }

    public UnselectableButtonGroup(@NotNull List<AbstractButton> buttons) {
        this(true);
        this.add(buttons);
    }

    public UnselectableButtonGroup(@NotNull Container container) {
        this(true);
        this.add(container);
    }

    public UnselectableButtonGroup(boolean unselectable) {
        this.setUnselectable(unselectable);
    }

    @NotNull
    public List<AbstractButton> getButtons() {
        return CollectionUtils.copy(this.buttons);
    }

    public void add(AbstractButton ... buttons) {
        for (AbstractButton button : buttons) {
            this.add(button);
        }
    }

    public void add(@NotNull List<AbstractButton> buttons) {
        for (AbstractButton button : buttons) {
            this.add(button);
        }
    }

    public void add(@NotNull Container container) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component2 = container.getComponent(i);
            if (!(component2 instanceof AbstractButton)) continue;
            this.add((AbstractButton)component2);
        }
    }

    public void removeAll() {
        for (int i = this.buttons.size() - 1; i >= 0; --i) {
            AbstractButton b = (AbstractButton)this.buttons.get(i);
            this.buttons.remove(i);
            b.getModel().setGroup(null);
        }
        ReflectUtils.setFieldValueSafely((Object)this, "selection", null);
    }

    public boolean isUnselectable() {
        return this.unselectable;
    }

    public void setUnselectable(boolean unselectable) {
        this.unselectable = unselectable;
    }

    @Override
    public void setSelected(@NotNull ButtonModel model, boolean selected) {
        if (selected != model.isSelected()) {
            if (selected || !this.unselectable) {
                super.setSelected(model, selected);
            } else {
                this.clearSelection();
            }
            this.fireSelectionChanged();
        }
    }

    public void addButtonGroupListener(@NotNull ButtonGroupListener listener) {
        this.listeners.add(ButtonGroupListener.class, listener);
    }

    public void removeButtonGroupListener(@NotNull ButtonGroupListener listener) {
        this.listeners.remove(ButtonGroupListener.class, listener);
    }

    public void fireSelectionChanged() {
        for (ButtonGroupListener listener : (ButtonGroupListener[])this.listeners.getListeners(ButtonGroupListener.class)) {
            listener.selectionChanged();
        }
    }

    @NotNull
    public static UnselectableButtonGroup group(AbstractButton ... buttons) {
        return new UnselectableButtonGroup(buttons);
    }

    @NotNull
    public static UnselectableButtonGroup group(@NotNull List<AbstractButton> buttons) {
        return new UnselectableButtonGroup(buttons);
    }

    @NotNull
    public static UnselectableButtonGroup group(@NotNull Container container) {
        return new UnselectableButtonGroup(container);
    }
}

