/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.api.jdk.BiConsumer;
import com.alee.api.jdk.BiFunction;
import com.alee.api.jdk.BiPredicate;
import com.alee.api.jdk.Function;
import com.alee.utils.collection.ImmutableSet;
import com.alee.utils.collection.WeakHashSet;
import java.util.Set;
import javax.swing.JComponent;

public class WeakComponentData<C extends JComponent, D> {
    @NotNull
    protected final String key;
    @NotNull
    protected final Set<C> components;

    public WeakComponentData(@NotNull String key, int initialCapacity) {
        this.key = key;
        this.components = new WeakHashSet<C>(initialCapacity);
    }

    @NotNull
    public synchronized Set<C> components() {
        return new ImmutableSet<C>(this.components);
    }

    public synchronized int size() {
        return this.components.size();
    }

    public synchronized boolean contains(@NotNull C component2) {
        return this.components.contains(component2);
    }

    @Nullable
    public synchronized D get(@NotNull C component2) {
        return (D)((JComponent)component2).getClientProperty(this.key);
    }

    @NotNull
    public synchronized D get(@NotNull C component2, @NotNull Function<C, D> defaultData) {
        D data = this.get(component2);
        if (data == null) {
            data = defaultData.apply(component2);
            this.set(component2, data);
        }
        return data;
    }

    @NotNull
    public synchronized D modify(@NotNull C component2, @NotNull BiFunction<C, D, D> modifiedData, @NotNull Function<C, D> defaultData) {
        D data = this.get(component2);
        if (data == null) {
            data = defaultData.apply(component2);
            this.set(component2, data);
        } else {
            data = modifiedData.apply(component2, data);
            this.set(component2, data);
        }
        return data;
    }

    @Nullable
    public synchronized D set(@NotNull C component2, @Nullable D data) {
        D oldData = this.get(component2);
        if (data != null) {
            ((JComponent)component2).putClientProperty(this.key, data);
            this.components.add(component2);
        } else {
            this.clear(component2);
        }
        return oldData;
    }

    @Nullable
    public synchronized D set(@NotNull C component2, @Nullable D data, @NotNull BiConsumer<C, D> oldDataConsumer) {
        D oldData;
        if (this.contains(component2)) {
            oldData = this.get(component2);
            oldDataConsumer.accept(component2, this.get(component2));
        } else {
            oldData = null;
        }
        if (data != null) {
            this.set(component2, data);
        } else {
            this.clear(component2, oldDataConsumer);
        }
        return oldData;
    }

    @Nullable
    public synchronized D clear(@NotNull C component2) {
        D oldData = this.get(component2);
        ((JComponent)component2).putClientProperty(this.key, null);
        this.components.remove(component2);
        return oldData;
    }

    @Nullable
    public synchronized D clear(@NotNull C component2, @NotNull BiConsumer<C, D> removedDataConsumer) {
        Object oldData;
        if (this.contains(component2)) {
            oldData = this.get(component2);
            removedDataConsumer.accept(component2, oldData);
            this.clear(component2);
        } else {
            oldData = null;
        }
        return (D)oldData;
    }

    public synchronized void forEach(@NotNull BiConsumer<C, D> consumer) {
        for (JComponent component2 : this.components()) {
            D data = this.get(component2);
            consumer.accept(component2, data);
        }
    }

    public synchronized boolean anyMatch(@NotNull BiPredicate<C, D> predicate) {
        boolean anyMatch = false;
        for (JComponent component2 : this.components()) {
            if (!predicate.test(component2, this.get(component2))) continue;
            anyMatch = true;
            break;
        }
        return anyMatch;
    }

    public synchronized boolean allMatch(@NotNull BiPredicate<C, D> predicate) {
        boolean allMatch = true;
        for (JComponent component2 : this.components()) {
            if (predicate.test(component2, this.get(component2))) continue;
            allMatch = false;
            break;
        }
        return allMatch;
    }

    public synchronized boolean noneMatch(@NotNull BiPredicate<C, D> predicate) {
        boolean noneMatch = true;
        for (JComponent component2 : this.components()) {
            if (!predicate.test(component2, this.get(component2))) continue;
            noneMatch = false;
            break;
        }
        return noneMatch;
    }
}

