/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import com.alee.api.annotations.NotNull;
import com.alee.api.jdk.BiConsumer;
import com.alee.api.jdk.BiPredicate;
import com.alee.utils.CollectionUtils;
import com.alee.utils.swing.WeakComponentData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;

public class WeakComponentDataList<C extends JComponent, E>
extends WeakComponentData<C, List<E>> {
    public WeakComponentDataList(@NotNull String key, int initialCapacity) {
        super(key, initialCapacity);
    }

    public synchronized int size(@NotNull C component2) {
        List list = (List)this.get(component2);
        return list != null ? list.size() : 0;
    }

    public synchronized boolean containsData(@NotNull C component2) {
        return CollectionUtils.notEmpty((Collection)this.get(component2));
    }

    public synchronized boolean containsData(@NotNull C component2, @NotNull E data) {
        List list = (List)this.get(component2);
        return list != null && list.contains(data);
    }

    public synchronized void add(@NotNull C component2, @NotNull E data) {
        ArrayList<E> list = (ArrayList<E>)this.get(component2);
        if (list == null) {
            list = new ArrayList<E>(1);
            this.set(component2, list);
        }
        list.add(data);
    }

    public synchronized void remove(@NotNull C component2, @NotNull E data) {
        List list = (List)this.get(component2);
        if (list != null) {
            list.remove(data);
            if (list.size() == 0) {
                this.clear(component2);
            }
        }
    }

    public synchronized void remove(@NotNull C component2, @NotNull E data, @NotNull BiConsumer<C, E> removedDataConsumer) {
        List list = (List)this.get(component2);
        if (list != null && list.contains(data)) {
            removedDataConsumer.accept(component2, data);
            list.remove(data);
            if (list.size() == 0) {
                this.clear(component2);
            }
        }
    }

    public synchronized void forEachData(@NotNull BiConsumer<C, E> consumer) {
        for (JComponent component2 : this.components()) {
            this.forEachData(component2, consumer);
        }
    }

    public synchronized void forEachData(@NotNull C component2, @NotNull BiConsumer<C, E> consumer) {
        List dataList = (List)this.get(component2);
        if (dataList != null) {
            for (Object data : dataList) {
                consumer.accept(component2, data);
            }
        }
    }

    public synchronized boolean anyDataMatch(@NotNull BiPredicate<C, E> predicate) {
        boolean anyDataMatch = false;
        for (JComponent component2 : this.components()) {
            if (!this.anyDataMatch(component2, predicate)) continue;
            anyDataMatch = true;
            break;
        }
        return anyDataMatch;
    }

    public synchronized boolean anyDataMatch(@NotNull C component2, @NotNull BiPredicate<C, E> predicate) {
        boolean anyDataMatch = false;
        List dataList = (List)this.get(component2);
        if (dataList != null) {
            for (Object data : dataList) {
                if (!predicate.test(component2, data)) continue;
                anyDataMatch = true;
                break;
            }
        }
        return anyDataMatch;
    }

    public synchronized boolean allDataMatch(@NotNull BiPredicate<C, E> predicate) {
        boolean allDataMatch = true;
        for (JComponent component2 : this.components()) {
            if (this.allDataMatch(component2, predicate)) continue;
            allDataMatch = false;
            break;
        }
        return allDataMatch;
    }

    public synchronized boolean allDataMatch(@NotNull C component2, @NotNull BiPredicate<C, E> predicate) {
        boolean allDataMatch = true;
        List dataList = (List)this.get(component2);
        if (dataList != null) {
            for (Object data : dataList) {
                if (predicate.test(component2, data)) continue;
                allDataMatch = false;
                break;
            }
        }
        return allDataMatch;
    }

    public synchronized boolean noneDataMatch(@NotNull BiPredicate<C, E> predicate) {
        boolean noneDataMatch = true;
        for (JComponent component2 : this.components()) {
            if (this.noneDataMatch(component2, predicate)) continue;
            noneDataMatch = false;
            break;
        }
        return noneDataMatch;
    }

    public synchronized boolean noneDataMatch(@NotNull C component2, @NotNull BiPredicate<C, E> predicate) {
        boolean noneDataMatch = true;
        List dataList = (List)this.get(component2);
        if (dataList != null) {
            for (Object data : dataList) {
                if (!predicate.test(component2, data)) continue;
                noneDataMatch = false;
                break;
            }
        }
        return noneDataMatch;
    }
}

