/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.utils.CollectionUtils;
import com.alee.utils.CoreSwingUtils;
import com.alee.utils.TimeUtils;
import com.alee.utils.parsing.DurationUnits;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.event.EventListenerList;

public class WebTimer
implements Serializable {
    public static String defaultThreadName = "WebTimer";
    public static int defaultCyclesLimit = 0;
    public static boolean useEdtByDefault = true;
    protected long delay;
    protected long initialDelay;
    protected boolean repeats = true;
    protected boolean coalesce = true;
    protected boolean useEventDispatchThread = true;
    protected boolean useDaemonThread = false;
    protected boolean nonBlockingStop = false;
    @NotNull
    protected String actionCommand = "";
    @NotNull
    protected String name;
    protected int cyclesLimit;
    protected final EventListenerList listeners;
    protected transient int id;
    protected transient int lastId;
    @NotNull
    protected final transient Map<Integer, Boolean> running;
    protected transient long sleepStart;
    protected transient long sleepTime;
    protected transient int cycleCount;
    @Nullable
    protected transient Thread exec;

    public WebTimer(@NotNull String delay) {
        this(DurationUnits.get().fromString(delay));
    }

    public WebTimer(long delay) {
        this(defaultThreadName, delay);
    }

    public WebTimer(@NotNull String name, @NotNull String delay) {
        this(name, DurationUnits.get().fromString(delay));
    }

    public WebTimer(@NotNull String name, long delay) {
        this(name, delay, null);
    }

    public WebTimer(long delay, long initialDelay) {
        this(defaultThreadName, delay, initialDelay);
    }

    public WebTimer(@NotNull String name, long delay, long initialDelay) {
        this(name, delay, initialDelay, null);
    }

    public WebTimer(@NotNull String delay, @Nullable ActionListener listener) {
        this(DurationUnits.get().fromString(delay), listener);
    }

    public WebTimer(long delay, @Nullable ActionListener listener) {
        this(defaultThreadName, delay, listener);
    }

    public WebTimer(@NotNull String name, @NotNull String delay, @Nullable ActionListener listener) {
        this(name, DurationUnits.get().fromString(delay), listener);
    }

    public WebTimer(@NotNull String name, long delay, @Nullable ActionListener listener) {
        this(name, delay, -1L, listener);
    }

    public WebTimer(long delay, long initialDelay, @Nullable ActionListener listener) {
        this(defaultThreadName, delay, initialDelay, listener);
    }

    public WebTimer(@NotNull String name, String delay, @NotNull String initialDelay, @Nullable ActionListener listener) {
        this(name, DurationUnits.get().fromString(delay), DurationUnits.get().fromString(initialDelay), listener);
    }

    public WebTimer(@NotNull String name, long delay, long initialDelay, @Nullable ActionListener listener) {
        this.name = name;
        this.cyclesLimit = 0;
        this.listeners = new EventListenerList();
        this.id = 0;
        this.lastId = -1;
        this.running = new Hashtable<Integer, Boolean>();
        this.sleepStart = 0L;
        this.sleepTime = 0L;
        this.cycleCount = 0;
        this.exec = null;
        this.setDelay(delay);
        this.setInitialDelay(initialDelay);
        if (listener != null) {
            this.addActionListener(listener);
        }
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    @NotNull
    public String getInitialStringDelay() {
        return DurationUnits.get().toString(this.initialDelay);
    }

    @NotNull
    public WebTimer setInitialDelay(@NotNull String initialDelay) {
        this.setInitialDelay(DurationUnits.get().fromString(initialDelay));
        return this;
    }

    @NotNull
    public WebTimer setInitialDelay(long initialDelay) {
        if (initialDelay != -1L && initialDelay < 0L) {
            throw new IllegalArgumentException("Invalid initial delay: " + initialDelay);
        }
        this.initialDelay = initialDelay;
        return this;
    }

    public long getDelay() {
        return this.delay;
    }

    @NotNull
    public String getStringDelay() {
        return DurationUnits.get().toString(this.delay);
    }

    @NotNull
    public WebTimer setDelay(@NotNull String delay) {
        this.setDelay(DurationUnits.get().fromString(delay));
        return this;
    }

    @NotNull
    public WebTimer setDelay(long delay) {
        if (delay < 0L) {
            throw new IllegalArgumentException("Invalid delay: " + delay);
        }
        this.delay = delay;
        return this;
    }

    public boolean isRepeats() {
        return this.repeats;
    }

    @NotNull
    public WebTimer setRepeats(boolean repeats) {
        this.repeats = repeats;
        return this;
    }

    public boolean isCoalesce() {
        return this.coalesce;
    }

    @NotNull
    public WebTimer setCoalesce(boolean coalesce) {
        this.coalesce = coalesce;
        return this;
    }

    public boolean isUseEventDispatchThread() {
        return this.useEventDispatchThread;
    }

    @NotNull
    public WebTimer setUseEventDispatchThread(boolean useEventDispatchThread) {
        this.useEventDispatchThread = useEventDispatchThread;
        return this;
    }

    public boolean isUseDaemonThread() {
        return this.useDaemonThread;
    }

    @NotNull
    public WebTimer setUseDaemonThread(boolean useDaemonThread) {
        this.useDaemonThread = useDaemonThread;
        return this;
    }

    public boolean isNonBlockingStop() {
        return this.nonBlockingStop;
    }

    @NotNull
    public WebTimer setNonBlockingStop(boolean nonBlockingStop) {
        this.nonBlockingStop = nonBlockingStop;
        return this;
    }

    @NotNull
    public String getActionCommand() {
        return this.actionCommand;
    }

    @NotNull
    public WebTimer setActionCommand(@NotNull String actionCommand) {
        this.actionCommand = actionCommand;
        return this;
    }

    public int getCyclesLimit() {
        return this.cyclesLimit;
    }

    @NotNull
    public WebTimer setCyclesLimit(int cyclesLimit) {
        this.cyclesLimit = cyclesLimit;
        return this;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public WebTimer setName(@NotNull String name) {
        this.name = name;
        if (this.exec != null) {
            this.exec.setName(name);
        }
        return this;
    }

    public long getCycleTimePassed() {
        return System.currentTimeMillis() - this.sleepStart;
    }

    public long getCycleTimeLeft() {
        return this.sleepTime - this.getCycleTimePassed();
    }

    public int getCycleCount() {
        return this.cycleCount;
    }

    public int getCycleNumber() {
        return this.cycleCount + 1;
    }

    public boolean isLastCycle() {
        return this.getCyclesLimit() > 0 && this.getCycleNumber() == this.getCyclesLimit();
    }

    @NotNull
    public WebTimer start() {
        this.startExec();
        return this;
    }

    @NotNull
    public WebTimer stop() {
        this.stopExec();
        return this;
    }

    @NotNull
    public WebTimer restart() {
        this.stopExec();
        this.startExec();
        return this;
    }

    @NotNull
    public WebTimer restart(long delay) {
        this.stopExec();
        this.setInitialDelay(delay);
        this.setDelay(delay);
        this.startExec();
        return this;
    }

    @NotNull
    public WebTimer restart(long initialDelay, long delay) {
        this.stopExec();
        this.setInitialDelay(initialDelay);
        this.setDelay(delay);
        this.startExec();
        return this;
    }

    @NotNull
    public WebTimer restart(@NotNull String delay) {
        this.stopExec();
        this.setInitialDelay(delay);
        this.setDelay(delay);
        this.startExec();
        return this;
    }

    @NotNull
    public WebTimer restart(@NotNull String initialDelay, @NotNull String delay) {
        this.stopExec();
        this.setInitialDelay(initialDelay);
        this.setDelay(delay);
        this.startExec();
        return this;
    }

    public synchronized boolean isRunning() {
        return this.exec != null && this.exec.isAlive();
    }

    protected synchronized void startExec() {
        if (!this.isRunning()) {
            final int currentId = this.lastId = this.id++;
            this.exec = new Thread(new Runnable(){

                @Override
                public void run() {
                    block6: {
                        WebTimer.this.setAlive(currentId, true);
                        try {
                            long actualInitialDelay;
                            long l2 = actualInitialDelay = WebTimer.this.getInitialDelay() < 0L ? WebTimer.this.getDelay() : WebTimer.this.getInitialDelay();
                            if (actualInitialDelay > 0L) {
                                WebTimer.this.sleepStart = System.currentTimeMillis();
                                WebTimer.this.sleepTime = actualInitialDelay;
                                Thread.sleep(actualInitialDelay);
                            }
                            if (!WebTimer.this.shouldContinue(-1, currentId)) break block6;
                            WebTimer.this.cycleCount = 0;
                            if (WebTimer.this.repeats) {
                                while (WebTimer.this.shouldContinue(WebTimer.this.cycleCount, currentId)) {
                                    WebTimer.this.fireActionPerformed(currentId);
                                    ++WebTimer.this.cycleCount;
                                    if (WebTimer.this.shouldContinue(WebTimer.this.cycleCount, currentId)) {
                                        if (WebTimer.this.getDelay() <= 0L) continue;
                                        long currentDelay = WebTimer.this.getDelay();
                                        WebTimer.this.sleepStart = System.currentTimeMillis();
                                        WebTimer.this.sleepTime = currentDelay;
                                        Thread.sleep(currentDelay);
                                        continue;
                                    }
                                    break block6;
                                }
                                break block6;
                            }
                            WebTimer.this.fireActionPerformed(currentId);
                            ++WebTimer.this.cycleCount;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    WebTimer.this.cleanUp(currentId);
                }
            }, this.name);
            this.exec.setDaemon(this.useDaemonThread);
            this.exec.start();
        }
    }

    protected boolean shouldContinue(int cycle, int id) {
        return this.running.get(id) != false && !Thread.currentThread().isInterrupted() && (this.cyclesLimit <= 0 || this.cyclesLimit > cycle);
    }

    protected void setAlive(int id, boolean alive) {
        this.running.put(id, alive);
    }

    protected void cleanUp(int id) {
        this.running.remove(id);
    }

    protected synchronized void stopExec() {
        if (this.exec != null && this.isRunning()) {
            this.exec.interrupt();
            this.setAlive(this.lastId, false);
            if (!this.nonBlockingStop) {
                try {
                    this.exec.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @NotNull
    public WebTimer addActionListener(@NotNull ActionListener listener) {
        this.listeners.add(ActionListener.class, listener);
        return this;
    }

    @NotNull
    public WebTimer removeActionListener(@NotNull ActionListener listener) {
        this.listeners.remove(ActionListener.class, listener);
        return this;
    }

    @NotNull
    public List<ActionListener> getListeners() {
        return CollectionUtils.asList(this.listeners.getListeners(ActionListener.class));
    }

    public void fireActionPerformed(int id) {
        block2: {
            ActionEvent actionEvent;
            ActionListener[] listenerList;
            block3: {
                block4: {
                    if (this.listeners.getListenerCount(ActionListener.class) <= 0) break block2;
                    listenerList = (ActionListener[])this.listeners.getListeners(ActionListener.class);
                    actionEvent = this.createActionEvent();
                    if (!this.useEventDispatchThread) break block3;
                    if (!this.coalesce) break block4;
                    if (!this.shouldContinue(this.cycleCount, id)) break block2;
                    CoreSwingUtils.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            for (ActionListener listener : listenerList) {
                                listener.actionPerformed(actionEvent);
                            }
                        }
                    }, true);
                    break block2;
                }
                for (final ActionListener listener : listenerList) {
                    if (!this.shouldContinue(this.cycleCount, id)) continue;
                    CoreSwingUtils.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            listener.actionPerformed(actionEvent);
                        }
                    }, true);
                }
                break block2;
            }
            for (ActionListener listener : listenerList) {
                listener.actionPerformed(actionEvent);
            }
        }
    }

    @NotNull
    protected ActionEvent createActionEvent() {
        return new ActionEvent(this, 0, this.actionCommand, TimeUtils.currentTime(), 0);
    }

    @NotNull
    public String toString() {
        return this.name + ", delay (" + this.getStringDelay() + "), initialDelay (" + this.getInitialStringDelay() + ")";
    }

    public static WebTimer delay(@NotNull String delay, @Nullable ActionListener listener) {
        return WebTimer.delay(DurationUnits.get().fromString(delay), listener);
    }

    public static WebTimer delay(long delay, @Nullable ActionListener listener) {
        return WebTimer.delay(defaultThreadName, delay, listener);
    }

    public static WebTimer delay(@NotNull String name, @NotNull String delay, @Nullable ActionListener listener) {
        return WebTimer.delay(name, DurationUnits.get().fromString(delay), listener);
    }

    public static WebTimer delay(@NotNull String name, long delay, @Nullable ActionListener listener) {
        return WebTimer.delay(name, delay, true, listener);
    }

    public static WebTimer delay(@NotNull String delay, boolean useEventDispatchThread, @Nullable ActionListener listener) {
        return WebTimer.delay(DurationUnits.get().fromString(delay), useEventDispatchThread, listener);
    }

    public static WebTimer delay(long delay, boolean useEventDispatchThread, @Nullable ActionListener listener) {
        return WebTimer.delay(defaultThreadName, delay, useEventDispatchThread, listener);
    }

    public static WebTimer delay(@NotNull String name, @NotNull String delay, boolean useEventDispatchThread, @Nullable ActionListener listener) {
        return WebTimer.delay(name, DurationUnits.get().fromString(delay), useEventDispatchThread, listener);
    }

    public static WebTimer delay(@NotNull String name, long delay, boolean useEventDispatchThread, @Nullable ActionListener listener) {
        WebTimer once = new WebTimer(name, delay, listener);
        once.setRepeats(false);
        once.setUseEventDispatchThread(useEventDispatchThread);
        once.start();
        return once;
    }

    public static WebTimer repeat(@NotNull String delay, @Nullable ActionListener listener) {
        long pd = DurationUnits.get().fromString(delay);
        return WebTimer.repeat(defaultThreadName, pd, pd, defaultCyclesLimit, useEdtByDefault, listener);
    }

    public static WebTimer repeat(@NotNull String delay, int cyclesLimit, @Nullable ActionListener listener) {
        long pd = DurationUnits.get().fromString(delay);
        return WebTimer.repeat(defaultThreadName, pd, pd, cyclesLimit, useEdtByDefault, listener);
    }

    public static WebTimer repeat(long delay, @Nullable ActionListener listener) {
        return WebTimer.repeat(defaultThreadName, delay, delay, defaultCyclesLimit, useEdtByDefault, listener);
    }

    public static WebTimer repeat(long delay, int cyclesLimit, @Nullable ActionListener listener) {
        return WebTimer.repeat(defaultThreadName, delay, delay, cyclesLimit, useEdtByDefault, listener);
    }

    public static WebTimer repeat(@NotNull String name, @NotNull String delay, @Nullable ActionListener listener) {
        long pd = DurationUnits.get().fromString(delay);
        return WebTimer.repeat(name, pd, pd, defaultCyclesLimit, useEdtByDefault, listener);
    }

    public static WebTimer repeat(@NotNull String name, String delay, int cyclesLimit, @Nullable ActionListener listener) {
        long pd = DurationUnits.get().fromString(delay);
        return WebTimer.repeat(name, pd, pd, cyclesLimit, useEdtByDefault, listener);
    }

    public static WebTimer repeat(@NotNull String name, long delay, @Nullable ActionListener listener) {
        return WebTimer.repeat(name, delay, delay, defaultCyclesLimit, useEdtByDefault, listener);
    }

    public static WebTimer repeat(@NotNull String name, long delay, int cyclesLimit, @Nullable ActionListener listener) {
        return WebTimer.repeat(name, delay, delay, cyclesLimit, useEdtByDefault, listener);
    }

    public static WebTimer repeat(@NotNull String delay, boolean useEventDispatchThread, @Nullable ActionListener listener) {
        long pd = DurationUnits.get().fromString(delay);
        return WebTimer.repeat(defaultThreadName, pd, pd, defaultCyclesLimit, useEventDispatchThread, listener);
    }

    public static WebTimer repeat(@NotNull String delay, int cyclesLimit, boolean useEventDispatchThread, @Nullable ActionListener listener) {
        long pd = DurationUnits.get().fromString(delay);
        return WebTimer.repeat(defaultThreadName, pd, pd, cyclesLimit, useEventDispatchThread, listener);
    }

    public static WebTimer repeat(long delay, boolean useEventDispatchThread, @Nullable ActionListener listener) {
        return WebTimer.repeat(defaultThreadName, delay, delay, defaultCyclesLimit, useEventDispatchThread, listener);
    }

    public static WebTimer repeat(long delay, int cyclesLimit, boolean useEventDispatchThread, @Nullable ActionListener listener) {
        return WebTimer.repeat(defaultThreadName, delay, delay, cyclesLimit, useEventDispatchThread, listener);
    }

    public static WebTimer repeat(@NotNull String name, @NotNull String delay, boolean useEventDispatchThread, @Nullable ActionListener listener) {
        long pd = DurationUnits.get().fromString(delay);
        return WebTimer.repeat(name, pd, pd, defaultCyclesLimit, useEventDispatchThread, listener);
    }

    public static WebTimer repeat(@NotNull String name, @NotNull String delay, int cyclesLimit, boolean useEventDispatchThread, @Nullable ActionListener listener) {
        long pd = DurationUnits.get().fromString(delay);
        return WebTimer.repeat(name, pd, pd, cyclesLimit, useEventDispatchThread, listener);
    }

    public static WebTimer repeat(@NotNull String name, long delay, boolean useEventDispatchThread, @Nullable ActionListener listener) {
        return WebTimer.repeat(name, delay, delay, defaultCyclesLimit, useEventDispatchThread, listener);
    }

    public static WebTimer repeat(@NotNull String name, long delay, int cyclesLimit, boolean useEventDispatchThread, @Nullable ActionListener listener) {
        return WebTimer.repeat(name, delay, delay, cyclesLimit, useEventDispatchThread, listener);
    }

    public static WebTimer repeat(long delay, long initialDelay, @Nullable ActionListener listener) {
        return WebTimer.repeat(defaultThreadName, delay, initialDelay, defaultCyclesLimit, useEdtByDefault, listener);
    }

    public static WebTimer repeat(long delay, long initialDelay, int cyclesLimit, @Nullable ActionListener listener) {
        return WebTimer.repeat(defaultThreadName, delay, initialDelay, cyclesLimit, useEdtByDefault, listener);
    }

    public static WebTimer repeat(@NotNull String name, long delay, long initialDelay, @Nullable ActionListener listener) {
        return WebTimer.repeat(name, delay, initialDelay, defaultCyclesLimit, useEdtByDefault, listener);
    }

    public static WebTimer repeat(@NotNull String name, long delay, long initialDelay, int cyclesLimit, @Nullable ActionListener listener) {
        return WebTimer.repeat(name, delay, initialDelay, cyclesLimit, useEdtByDefault, listener);
    }

    public static WebTimer repeat(long delay, long initialDelay, boolean useEventDispatchThread, @Nullable ActionListener listener) {
        return WebTimer.repeat(defaultThreadName, delay, initialDelay, defaultCyclesLimit, useEventDispatchThread, listener);
    }

    public static WebTimer repeat(long delay, long initialDelay, int cyclesLimit, boolean useEventDispatchThread, @Nullable ActionListener listener) {
        return WebTimer.repeat(defaultThreadName, delay, initialDelay, cyclesLimit, useEventDispatchThread, listener);
    }

    public static WebTimer repeat(@NotNull String name, long delay, long initialDelay, boolean useEventDispatchThread, @Nullable ActionListener listener) {
        return WebTimer.repeat(name, delay, initialDelay, defaultCyclesLimit, useEventDispatchThread, listener);
    }

    public static WebTimer repeat(@NotNull String name, long delay, long initialDelay, int cyclesLimit, boolean useEventDispatchThread, @Nullable ActionListener listener) {
        WebTimer repeat = new WebTimer(name, delay, initialDelay, listener);
        repeat.setRepeats(true);
        repeat.setUseEventDispatchThread(useEventDispatchThread);
        repeat.setCyclesLimit(cyclesLimit);
        repeat.start();
        return repeat;
    }

    public static WebTimer repeat(boolean useDaemonThread, @NotNull String name, long delay, @Nullable ActionListener listener) {
        return WebTimer.repeat(useDaemonThread, name, delay, delay, listener);
    }

    public static WebTimer repeat(boolean useDaemonThread, @NotNull String name, long delay, long initialDelay, @Nullable ActionListener listener) {
        return WebTimer.repeat(useDaemonThread, name, delay, initialDelay, defaultCyclesLimit, listener);
    }

    public static WebTimer repeat(boolean useDaemonThread, @NotNull String name, long delay, long initialDelay, int cyclesLimit, @Nullable ActionListener listener) {
        WebTimer repeat = new WebTimer(name, delay, initialDelay, listener);
        repeat.setRepeats(true);
        repeat.setUseDaemonThread(useDaemonThread);
        repeat.setUseEventDispatchThread(false);
        repeat.setCyclesLimit(cyclesLimit);
        repeat.start();
        return repeat;
    }
}

