/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing.extensions;

import com.alee.api.jdk.BiConsumer;
import com.alee.utils.SwingUtils;
import java.awt.Component;
import java.awt.Container;
import java.util.List;

public final class ContainerMethodsImpl {
    public static <C extends Container> boolean contains(C container, Component component2) {
        return component2 != null && component2.getParent() == container;
    }

    public static <C extends Container, T extends C> T add(C container, List<? extends Component> components, int index) {
        if (components != null) {
            int skipped = 0;
            for (int i = 0; i < components.size(); ++i) {
                Component component2 = components.get(i);
                if (component2 != null) {
                    container.add(component2, index + i - skipped);
                    continue;
                }
                ++skipped;
            }
        }
        return (T)container;
    }

    public static <C extends Container, T extends C> T add(C container, List<? extends Component> components, Object constraints) {
        if (components != null) {
            for (Component component2 : components) {
                if (component2 == null) continue;
                container.add(component2, constraints);
            }
        }
        return (T)container;
    }

    public static <C extends Container, T extends C> T add(C container, List<? extends Component> components) {
        if (components != null) {
            for (Component component2 : components) {
                if (component2 == null) continue;
                container.add(component2);
            }
        }
        return (T)container;
    }

    public static <C extends Container, T extends C> T add(C container, Component ... components) {
        if (components != null && components.length > 0) {
            for (Component component2 : components) {
                if (component2 == null) continue;
                container.add(component2);
            }
        }
        return (T)container;
    }

    public static <C extends Container, T extends C> T remove(C container, List<? extends Component> components) {
        if (components != null) {
            for (Component component2 : components) {
                if (component2 == null) continue;
                container.remove(component2);
            }
        }
        return (T)container;
    }

    public static <C extends Container, T extends C> T remove(C container, Component ... components) {
        if (components != null && components.length > 0) {
            for (Component component2 : components) {
                if (component2 == null) continue;
                container.remove(component2);
            }
        }
        return (T)container;
    }

    public static <C extends Container, T extends C> T removeAll(C container, Class<? extends Component> componentClass) {
        if (componentClass != null) {
            for (int i = 0; i < container.getComponentCount(); ++i) {
                Component component2 = container.getComponent(i);
                if (!componentClass.isAssignableFrom(component2.getClass())) continue;
                container.remove(component2);
            }
        }
        return (T)container;
    }

    public static <C extends Container> Component getFirstComponent(C container) {
        return container.getComponentCount() > 0 ? container.getComponent(0) : null;
    }

    public static <C extends Container> Component getLastComponent(C container) {
        return container.getComponentCount() > 0 ? container.getComponent(container.getComponentCount() - 1) : null;
    }

    public static <C extends Container, T extends C> T equalizeComponentsWidth(C container) {
        SwingUtils.equalizeComponentsWidth(container.getComponents());
        return (T)container;
    }

    public static <C extends Container, T extends C> T equalizeComponentsHeight(C container) {
        SwingUtils.equalizeComponentsHeight(container.getComponents());
        return (T)container;
    }

    public static <C extends Container, T extends C> T equalizeComponentsSize(C container) {
        SwingUtils.equalizeComponentsSize(container.getComponents());
        return (T)container;
    }

    public static <C extends Container, T extends C, V extends Component> T forEach(C container, BiConsumer<Integer, V> consumer) {
        int count = container.getComponentCount();
        for (int index = 0; index < count; ++index) {
            consumer.accept(index, container.getComponent(index));
        }
        return (T)container;
    }
}

