/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing.extensions;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.managers.hotkey.HotkeyData;
import com.alee.utils.GeometryUtils;
import com.alee.utils.SwingUtils;
import com.alee.utils.swing.MouseButton;
import com.alee.utils.swing.extensions.FocusEventRunnable;
import com.alee.utils.swing.extensions.KeyEventRunnable;
import com.alee.utils.swing.extensions.MouseEventRunnable;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public final class EventMethodsImpl {
    @NotNull
    public static MouseAdapter onMousePress(@NotNull Component component2, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMousePress(component2, null, runnable);
    }

    @NotNull
    public static MouseAdapter onMousePress(@NotNull Component component2, final @Nullable MouseButton mouseButton, final @NotNull MouseEventRunnable runnable) {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (mouseButton == null || mouseButton == MouseButton.get(e)) {
                    runnable.run(e);
                }
            }
        };
        component2.addMouseListener(mouseAdapter);
        return mouseAdapter;
    }

    @NotNull
    public static MouseAdapter onMouseEnter(@NotNull Component component2, final @NotNull MouseEventRunnable runnable) {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseEntered(@NotNull MouseEvent e) {
                runnable.run(e);
            }
        };
        component2.addMouseListener(mouseAdapter);
        return mouseAdapter;
    }

    @NotNull
    public static MouseAdapter onMouseExit(@NotNull Component component2, final @NotNull MouseEventRunnable runnable) {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseExited(@NotNull MouseEvent e) {
                runnable.run(e);
            }
        };
        component2.addMouseListener(mouseAdapter);
        return mouseAdapter;
    }

    @NotNull
    public static MouseAdapter onMouseDrag(@NotNull Component component2, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseDrag(component2, null, runnable);
    }

    @NotNull
    public static MouseAdapter onMouseDrag(@NotNull Component component2, final @Nullable MouseButton mouseButton, final @NotNull MouseEventRunnable runnable) {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseDragged(@NotNull MouseEvent e) {
                if (mouseButton == null || mouseButton == MouseButton.get(e)) {
                    runnable.run(e);
                }
            }
        };
        component2.addMouseMotionListener(mouseAdapter);
        return mouseAdapter;
    }

    @NotNull
    public static MouseAdapter onMouseClick(@NotNull Component component2, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onMouseClick(component2, null, runnable);
    }

    @NotNull
    public static MouseAdapter onMouseClick(@NotNull Component component2, final @Nullable MouseButton mouseButton, final @NotNull MouseEventRunnable runnable) {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(@NotNull MouseEvent e) {
                if (mouseButton == null || mouseButton == MouseButton.get(e)) {
                    runnable.run(e);
                }
            }
        };
        component2.addMouseListener(mouseAdapter);
        return mouseAdapter;
    }

    @NotNull
    public static MouseAdapter onDoubleClick(@NotNull Component component2, final @NotNull MouseEventRunnable runnable) {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(@NotNull MouseEvent e) {
                if (SwingUtils.isDoubleClick(e)) {
                    runnable.run(e);
                }
            }
        };
        component2.addMouseListener(mouseAdapter);
        return mouseAdapter;
    }

    @NotNull
    public static MouseAdapter onMenuTrigger(@NotNull Component component2, final @NotNull MouseEventRunnable runnable) {
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (SwingUtils.isRightMouseButton(e)) {
                    runnable.run(e);
                }
            }
        };
        component2.addMouseListener(mouseAdapter);
        return mouseAdapter;
    }

    @NotNull
    public static KeyAdapter onKeyType(@NotNull Component component2, @NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyType(component2, null, runnable);
    }

    @NotNull
    public static KeyAdapter onKeyType(@NotNull Component component2, final @Nullable HotkeyData hotkey, final @NotNull KeyEventRunnable runnable) {
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyTyped(@NotNull KeyEvent e) {
                if (hotkey == null || hotkey.isTriggered(e)) {
                    runnable.run(e);
                }
            }
        };
        component2.addKeyListener(keyAdapter);
        return keyAdapter;
    }

    @NotNull
    public static KeyAdapter onKeyPress(@NotNull Component component2, @NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyPress(component2, null, runnable);
    }

    @NotNull
    public static KeyAdapter onKeyPress(@NotNull Component component2, final @Nullable HotkeyData hotkey, final @NotNull KeyEventRunnable runnable) {
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(@NotNull KeyEvent e) {
                if (hotkey == null || hotkey.isTriggered(e)) {
                    runnable.run(e);
                }
            }
        };
        component2.addKeyListener(keyAdapter);
        return keyAdapter;
    }

    @NotNull
    public static KeyAdapter onKeyRelease(@NotNull Component component2, @NotNull KeyEventRunnable runnable) {
        return EventMethodsImpl.onKeyRelease(component2, null, runnable);
    }

    @NotNull
    public static KeyAdapter onKeyRelease(@NotNull Component component2, final @Nullable HotkeyData hotkey, final @NotNull KeyEventRunnable runnable) {
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(@NotNull KeyEvent e) {
                if (hotkey == null || hotkey.isTriggered(e)) {
                    runnable.run(e);
                }
            }
        };
        component2.addKeyListener(keyAdapter);
        return keyAdapter;
    }

    @NotNull
    public static FocusAdapter onFocusGain(@NotNull Component component2, final @NotNull FocusEventRunnable runnable) {
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusGained(@NotNull FocusEvent e) {
                runnable.run(e);
            }
        };
        component2.addFocusListener(focusAdapter);
        return focusAdapter;
    }

    @NotNull
    public static FocusAdapter onFocusLoss(@NotNull Component component2, final @NotNull FocusEventRunnable runnable) {
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(@NotNull FocusEvent e) {
                runnable.run(e);
            }
        };
        component2.addFocusListener(focusAdapter);
        return focusAdapter;
    }

    @NotNull
    public static MouseAdapter onDragStart(@NotNull Component component2, int shift, @NotNull MouseEventRunnable runnable) {
        return EventMethodsImpl.onDragStart(component2, shift, MouseButton.left, runnable);
    }

    @NotNull
    public static MouseAdapter onDragStart(@NotNull Component component2, final int shift, final @Nullable MouseButton mouseButton, final @NotNull MouseEventRunnable runnable) {
        MouseAdapter mouseAdapter = new MouseAdapter(){
            private Point start = null;

            @Override
            public void mousePressed(@NotNull MouseEvent e) {
                if (this.isButton(e)) {
                    this.start = e.getPoint();
                }
            }

            @Override
            public void mouseDragged(@NotNull MouseEvent e) {
                if (this.start != null && GeometryUtils.distance(this.start, e.getPoint()) > shift) {
                    runnable.run(e);
                    this.start = null;
                }
            }

            @Override
            public void mouseReleased(@NotNull MouseEvent e) {
                if (this.isButton(e) && this.start != null) {
                    this.start = null;
                }
            }

            private boolean isButton(@NotNull MouseEvent e) {
                return mouseButton == null || mouseButton == MouseButton.get(e);
            }
        };
        component2.addMouseListener(mouseAdapter);
        component2.addMouseMotionListener(mouseAdapter);
        return mouseAdapter;
    }
}

