/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.swing.menu;

import com.alee.api.annotations.NotNull;
import com.alee.api.annotations.Nullable;
import com.alee.managers.language.UILanguageManager;
import com.alee.managers.style.StyleId;
import com.alee.utils.swing.menu.AbstractMenuGenerator;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;

public class JMenuGenerator
extends AbstractMenuGenerator<JMenu> {
    public JMenuGenerator() {
        this(StyleId.auto);
    }

    public JMenuGenerator(@Nullable Icon icon) {
        this(StyleId.auto, icon);
    }

    public JMenuGenerator(@Nullable String text) {
        this(StyleId.auto, text);
    }

    public JMenuGenerator(@Nullable String text, @Nullable Icon icon) {
        this(StyleId.auto, text, icon);
    }

    public JMenuGenerator(@NotNull Action action) {
        this(StyleId.auto, action);
    }

    public JMenuGenerator(@NotNull StyleId id) {
        this(id, null, null);
    }

    public JMenuGenerator(@NotNull StyleId id, @Nullable Icon icon) {
        this(id, null, icon);
    }

    public JMenuGenerator(@NotNull StyleId id, @Nullable String text) {
        this(id, text, null);
    }

    public JMenuGenerator(@NotNull StyleId id, @Nullable String text, @Nullable Icon icon) {
        this(new JMenu(text));
        ((JMenu)this.getMenu()).setIcon(icon);
        id.set((JComponent)this.getMenu());
    }

    public JMenuGenerator(@NotNull StyleId id, @NotNull Action action) {
        this(new JMenu(action));
        id.set((JComponent)this.getMenu());
    }

    public JMenuGenerator(@NotNull JMenu menu) {
        super(menu);
    }

    @Override
    public void setLanguagePrefix(String prefix) {
        super.setLanguagePrefix(prefix);
        JMenu menu = (JMenu)this.getMenu();
        String text = menu.getText();
        String languageKey = this.getLanguageKey(text);
        if (languageKey != null) {
            UILanguageManager.registerComponent(menu, languageKey, new Object[0]);
        } else {
            UILanguageManager.unregisterComponent(menu);
            menu.setText(text);
        }
    }
}

