/*
 * Decompiled with CFR 0.152.
 */
package com.alee.utils.xml;

import com.alee.utils.TextUtils;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.Locale;

public final class LocaleConverter
implements Converter {
    @Override
    public boolean canConvert(Class type) {
        return Locale.class.getCanonicalName().equals(type.getCanonicalName());
    }

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        String variant;
        Locale locale = (Locale)source;
        writer.addAttribute("language", locale.getLanguage());
        String country = locale.getCountry();
        if (TextUtils.notEmpty(country)) {
            writer.addAttribute("country", country);
        }
        if (TextUtils.notEmpty(variant = locale.getVariant())) {
            writer.addAttribute("variant", variant);
        }
    }

    @Override
    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String language2 = reader.getAttribute("language");
        String country = reader.getAttribute("country");
        String variant = reader.getAttribute("variant");
        return new Locale(language2, TextUtils.notEmpty(country) ? country : "", TextUtils.notEmpty(variant) ? variant : "");
    }
}

