/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.html;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.html.WebColors;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;

@Deprecated
public class HtmlUtilities {
    public static final float DEFAULT_FONT_SIZE = 12.0f;
    private static HashMap<String, Float> sizes = new HashMap();
    public static final int[] FONTSIZES;

    public static float parseLength(String string) {
        return HtmlUtilities.parseLength(string, 12.0f);
    }

    public static float parseLength(String string, float actualFontSize) {
        if (string == null) {
            return 0.0f;
        }
        Float fl = sizes.get(string.toLowerCase());
        if (fl != null) {
            return fl.floatValue();
        }
        int pos = 0;
        int length = string.length();
        boolean ok = true;
        block3: while (ok && pos < length) {
            switch (string.charAt(pos)) {
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    ++pos;
                    continue block3;
                }
            }
            ok = false;
        }
        if (pos == 0) {
            return 0.0f;
        }
        if (pos == length) {
            return Float.parseFloat(string + "f");
        }
        float f = Float.parseFloat(string.substring(0, pos) + "f");
        if ((string = string.substring(pos)).startsWith("in")) {
            return f * 72.0f;
        }
        if (string.startsWith("cm")) {
            return f / 2.54f * 72.0f;
        }
        if (string.startsWith("mm")) {
            return f / 25.4f * 72.0f;
        }
        if (string.startsWith("pc")) {
            return f * 12.0f;
        }
        if (string.startsWith("em")) {
            return f * actualFontSize;
        }
        if (string.startsWith("ex")) {
            return f * actualFontSize / 2.0f;
        }
        return f;
    }

    public static BaseColor decodeColor(String s) {
        if (s == null) {
            return null;
        }
        s = s.toLowerCase().trim();
        try {
            return WebColors.getRGBColor(s);
        }
        catch (IllegalArgumentException iae) {
            return null;
        }
    }

    public static Properties parseAttributes(String string) {
        Properties result2 = new Properties();
        if (string == null) {
            return result2;
        }
        StringTokenizer keyValuePairs = new StringTokenizer(string, ";");
        while (keyValuePairs.hasMoreTokens()) {
            StringTokenizer keyValuePair = new StringTokenizer(keyValuePairs.nextToken(), ":");
            if (!keyValuePair.hasMoreTokens()) continue;
            String key = keyValuePair.nextToken().trim();
            if (!keyValuePair.hasMoreTokens()) continue;
            String value = keyValuePair.nextToken().trim();
            if (value.startsWith("\"")) {
                value = value.substring(1);
            }
            if (value.endsWith("\"")) {
                value = value.substring(0, value.length() - 1);
            }
            result2.setProperty(key.toLowerCase(), value);
        }
        return result2;
    }

    public static String removeComment(String string, String startComment, String endComment) {
        StringBuffer result2 = new StringBuffer();
        int pos = 0;
        int end = endComment.length();
        int start2 = string.indexOf(startComment, pos);
        while (start2 > -1) {
            result2.append(string.substring(pos, start2));
            pos = string.indexOf(endComment, start2) + end;
            start2 = string.indexOf(startComment, pos);
        }
        result2.append(string.substring(pos));
        return result2.toString();
    }

    public static String eliminateWhiteSpace(String content) {
        StringBuffer buf2 = new StringBuffer();
        int len = content.length();
        boolean newline = false;
        block6: for (int i = 0; i < len; ++i) {
            char character = content.charAt(i);
            switch (character) {
                case ' ': {
                    if (newline) continue block6;
                    buf2.append(character);
                    continue block6;
                }
                case '\n': {
                    if (i <= 0) continue block6;
                    newline = true;
                    buf2.append(' ');
                    continue block6;
                }
                case '\r': {
                    continue block6;
                }
                case '\t': {
                    continue block6;
                }
                default: {
                    newline = false;
                    buf2.append(character);
                }
            }
        }
        return buf2.toString();
    }

    public static int getIndexedFontSize(String value, String previous) {
        int sIndex = 0;
        if (value.startsWith("+") || value.startsWith("-")) {
            if (previous == null) {
                previous = "12";
            }
            int c = (int)Float.parseFloat(previous);
            for (int k = FONTSIZES.length - 1; k >= 0; --k) {
                if (c < FONTSIZES[k]) continue;
                sIndex = k;
                break;
            }
            int diff = Integer.parseInt(value.startsWith("+") ? value.substring(1) : value);
            sIndex += diff;
        } else {
            try {
                sIndex = Integer.parseInt(value) - 1;
            }
            catch (NumberFormatException nfe) {
                sIndex = 0;
            }
        }
        if (sIndex < 0) {
            sIndex = 0;
        } else if (sIndex >= FONTSIZES.length) {
            sIndex = FONTSIZES.length - 1;
        }
        return FONTSIZES[sIndex];
    }

    public static int alignmentValue(String alignment) {
        if (alignment == null) {
            return -1;
        }
        if ("center".equalsIgnoreCase(alignment)) {
            return 1;
        }
        if ("left".equalsIgnoreCase(alignment)) {
            return 0;
        }
        if ("right".equalsIgnoreCase(alignment)) {
            return 2;
        }
        if ("justify".equalsIgnoreCase(alignment)) {
            return 3;
        }
        if ("JustifyAll".equalsIgnoreCase(alignment)) {
            return 8;
        }
        if ("top".equalsIgnoreCase(alignment)) {
            return 4;
        }
        if ("middle".equalsIgnoreCase(alignment)) {
            return 5;
        }
        if ("bottom".equalsIgnoreCase(alignment)) {
            return 6;
        }
        if ("baseline".equalsIgnoreCase(alignment)) {
            return 7;
        }
        return -1;
    }

    static {
        sizes.put("xx-small", new Float(4.0f));
        sizes.put("x-small", new Float(6.0f));
        sizes.put("small", new Float(8.0f));
        sizes.put("medium", new Float(10.0f));
        sizes.put("large", new Float(13.0f));
        sizes.put("x-large", new Float(18.0f));
        sizes.put("xx-large", new Float(26.0f));
        FONTSIZES = new int[]{8, 10, 12, 14, 18, 24, 36};
    }
}

